/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore;

import java.io.Serializable;
import java.util.List;
import org.apache.carbondata.core.cache.Cacheable;
import org.apache.carbondata.core.index.dev.Index;
import org.apache.carbondata.core.indexstore.blockletindex.BlockIndex;

public class BlockletIndexWrapper
implements Cacheable,
Serializable {
    private static final long serialVersionUID = -2859075086955465810L;
    private List<BlockIndex> indexes;
    private String segmentId;
    private long wrapperSize;

    public BlockletIndexWrapper(String segmentId, List<BlockIndex> indexes) {
        this.indexes = indexes;
        this.wrapperSize = 0L;
        this.segmentId = segmentId;
        for (BlockIndex index : indexes) {
            this.wrapperSize += index.getMemorySize();
        }
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public long getMemorySize() {
        return this.wrapperSize;
    }

    @Override
    public void invalidate() {
        for (Index index : this.indexes) {
            index.clear();
        }
    }

    public List<BlockIndex> getIndexes() {
        return this.indexes;
    }

    public String getSegmentId() {
        return this.segmentId;
    }
}

