/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.indexstore.Blocklet;
import org.apache.carbondata.core.indexstore.BlockletDetailInfo;
import org.apache.carbondata.core.indexstore.row.IndexRow;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.stream.ExtendedByteArrayOutputStream;
import org.apache.carbondata.hadoop.CarbonInputSplit;

public class ExtendedBlocklet
extends Blocklet {
    private String indexUniqueId;
    private CarbonInputSplit inputSplit;
    private Long count;
    private String segmentNo;

    public ExtendedBlocklet() {
    }

    public ExtendedBlocklet(String filePath, String blockletId, boolean compareBlockletIdForObjectMatching, ColumnarFormatVersion version) {
        super(filePath, blockletId, compareBlockletIdForObjectMatching);
        this.inputSplit = CarbonInputSplit.from(null, blockletId, filePath, 0L, -1L, version, null);
    }

    public ExtendedBlocklet(String filePath, String blockletId, ColumnarFormatVersion version) {
        this(filePath, blockletId, true, version);
    }

    public BlockletDetailInfo getDetailInfo() {
        return this.inputSplit.getDetailInfo();
    }

    public void setIndexRow(IndexRow indexRow) {
        this.inputSplit.setIndexRow(indexRow);
    }

    public String[] getLocations() {
        try {
            return this.inputSplit.getLocations();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getLength() {
        return this.inputSplit.getLength();
    }

    public String getSegmentId() {
        if (this.segmentNo != null) {
            return this.segmentNo;
        }
        return this.inputSplit.getSegmentId();
    }

    public Segment getSegment() {
        return this.inputSplit.getSegment();
    }

    public void setSegment(Segment segment) {
        this.inputSplit.setSegment(segment);
    }

    public String getPath() {
        return this.getFilePath();
    }

    public Long getRowCount() {
        if (this.count != null) {
            return this.count;
        }
        return this.inputSplit.getRowCount();
    }

    public void setIndexWriterPath(String indexWriterPath) {
        this.inputSplit.setIndexWritePath(indexWriterPath);
    }

    public String getIndexUniqueId() {
        return this.indexUniqueId;
    }

    public void setIndexUniqueId(String indexUniqueId) {
        this.indexUniqueId = indexUniqueId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtendedBlocklet that = (ExtendedBlocklet)o;
        return this.inputSplit.getSegmentId() != null ? this.inputSplit.getSegmentId().equals(that.inputSplit.getSegmentId()) : that.inputSplit.getSegmentId() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.inputSplit.getSegmentId() != null ? this.inputSplit.getSegmentId().hashCode() : 0);
        return result;
    }

    public CarbonInputSplit getInputSplit() {
        return this.inputSplit;
    }

    public void setUseMinMaxForPruning(boolean useMinMaxForPruning) {
        this.inputSplit.setUseMinMaxForPruning(useMinMaxForPruning);
    }

    public void setIsBlockCache(boolean isBlockCache) {
        this.inputSplit.setIsBlockCache(isBlockCache);
    }

    public void setColumnSchema(List<ColumnSchema> columnSchema) {
        this.inputSplit.setColumnSchema(columnSchema);
    }

    public void serializeData(DataOutput out, Map<String, Short> uniqueLocation, boolean isCountJob) throws IOException {
        super.write(out);
        if (isCountJob) {
            out.writeLong(this.inputSplit.getIndexRow().getInt(2));
            out.writeUTF(this.inputSplit.getSegmentId());
        } else {
            if (this.indexUniqueId == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.indexUniqueId);
            }
            out.writeBoolean(this.inputSplit != null);
            if (this.inputSplit != null) {
                ExtendedByteArrayOutputStream ebos = new ExtendedByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(ebos);
                this.inputSplit.setFilePath(null);
                this.inputSplit.setBucketId(null);
                if (this.inputSplit.isBlockCache()) {
                    this.inputSplit.updateFooteroffset();
                    this.inputSplit.updateBlockLength();
                    this.inputSplit.setWriteDetailInfo(false);
                }
                this.inputSplit.serializeFields(dos, uniqueLocation);
                out.writeInt(ebos.size());
                out.write(ebos.getBuffer(), 0, ebos.size());
            }
        }
    }

    public void deserializeFields(DataInput in, String[] locations, String tablePath, boolean isCountJob) throws IOException {
        super.readFields(in);
        if (isCountJob) {
            this.count = in.readLong();
            this.segmentNo = in.readUTF();
            return;
        }
        if (in.readBoolean()) {
            this.indexUniqueId = in.readUTF();
        }
        this.setFilePath(tablePath + this.getPath());
        boolean isSplitPresent = in.readBoolean();
        if (isSplitPresent) {
            int serializeLen = in.readInt();
            this.inputSplit = new CarbonInputSplit(serializeLen, in, this.getFilePath(), locations, this.getBlockletId());
        }
    }
}

