/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.compression.SnappyCompressor;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.metadata.schema.table.Writable;
import org.apache.carbondata.core.stream.ExtendedByteArrayInputStream;
import org.apache.carbondata.core.stream.ExtendedByteArrayOutputStream;
import org.apache.carbondata.core.stream.ExtendedDataInputStream;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.log4j.Logger;

public class ExtendedBlockletWrapper
implements Writable,
Serializable {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)ExtendedBlockletWrapper.class.getName());
    private static final int BUFFER_SIZE = 0x800000;
    private static final int BLOCK_SIZE = 0x10000000;
    private boolean isWrittenToFile;
    private int dataSize;
    private byte[] bytes;

    public ExtendedBlockletWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedBlockletWrapper(List<ExtendedBlocklet> extendedBlockletList, String tablePath, String queryId, boolean isWriteToFile, boolean isCountJob) {
        HashMap<String, Short> uniqueLocations = new HashMap<String, Short>();
        byte[] bytes = this.convertToBytes(tablePath, uniqueLocations, extendedBlockletList, isCountJob);
        int serializeAllowedSize = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.index.server.inmemory.serialization.threshold.inKB", "300")) * 1024;
        DataOutputStream stream = null;
        if (bytes.length > serializeAllowedSize && isWriteToFile) {
            block11: {
                String fileName = UUID.randomUUID().toString();
                String folderPath = CarbonUtil.getIndexServerTempPath() + "/" + queryId;
                try {
                    CarbonFile carbonFile = FileFactory.getCarbonFile(folderPath);
                    boolean isFolderExists = true;
                    if (!carbonFile.isFileExist()) {
                        LOGGER.warn((Object)("Folder:" + folderPath + "doesn't exists, data will be send through netwrok"));
                        isFolderExists = false;
                    }
                    if (!isFolderExists) break block11;
                    stream = FileFactory.getDataOutputStream(folderPath + "/" + fileName, 0x800000, 0x10000000L, (short)1);
                    this.writeBlockletToStream(stream, bytes, uniqueLocations, extendedBlockletList);
                    this.dataSize = stream.size();
                    this.bytes = fileName.getBytes("UTF-8");
                    this.isWrittenToFile = true;
                }
                catch (IOException e) {
                    try {
                        LOGGER.error((Object)"Problem while writing to file, data will be sent through network", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        CarbonUtil.closeStreams(stream);
                        throw throwable;
                    }
                    CarbonUtil.closeStreams(stream);
                }
            }
            CarbonUtil.closeStreams(stream);
        }
        if (!this.isWrittenToFile) {
            try {
                ExtendedByteArrayOutputStream bos = new ExtendedByteArrayOutputStream();
                stream = new DataOutputStream(bos);
                this.writeBlockletToStream(stream, bytes, uniqueLocations, extendedBlockletList);
                this.dataSize = bos.size();
                this.bytes = bos.getBuffer();
            }
            catch (IOException e) {
                try {
                    LOGGER.error((Object)"Problem while writing data to memory stream", (Throwable)e);
                }
                catch (Throwable throwable) {
                    CarbonUtil.closeStreams(stream);
                    throw throwable;
                }
                CarbonUtil.closeStreams(stream);
            }
            CarbonUtil.closeStreams(stream);
        }
    }

    private byte[] convertToBytes(String tablePath, Map<String, Short> uniqueLocations, List<ExtendedBlocklet> extendedBlockletList, boolean isCountJob) {
        byte[] byArray;
        ExtendedByteArrayOutputStream bos = new ExtendedByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(bos);
        try {
            for (ExtendedBlocklet extendedBlocklet : extendedBlockletList) {
                extendedBlocklet.setFilePath(extendedBlocklet.getFilePath().replace(tablePath, ""));
                extendedBlocklet.serializeData(stream, uniqueLocations, isCountJob);
            }
            byte[] input = bos.toByteArray();
            byArray = new SnappyCompressor().compressByte(input, input.length);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams(stream);
                throw throwable;
            }
        }
        CarbonUtil.closeStreams(stream);
        return byArray;
    }

    private void writeBlockletToStream(DataOutputStream stream, byte[] data, Map<String, Short> uniqueLocation, List<ExtendedBlocklet> extendedBlockletList) throws IOException {
        stream.writeInt(extendedBlockletList.size());
        String[] uniqueLoc = new String[uniqueLocation.size()];
        for (Map.Entry<String, Short> next : uniqueLocation.entrySet()) {
            uniqueLoc[next.getValue().shortValue()] = next.getKey();
        }
        stream.writeShort((short)uniqueLoc.length);
        for (String loc : uniqueLoc) {
            stream.writeUTF(loc);
        }
        stream.writeInt(data.length);
        stream.write(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExtendedBlocklet> readBlocklet(String tablePath, String queryId, boolean isCountJob) throws IOException {
        block8: {
            int actualDataLen;
            String[] locations;
            int numberOfBlocklet;
            byte[] data;
            DataInputStream stream;
            block10: {
                block9: {
                    if (this.bytes == null) break block8;
                    if (!this.isWrittenToFile) break block9;
                    stream = null;
                    try {
                        String folderPath = CarbonUtil.getIndexServerTempPath() + "/" + queryId;
                        String fileName = new String(this.bytes, "UTF-8");
                        stream = FileFactory.getDataInputStream(folderPath + "/" + fileName);
                        data = new byte[this.dataSize];
                        stream.readFully(data);
                    }
                    catch (Throwable throwable) {
                        CarbonUtil.closeStreams(stream);
                        throw throwable;
                    }
                    CarbonUtil.closeStreams(stream);
                    break block10;
                }
                data = this.bytes;
            }
            stream = null;
            try {
                stream = new DataInputStream(new ByteArrayInputStream(data));
                numberOfBlocklet = stream.readInt();
                int numberOfLocations = stream.readShort();
                locations = new String[numberOfLocations];
                for (int i = 0; i < numberOfLocations; ++i) {
                    locations[i] = stream.readUTF();
                }
                actualDataLen = stream.readInt();
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams(stream);
                throw throwable;
            }
            CarbonUtil.closeStreams(stream);
            byte[] unCompressByte = new SnappyCompressor().unCompressByte(data, this.dataSize - actualDataLen, actualDataLen);
            ExtendedByteArrayInputStream ebis = new ExtendedByteArrayInputStream(unCompressByte);
            ExtendedDataInputStream eDIS = new ExtendedDataInputStream(ebis);
            ArrayList<ExtendedBlocklet> extendedBlockletList = new ArrayList<ExtendedBlocklet>();
            try {
                for (int i = 0; i < numberOfBlocklet; ++i) {
                    ExtendedBlocklet extendedBlocklet = new ExtendedBlocklet();
                    extendedBlocklet.deserializeFields(eDIS, locations, tablePath, isCountJob);
                    extendedBlockletList.add(extendedBlocklet);
                }
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams(eDIS);
                throw throwable;
            }
            CarbonUtil.closeStreams(eDIS);
            return extendedBlockletList;
        }
        return new ArrayList<ExtendedBlocklet>();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isWrittenToFile);
        out.writeBoolean(this.bytes != null);
        if (this.bytes != null) {
            out.writeInt(this.bytes.length);
            out.write(this.bytes);
        }
        out.writeInt(this.dataSize);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.isWrittenToFile = in.readBoolean();
        if (in.readBoolean()) {
            this.bytes = new byte[in.readInt()];
            in.readFully(this.bytes);
        }
        this.dataSize = in.readInt();
    }
}

