/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.indexstore.ExtendedBlockletWrapper;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class ExtendedBlockletWrapperContainer
implements Writable {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)ExtendedBlockletWrapperContainer.class.getName());
    private ExtendedBlockletWrapper[] extendedBlockletWrappers;
    private boolean isFallbackJob;

    public ExtendedBlockletWrapperContainer() {
    }

    public ExtendedBlockletWrapperContainer(ExtendedBlockletWrapper[] extendedBlockletWrappers, boolean isFallbackJob) {
        this.extendedBlockletWrappers = extendedBlockletWrappers;
        this.isFallbackJob = isFallbackJob;
    }

    public List<ExtendedBlocklet> getExtendedBlockets(String tablePath, String queryId, boolean isCountJob) throws IOException {
        if (!this.isFallbackJob) {
            int numOfThreads = CarbonProperties.getNumOfThreadsForPruning();
            ExecutorService executorService = Executors.newFixedThreadPool(numOfThreads, new CarbonThreadFactory("SplitDeseralizerPool", true));
            int numberOfWrapperPerThread = this.extendedBlockletWrappers.length / numOfThreads;
            int leftOver = this.extendedBlockletWrappers.length % numOfThreads;
            int[] split = null;
            split = numberOfWrapperPerThread > 0 ? new int[numOfThreads] : new int[leftOver];
            Arrays.fill(split, numberOfWrapperPerThread);
            int i = 0;
            while (i < leftOver) {
                int n = i++;
                split[n] = split[n] + 1;
            }
            int start = 0;
            int end = 0;
            ArrayList<Future<List<ExtendedBlocklet>>> futures = new ArrayList<Future<List<ExtendedBlocklet>>>();
            for (int i2 = 0; i2 < split.length; ++i2) {
                futures.add(executorService.submit(new ExtendedBlockletDeserializerThread(start, end += split[i2], tablePath, queryId, isCountJob)));
                start += split[i2];
            }
            executorService.shutdown();
            try {
                executorService.awaitTermination(1L, TimeUnit.HOURS);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)e);
                throw new RuntimeException(e);
            }
            ArrayList<ExtendedBlocklet> extendedBlocklets = new ArrayList<ExtendedBlocklet>();
            for (int i3 = 0; i3 < futures.size(); ++i3) {
                try {
                    extendedBlocklets.addAll((Collection)((Future)futures.get(i3)).get());
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.error((Object)e);
                    throw new RuntimeException(e);
                }
            }
            return extendedBlocklets;
        }
        ArrayList<ExtendedBlocklet> extendedBlocklets = new ArrayList<ExtendedBlocklet>();
        for (ExtendedBlockletWrapper extendedBlockletWrapper : this.extendedBlockletWrappers) {
            extendedBlocklets.addAll(extendedBlockletWrapper.readBlocklet(tablePath, queryId, isCountJob));
        }
        return extendedBlocklets;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.extendedBlockletWrappers.length);
        for (int i = 0; i < this.extendedBlockletWrappers.length; ++i) {
            this.extendedBlockletWrappers[i].write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.extendedBlockletWrappers = new ExtendedBlockletWrapper[in.readInt()];
        for (int i = 0; i < this.extendedBlockletWrappers.length; ++i) {
            ExtendedBlockletWrapper extendedBlockletWrapper = new ExtendedBlockletWrapper();
            extendedBlockletWrapper.readFields(in);
            this.extendedBlockletWrappers[i] = extendedBlockletWrapper;
        }
    }

    private class ExtendedBlockletDeserializerThread
    implements Callable<List<ExtendedBlocklet>> {
        private int start;
        private int end;
        private String tablePath;
        private String queryId;
        private boolean isCountJob;

        public ExtendedBlockletDeserializerThread(int start, int end, String tablePath, String queryId, boolean isCountJob) {
            this.start = start;
            this.end = end;
            this.tablePath = tablePath;
            this.queryId = queryId;
            this.isCountJob = isCountJob;
        }

        @Override
        public List<ExtendedBlocklet> call() throws Exception {
            ArrayList<ExtendedBlocklet> extendedBlocklets = new ArrayList<ExtendedBlocklet>();
            for (int i = this.start; i < this.end; ++i) {
                extendedBlocklets.addAll(ExtendedBlockletWrapperContainer.this.extendedBlockletWrappers[i].readBlocklet(this.tablePath, this.queryId, this.isCountJob));
            }
            return extendedBlocklets;
        }
    }
}

