/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;

public class PartitionSpec
implements Serializable,
Writable {
    private static final long serialVersionUID = 4828007433384867678L;
    private List<String> partitions;
    private transient Path locationPath;
    private String location;
    private String uuid;

    public PartitionSpec() {
    }

    public PartitionSpec(List<String> partitions, String location) {
        this.partitions = partitions;
        this.locationPath = new Path(FileFactory.getUpdatedFilePath(location));
        this.location = this.locationPath.toString();
    }

    public PartitionSpec(List<String> partitions, URI location) {
        this.partitions = partitions;
        this.locationPath = new Path(FileFactory.getUpdatedFilePath(new Path(location).toString()));
        this.location = this.locationPath.toString();
    }

    public List<String> getPartitions() {
        return this.partitions;
    }

    public Path getLocation() {
        if (this.locationPath == null) {
            this.locationPath = new Path(this.location);
        }
        return this.locationPath;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionSpec spec = (PartitionSpec)o;
        return Objects.equals(this.getLocation(), spec.getLocation());
    }

    public int hashCode() {
        return Objects.hash(this.locationPath);
    }

    public String toString() {
        return "PartitionSpec{partitions=" + this.partitions + ", locationPath=" + this.locationPath + ", location='" + this.location + '\'' + '}';
    }

    public void write(DataOutput out) throws IOException {
        if (this.partitions == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.partitions.size());
            for (String partition : this.partitions) {
                out.writeUTF(partition);
            }
        }
        if (this.uuid == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.uuid);
        }
        if (this.location == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.location);
        }
    }

    public void readFields(DataInput in) throws IOException {
        if (in.readBoolean()) {
            int numPartitions = in.readInt();
            this.partitions = new ArrayList<String>(numPartitions);
            for (int i = 0; i < numPartitions; ++i) {
                this.partitions.add(in.readUTF());
            }
        }
        if (in.readBoolean()) {
            this.uuid = in.readUTF();
        }
        if (in.readBoolean()) {
            this.location = in.readUTF();
        }
    }
}

