/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore;

import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.indexstore.AbstractMemoryDMStore;
import org.apache.carbondata.core.indexstore.UnsafeMemoryDMStore;
import org.apache.carbondata.core.indexstore.row.IndexRow;
import org.apache.carbondata.core.indexstore.schema.CarbonRowSchema;
import org.apache.carbondata.core.util.DataTypeUtil;

public class SafeMemoryDMStore
extends AbstractMemoryDMStore {
    private List<IndexRow> indexRows = new ArrayList<IndexRow>(16);
    private int runningLength;

    @Override
    public void addIndexRow(CarbonRowSchema[] schema, IndexRow indexRow) {
        this.indexRows.add(indexRow);
        this.runningLength += indexRow.getTotalSizeInBytes();
    }

    @Override
    public IndexRow getIndexRow(CarbonRowSchema[] schema, int index) {
        assert (index < this.indexRows.size());
        return this.indexRows.get(index);
    }

    @Override
    public void freeMemory() {
        if (!this.isMemoryFreed) {
            if (null != this.indexRows) {
                this.indexRows.clear();
            }
            this.isMemoryFreed = true;
        }
    }

    @Override
    public int getMemoryUsed() {
        return this.runningLength;
    }

    @Override
    public int getRowCount() {
        return this.indexRows.size();
    }

    @Override
    public UnsafeMemoryDMStore convertToUnsafeDMStore(CarbonRowSchema[] schema) {
        this.setSchemaDataType(schema);
        UnsafeMemoryDMStore unsafeMemoryDMStore = new UnsafeMemoryDMStore();
        for (IndexRow indexRow : this.indexRows) {
            indexRow.setSchemas(schema);
            unsafeMemoryDMStore.addIndexRow(schema, indexRow);
        }
        unsafeMemoryDMStore.finishWriting();
        return unsafeMemoryDMStore;
    }

    private void setSchemaDataType(CarbonRowSchema[] schema) {
        for (CarbonRowSchema carbonRowSchema : schema) {
            carbonRowSchema.setDataType(DataTypeUtil.valueOf(carbonRowSchema.getDataType(), 0, 0));
        }
    }
}

