/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.index.Segment;
import org.apache.hadoop.io.Writable;

public class SegmentWrapper
implements Writable,
Serializable {
    private List<Segment> segments;

    public SegmentWrapper() {
    }

    public SegmentWrapper(List<Segment> segments) {
        this.segments = segments;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.segments.size());
        for (Segment segment : this.segments) {
            segment.write(dataOutput);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        int size = dataInput.readInt();
        this.segments = new ArrayList<Segment>(size);
        for (int i = 0; i < size; ++i) {
            Segment segment = new Segment();
            segment.readFields(dataInput);
            this.segments.add(segment);
        }
    }
}

