/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.indexstore.SegmentWrapper;
import org.apache.hadoop.io.Writable;

public class SegmentWrapperContainer
implements Writable {
    private SegmentWrapper[] segmentWrappers;

    public SegmentWrapperContainer(SegmentWrapper[] segmentWrappers) {
        this.segmentWrappers = segmentWrappers;
    }

    public List<Segment> getSegments() {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (SegmentWrapper segmentWrapper : this.segmentWrappers) {
            segments.addAll(segmentWrapper.getSegments());
        }
        return segments;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.segmentWrappers.length);
        for (SegmentWrapper segmentWrapper : this.segmentWrappers) {
            segmentWrapper.write(dataOutput);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        int numOfWrappers = dataInput.readInt();
        this.segmentWrappers = new SegmentWrapper[numOfWrappers];
        for (int i = 0; i < numOfWrappers; ++i) {
            SegmentWrapper segmentWrapper = new SegmentWrapper();
            segmentWrapper.readFields(dataInput);
            this.segmentWrappers[i] = segmentWrapper;
        }
    }
}

