/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore;

import java.io.Serializable;
import java.util.Objects;

public class TableBlockIndexUniqueIdentifier
implements Serializable {
    private static final long serialVersionUID = 5808112137916196344L;
    private String indexFilePath;
    private String indexFileName;
    private String mergeIndexFileName;
    private String segmentId;
    private String uniqueName;

    public TableBlockIndexUniqueIdentifier(String indexFilePath, String indexFileName, String mergeIndexFileName, String segmentId) {
        this.indexFilePath = indexFilePath;
        this.indexFileName = indexFileName;
        this.mergeIndexFileName = mergeIndexFileName;
        this.segmentId = segmentId;
        this.uniqueName = indexFilePath + "/" + indexFileName;
    }

    public TableBlockIndexUniqueIdentifier(String segmentId) {
        this.segmentId = segmentId;
    }

    public String getUniqueTableSegmentIdentifier() {
        return this.uniqueName;
    }

    public String getIndexFilePath() {
        return this.indexFilePath;
    }

    public String getIndexFileName() {
        return this.indexFileName;
    }

    public String getMergeIndexFileName() {
        return this.mergeIndexFileName;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableBlockIndexUniqueIdentifier that = (TableBlockIndexUniqueIdentifier)o;
        return Objects.equals(this.indexFilePath, that.indexFilePath) && Objects.equals(this.indexFileName, that.indexFileName) && Objects.equals(this.mergeIndexFileName, that.mergeIndexFileName);
    }

    public int hashCode() {
        return Objects.hash(this.indexFilePath, this.indexFileName, this.mergeIndexFileName);
    }
}

