/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore;

import org.apache.carbondata.core.indexstore.AbstractMemoryDMStore;
import org.apache.carbondata.core.indexstore.row.IndexRow;
import org.apache.carbondata.core.indexstore.row.UnsafeIndexRow;
import org.apache.carbondata.core.indexstore.schema.CarbonRowSchema;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.memory.MemoryBlock;
import org.apache.carbondata.core.memory.MemoryType;
import org.apache.carbondata.core.memory.UnsafeMemoryManager;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;

public class UnsafeMemoryDMStore
extends AbstractMemoryDMStore {
    private static final long serialVersionUID = -5344592407101055335L;
    private transient MemoryBlock memoryBlock;
    private static int capacity = 8192;
    private int allocatedSize = capacity;
    private int runningLength;
    private int[] pointers;
    private int rowCount;
    private byte[] data;

    public UnsafeMemoryDMStore() {
        this.memoryBlock = UnsafeMemoryManager.allocateMemoryWithRetry(MemoryType.ONHEAP, this.taskId, this.allocatedSize);
        this.pointers = new int[100];
    }

    private void ensureSize(int rowSize) {
        if (this.runningLength + rowSize >= this.allocatedSize) {
            this.increaseMemory(this.runningLength + rowSize);
        }
        if (this.pointers.length <= this.rowCount + 1) {
            int[] newPointer = new int[this.pointers.length + 100];
            System.arraycopy(this.pointers, 0, newPointer, 0, this.pointers.length);
            this.pointers = newPointer;
        }
    }

    private void increaseMemory(int requiredMemory) {
        MemoryBlock newMemoryBlock = UnsafeMemoryManager.allocateMemoryWithRetry(MemoryType.ONHEAP, this.taskId, this.allocatedSize + requiredMemory);
        CarbonUnsafe.getUnsafe().copyMemory(this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset(), newMemoryBlock.getBaseObject(), newMemoryBlock.getBaseOffset(), this.runningLength);
        UnsafeMemoryManager.INSTANCE.freeMemory(this.taskId, this.memoryBlock);
        this.allocatedSize += requiredMemory;
        this.memoryBlock = newMemoryBlock;
    }

    @Override
    public void addIndexRow(CarbonRowSchema[] schema, IndexRow indexRow) {
        int rowSize = indexRow.getTotalSizeInBytes();
        this.ensureSize(rowSize);
        int pointer = this.runningLength;
        int bytePosition = 0;
        block6: for (int i = 0; i < schema.length; ++i) {
            switch (schema[i].getSchemaType()) {
                case STRUCT: {
                    CarbonRowSchema[] childSchemas = ((CarbonRowSchema.StructCarbonRowSchema)schema[i]).getChildSchemas();
                    for (int j = 0; j < childSchemas.length; ++j) {
                        if (childSchemas[j].getBytePosition() <= bytePosition) continue;
                        bytePosition = childSchemas[j].getBytePosition();
                    }
                    continue block6;
                }
                default: {
                    if (schema[i].getBytePosition() <= bytePosition) continue block6;
                    bytePosition = schema[i].getBytePosition();
                }
            }
        }
        int varColPosition = (bytePosition += 4) + 4;
        block8: for (int i = 0; i < schema.length; ++i) {
            switch (schema[i].getSchemaType()) {
                case STRUCT: {
                    int currentPosition;
                    CarbonRowSchema[] childSchemas = ((CarbonRowSchema.StructCarbonRowSchema)schema[i]).getChildSchemas();
                    IndexRow row = indexRow.getRow(i);
                    for (int j = 0; j < childSchemas.length; ++j) {
                        currentPosition = this.addToUnsafe(childSchemas[j], row, j, pointer, varColPosition);
                        if (currentPosition <= 0) continue;
                        varColPosition = currentPosition;
                    }
                    continue block8;
                }
                default: {
                    int currentPosition = this.addToUnsafe(schema[i], indexRow, i, pointer, varColPosition);
                    if (currentPosition <= 0) continue block8;
                    varColPosition = currentPosition;
                }
            }
        }
        CarbonUnsafe.getUnsafe().putInt(this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset() + (long)pointer + (long)bytePosition, varColPosition);
        this.runningLength += 4;
        this.pointers[this.rowCount++] = pointer;
    }

    private int addToUnsafe(CarbonRowSchema schema, IndexRow row, int index, int startOffset, int varPosition) {
        switch (schema.getSchemaType()) {
            case FIXED: {
                DataType dataType = schema.getDataType();
                if (dataType == DataTypes.BYTE) {
                    CarbonUnsafe.getUnsafe().putByte(this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset() + (long)startOffset + (long)schema.getBytePosition(), row.getByte(index));
                    this.runningLength += row.getSizeInBytes(index);
                } else if (dataType == DataTypes.BOOLEAN) {
                    CarbonUnsafe.getUnsafe().putBoolean(this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset() + (long)startOffset + (long)schema.getBytePosition(), row.getBoolean(index));
                    this.runningLength += row.getSizeInBytes(index);
                } else if (dataType == DataTypes.SHORT) {
                    CarbonUnsafe.getUnsafe().putShort(this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset() + (long)startOffset + (long)schema.getBytePosition(), row.getShort(index));
                    this.runningLength += row.getSizeInBytes(index);
                } else if (dataType == DataTypes.INT) {
                    CarbonUnsafe.getUnsafe().putInt(this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset() + (long)startOffset + (long)schema.getBytePosition(), row.getInt(index));
                    this.runningLength += row.getSizeInBytes(index);
                } else if (dataType == DataTypes.LONG) {
                    CarbonUnsafe.getUnsafe().putLong(this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset() + (long)startOffset + (long)schema.getBytePosition(), row.getLong(index));
                    this.runningLength += row.getSizeInBytes(index);
                } else if (dataType == DataTypes.FLOAT) {
                    CarbonUnsafe.getUnsafe().putFloat(this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset() + (long)startOffset + (long)schema.getBytePosition(), row.getFloat(index));
                    this.runningLength += row.getSizeInBytes(index);
                } else if (dataType == DataTypes.DOUBLE) {
                    CarbonUnsafe.getUnsafe().putDouble(this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset() + (long)startOffset + (long)schema.getBytePosition(), row.getDouble(index));
                    this.runningLength += row.getSizeInBytes(index);
                } else if (dataType == DataTypes.BYTE_ARRAY) {
                    byte[] data = row.getByteArray(index);
                    CarbonUnsafe.getUnsafe().copyMemory(data, CarbonUnsafe.BYTE_ARRAY_OFFSET, this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset() + (long)startOffset + (long)schema.getBytePosition(), data.length);
                    this.runningLength += row.getSizeInBytes(index);
                } else {
                    throw new UnsupportedOperationException("unsupported data type for unsafe storage: " + schema.getDataType());
                }
                return 0;
            }
            case VARIABLE_SHORT: 
            case VARIABLE_INT: {
                byte[] data = row.getByteArray(index);
                CarbonUnsafe.getUnsafe().putInt(this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset() + (long)startOffset + (long)schema.getBytePosition(), varPosition);
                this.runningLength += 4;
                if (data != null) {
                    CarbonUnsafe.getUnsafe().copyMemory(data, CarbonUnsafe.BYTE_ARRAY_OFFSET, this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset() + (long)startOffset + (long)varPosition, data.length);
                    this.runningLength += data.length;
                    varPosition += data.length;
                }
                return varPosition;
            }
        }
        throw new UnsupportedOperationException("unsupported data type for unsafe storage: " + schema.getDataType());
    }

    @Override
    public IndexRow getIndexRow(CarbonRowSchema[] schema, int index) {
        assert (index < this.rowCount);
        return new UnsafeIndexRow(schema, this.memoryBlock, this.pointers[index]);
    }

    @Override
    public void finishWriting() {
        if (this.runningLength < this.allocatedSize) {
            MemoryBlock allocate = UnsafeMemoryManager.allocateMemoryWithRetry(MemoryType.ONHEAP, this.taskId, this.runningLength);
            CarbonUnsafe.getUnsafe().copyMemory(this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset(), allocate.getBaseObject(), allocate.getBaseOffset(), this.runningLength);
            UnsafeMemoryManager.INSTANCE.freeMemory(this.taskId, this.memoryBlock);
            this.memoryBlock = allocate;
        }
        if (this.rowCount < this.pointers.length) {
            int[] newPointer = new int[this.rowCount];
            System.arraycopy(this.pointers, 0, newPointer, 0, this.rowCount);
            this.pointers = newPointer;
        }
    }

    @Override
    public void freeMemory() {
        if (!this.isMemoryFreed) {
            UnsafeMemoryManager.INSTANCE.freeMemory(this.taskId, this.memoryBlock);
            this.isMemoryFreed = true;
        }
    }

    @Override
    public int getMemoryUsed() {
        return this.runningLength;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void serializeMemoryBlock() {
        this.data = new byte[this.runningLength];
        CarbonUnsafe.getUnsafe().copyMemory(this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset(), this.data, CarbonUnsafe.BYTE_ARRAY_OFFSET, this.data.length);
        this.freeMemory();
        this.isSerialized = true;
    }

    @Override
    public void copyToMemoryBlock() {
        this.memoryBlock = UnsafeMemoryManager.allocateMemoryWithRetry(MemoryType.ONHEAP, this.taskId, this.data.length);
        this.isMemoryFreed = false;
        CarbonUnsafe.getUnsafe().copyMemory(this.data, CarbonUnsafe.BYTE_ARRAY_OFFSET, this.memoryBlock.getBaseObject(), this.memoryBlock.getBaseOffset(), this.data.length);
        this.isSerialized = false;
        this.data = null;
    }
}

