/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore.blockletindex;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.block.SegmentPropertiesAndSchemaHolder;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.dev.IndexModel;
import org.apache.carbondata.core.index.dev.cgindex.CoarseGrainIndex;
import org.apache.carbondata.core.indexstore.AbstractMemoryDMStore;
import org.apache.carbondata.core.indexstore.BlockMetaInfo;
import org.apache.carbondata.core.indexstore.Blocklet;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.indexstore.SafeMemoryDMStore;
import org.apache.carbondata.core.indexstore.UnsafeMemoryDMStore;
import org.apache.carbondata.core.indexstore.blockletindex.BlockletIndexModel;
import org.apache.carbondata.core.indexstore.blockletindex.BlockletIndexRowIndexes;
import org.apache.carbondata.core.indexstore.row.IndexRow;
import org.apache.carbondata.core.indexstore.row.IndexRowImpl;
import org.apache.carbondata.core.indexstore.schema.CarbonRowSchema;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.metadata.blocklet.index.BlockletMinMaxIndex;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.profiler.ExplainCollector;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.filter.FilterExpressionProcessor;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.executer.ImplicitColumnFilterExecutor;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.util.BlockletIndexUtil;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataFileFooterConverter;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class BlockIndex
extends CoarseGrainIndex
implements BlockletIndexRowIndexes,
Serializable {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)BlockIndex.class.getName());
    protected static final long serialVersionUID = -2170289352240810993L;
    private static final short BLOCK_DEFAULT_BLOCKLET_ID = -1;
    protected AbstractMemoryDMStore memoryDMStore;
    protected AbstractMemoryDMStore taskSummaryDMStore;
    protected transient SegmentPropertiesAndSchemaHolder.SegmentPropertiesWrapper segmentPropertiesWrapper;
    protected boolean isFilePathStored;
    protected boolean isPartitionTable;

    @Override
    public void init(IndexModel indexModel) throws IOException {
        byte[] filePath;
        long startTime = System.currentTimeMillis();
        assert (indexModel instanceof BlockletIndexModel);
        BlockletIndexModel blockletIndexModel = (BlockletIndexModel)indexModel;
        DataFileFooterConverter fileFooterConverter = new DataFileFooterConverter(indexModel.getConfiguration());
        List<DataFileFooter> indexInfo = null;
        indexInfo = blockletIndexModel.getIndexInfos() == null || blockletIndexModel.getIndexInfos().isEmpty() ? fileFooterConverter.getIndexInfo(blockletIndexModel.getFilePath(), blockletIndexModel.getFileData(), blockletIndexModel.getCarbonTable().isTransactionalTable()) : blockletIndexModel.getIndexInfos();
        String path = blockletIndexModel.getFilePath();
        this.isPartitionTable = blockletIndexModel.getCarbonTable().isHivePartitionTable();
        if (this.isPartitionTable || !blockletIndexModel.getCarbonTable().isTransactionalTable() || blockletIndexModel.getCarbonTable().isSupportFlatFolder() || !blockletIndexModel.getFilePath().startsWith(blockletIndexModel.getCarbonTable().getTablePath())) {
            filePath = FilenameUtils.getFullPathNoEndSeparator((String)path).getBytes("UTF-8");
            this.isFilePathStored = true;
        } else {
            filePath = new byte[]{};
        }
        byte[] fileName = path.substring(path.lastIndexOf("/") + 1, path.length()).getBytes("UTF-8");
        byte[] segmentId = blockletIndexModel.getSegmentId().getBytes("UTF-8");
        if (!indexInfo.isEmpty()) {
            DataFileFooter fileFooter = indexInfo.get(0);
            SegmentProperties segmentProperties = this.initSegmentProperties(blockletIndexModel, fileFooter);
            this.createMemorySchema(blockletIndexModel);
            this.createSummaryDMStore(blockletIndexModel);
            CarbonRowSchema[] taskSummarySchema = this.getTaskSummarySchema();
            IndexRowImpl summaryRow = this.loadMetadata(taskSummarySchema, segmentProperties, blockletIndexModel, indexInfo);
            this.finishWriting(taskSummarySchema, filePath, fileName, segmentId, summaryRow);
            if (((BlockletIndexModel)indexModel).isSerializeDmStore()) {
                this.serializeDmStore();
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Time taken to load blocklet index from file : " + indexModel.getFilePath() + " is " + (System.currentTimeMillis() - startTime)));
        }
    }

    private void finishWriting(CarbonRowSchema[] taskSummarySchema, byte[] filePath, byte[] fileName, byte[] segmentId, IndexRowImpl summaryRow) {
        if (this.memoryDMStore != null) {
            this.memoryDMStore.finishWriting();
        }
        if (null != this.taskSummaryDMStore) {
            this.addTaskSummaryRowToUnsafeMemoryStore(taskSummarySchema, summaryRow, filePath, fileName, segmentId);
            this.taskSummaryDMStore.finishWriting();
        }
    }

    private void serializeDmStore() {
        if (this.memoryDMStore != null) {
            this.memoryDMStore.serializeMemoryBlock();
        }
        if (null != this.taskSummaryDMStore) {
            this.taskSummaryDMStore.serializeMemoryBlock();
        }
    }

    protected IndexRowImpl loadMetadata(CarbonRowSchema[] taskSummarySchema, SegmentProperties segmentProperties, BlockletIndexModel blockletIndexModel, List<DataFileFooter> indexInfo) {
        return this.loadBlockMetaInfo(taskSummarySchema, segmentProperties, blockletIndexModel, indexInfo);
    }

    private SegmentProperties initSegmentProperties(BlockletIndexModel blockletIndexModel, DataFileFooter fileFooter) {
        List<ColumnSchema> columnInTable = fileFooter.getColumnInTable();
        this.segmentPropertiesWrapper = SegmentPropertiesAndSchemaHolder.getInstance().addSegmentProperties(blockletIndexModel.getCarbonTable(), columnInTable, blockletIndexModel.getSegmentId());
        return this.segmentPropertiesWrapper.getSegmentProperties();
    }

    protected void setMinMaxFlagForTaskSummary(IndexRow summaryRow, CarbonRowSchema[] taskSummarySchema, SegmentProperties segmentProperties, boolean[] minMaxFlag) {
        boolean[] minMaxFlagValuesForColumnsToBeCached = BlockletIndexUtil.getMinMaxFlagValuesForColumnsToBeCached(segmentProperties, this.getMinMaxCacheColumns(), minMaxFlag);
        this.addMinMaxFlagValues(summaryRow, taskSummarySchema[5], minMaxFlagValuesForColumnsToBeCached, 5);
    }

    private IndexRowImpl loadBlockMetaInfo(CarbonRowSchema[] taskSummarySchema, SegmentProperties segmentProperties, BlockletIndexModel blockletIndexModel, List<DataFileFooter> indexInfo) {
        String tempFilePath = null;
        DataFileFooter previousDataFileFooter = null;
        int footerCounter = 0;
        byte[][] blockMinValues = null;
        byte[][] blockMaxValues = null;
        IndexRowImpl summaryRow = null;
        ArrayList<Short> blockletCountInEachBlock = new ArrayList<Short>(indexInfo.size());
        short totalBlockletsInOneBlock = 0;
        boolean isLastFileFooterEntryNeedToBeAdded = false;
        CarbonRowSchema[] schema = this.getFileFooterEntrySchema();
        boolean[] minMaxFlag = new boolean[segmentProperties.getNumberOfColumns()];
        Arrays.fill(minMaxFlag, true);
        boolean[] taskSummaryMinMaxFlag = new boolean[segmentProperties.getNumberOfColumns()];
        Arrays.fill(taskSummaryMinMaxFlag, true);
        long totalRowCount = 0L;
        for (DataFileFooter fileFooter : indexInfo) {
            TableBlockInfo blockInfo = fileFooter.getBlockInfo();
            BlockMetaInfo blockMetaInfo = blockletIndexModel.getBlockMetaInfoMap().get(blockInfo.getFilePath());
            ++footerCounter;
            if (blockMetaInfo == null) continue;
            if (null == tempFilePath) {
                tempFilePath = blockInfo.getFilePath();
                blockMinValues = fileFooter.getBlockletIndex().getMinMaxIndex().getMinValues();
                blockMaxValues = fileFooter.getBlockletIndex().getMinMaxIndex().getMaxValues();
                this.updateMinMaxFlag(fileFooter, minMaxFlag);
                this.updateMinMaxFlag(fileFooter, taskSummaryMinMaxFlag);
                previousDataFileFooter = fileFooter;
                totalBlockletsInOneBlock = (short)(totalBlockletsInOneBlock + 1);
            } else if (blockInfo.getFilePath().equals(tempFilePath)) {
                BlockletMinMaxIndex currentFooterMinMaxIndex = fileFooter.getBlockletIndex().getMinMaxIndex();
                blockMinValues = this.compareAndUpdateMinMax(currentFooterMinMaxIndex.getMinValues(), blockMinValues, true);
                blockMaxValues = this.compareAndUpdateMinMax(currentFooterMinMaxIndex.getMaxValues(), blockMaxValues, false);
                this.updateMinMaxFlag(fileFooter, minMaxFlag);
                this.updateMinMaxFlag(fileFooter, taskSummaryMinMaxFlag);
                totalBlockletsInOneBlock = (short)(totalBlockletsInOneBlock + 1);
            }
            if (blockInfo.getFilePath().equals(tempFilePath) && footerCounter != indexInfo.size()) continue;
            TableBlockInfo previousBlockInfo = previousDataFileFooter.getBlockInfo();
            summaryRow = this.loadToUnsafeBlock(schema, taskSummarySchema, previousDataFileFooter, segmentProperties, this.getMinMaxCacheColumns(), previousBlockInfo.getFilePath(), summaryRow, blockletIndexModel.getBlockMetaInfoMap().get(previousBlockInfo.getFilePath()), blockMinValues, blockMaxValues, minMaxFlag);
            totalRowCount += previousDataFileFooter.getNumberOfRows();
            minMaxFlag = new boolean[segmentProperties.getNumberOfColumns()];
            Arrays.fill(minMaxFlag, true);
            isLastFileFooterEntryNeedToBeAdded = footerCounter == indexInfo.size() && !blockInfo.getFilePath().equals(tempFilePath);
            tempFilePath = blockInfo.getFilePath();
            blockMinValues = fileFooter.getBlockletIndex().getMinMaxIndex().getMinValues();
            blockMaxValues = fileFooter.getBlockletIndex().getMinMaxIndex().getMaxValues();
            this.updateMinMaxFlag(fileFooter, minMaxFlag);
            this.updateMinMaxFlag(fileFooter, taskSummaryMinMaxFlag);
            previousDataFileFooter = fileFooter;
            blockletCountInEachBlock.add(totalBlockletsInOneBlock);
            totalBlockletsInOneBlock = 1;
        }
        if (isLastFileFooterEntryNeedToBeAdded) {
            summaryRow = this.loadToUnsafeBlock(schema, taskSummarySchema, previousDataFileFooter, segmentProperties, this.getMinMaxCacheColumns(), previousDataFileFooter.getBlockInfo().getFilePath(), summaryRow, blockletIndexModel.getBlockMetaInfoMap().get(previousDataFileFooter.getBlockInfo().getFilePath()), blockMinValues, blockMaxValues, minMaxFlag);
            totalRowCount += previousDataFileFooter.getNumberOfRows();
            blockletCountInEachBlock.add(totalBlockletsInOneBlock);
        }
        byte[] blockletCount = this.convertRowCountFromShortToByteArray(blockletCountInEachBlock);
        summaryRow.setLong(totalRowCount, 0);
        summaryRow.setByteArray(blockletCount, taskSummarySchema.length - 1);
        this.setMinMaxFlagForTaskSummary(summaryRow, taskSummarySchema, segmentProperties, taskSummaryMinMaxFlag);
        return summaryRow;
    }

    protected void updateMinMaxFlag(DataFileFooter fileFooter, boolean[] minMaxFlag) {
        BlockletIndexUtil.updateMinMaxFlag(fileFooter.getBlockletIndex().getMinMaxIndex(), minMaxFlag);
    }

    private byte[] convertRowCountFromShortToByteArray(List<Short> blockletCountInEachBlock) {
        int bufferSize = blockletCountInEachBlock.size() * 2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize);
        for (Short blockletCount : blockletCountInEachBlock) {
            byteBuffer.putShort(blockletCount);
        }
        byteBuffer.rewind();
        return byteBuffer.array();
    }

    protected void setLocations(String[] locations, IndexRow row, int ordinal) throws UnsupportedEncodingException {
        String locationStr = StringUtils.join((Object[])locations, (char)',');
        row.setByteArray(locationStr.getBytes("UTF-8"), ordinal);
    }

    protected IndexRowImpl loadToUnsafeBlock(CarbonRowSchema[] schema, CarbonRowSchema[] taskSummarySchema, DataFileFooter fileFooter, SegmentProperties segmentProperties, List<CarbonColumn> minMaxCacheColumns, String filePath, IndexRowImpl summaryRow, BlockMetaInfo blockMetaInfo, byte[][] minValues, byte[][] maxValues, boolean[] minMaxFlag) {
        if (summaryRow == null) {
            summaryRow = new IndexRowImpl(taskSummarySchema);
        }
        IndexRowImpl row = new IndexRowImpl(schema);
        int ordinal = 0;
        int taskMinMaxOrdinal = 1;
        byte[][] minValuesForColumnsToBeCached = BlockletIndexUtil.getMinMaxForColumnsToBeCached(segmentProperties, minMaxCacheColumns, minValues);
        byte[][] maxValuesForColumnsToBeCached = BlockletIndexUtil.getMinMaxForColumnsToBeCached(segmentProperties, minMaxCacheColumns, maxValues);
        boolean[] minMaxFlagValuesForColumnsToBeCached = BlockletIndexUtil.getMinMaxFlagValuesForColumnsToBeCached(segmentProperties, minMaxCacheColumns, minMaxFlag);
        IndexRow indexRow = this.addMinMax(schema[ordinal], minValuesForColumnsToBeCached);
        ((IndexRow)row).setRow(indexRow, ordinal);
        this.addTaskMinMaxValues(summaryRow, taskSummarySchema, taskMinMaxOrdinal, minValuesForColumnsToBeCached, 1, true);
        ((IndexRow)row).setRow(this.addMinMax(schema[++ordinal], maxValuesForColumnsToBeCached), ordinal);
        this.addTaskMinMaxValues(summaryRow, taskSummarySchema, ++taskMinMaxOrdinal, maxValuesForColumnsToBeCached, 2, false);
        int n = ++ordinal;
        ((IndexRow)row).setInt((int)fileFooter.getNumberOfRows(), n);
        byte[] filePathBytes = CarbonTablePath.getCarbonDataFileName(filePath).getBytes(CarbonCommonConstants.DEFAULT_CHARSET_CLASS);
        int n2 = ++ordinal;
        ((IndexRow)row).setByteArray(filePathBytes, n2);
        int n3 = ++ordinal;
        ((IndexRow)row).setShort(fileFooter.getVersionId().number(), n3);
        int n4 = ++ordinal;
        ((IndexRow)row).setLong(fileFooter.getSchemaUpdatedTimeStamp(), n4);
        int n5 = ++ordinal;
        ++ordinal;
        ((IndexRow)row).setLong(fileFooter.getBlockInfo().getBlockOffset(), n5);
        try {
            this.setLocations(blockMetaInfo.getLocationInfo(), row, ordinal++);
            ((IndexRow)row).setLong(blockMetaInfo.getSize(), ordinal++);
            this.addMinMaxFlagValues(row, schema[ordinal], minMaxFlagValuesForColumnsToBeCached, ordinal);
            this.memoryDMStore.addIndexRow(schema, row);
        }
        catch (Exception e) {
            String message = "Load to unsafe failed for block: " + filePath;
            LOGGER.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        return summaryRow;
    }

    protected void addMinMaxFlagValues(IndexRow row, CarbonRowSchema carbonRowSchema, boolean[] minMaxFlag, int ordinal) {
        CarbonRowSchema[] minMaxFlagSchema = ((CarbonRowSchema.StructCarbonRowSchema)carbonRowSchema).getChildSchemas();
        IndexRowImpl minMaxFlagRow = new IndexRowImpl(minMaxFlagSchema);
        int flagOrdinal = 0;
        for (int i = 0; i < minMaxFlag.length; ++i) {
            ((IndexRow)minMaxFlagRow).setBoolean(minMaxFlag[i], flagOrdinal++);
        }
        row.setRow(minMaxFlagRow, ordinal);
    }

    protected String getFilePath() {
        if (this.isFilePathStored) {
            return this.getTableTaskInfo(6);
        }
        String tablePath = this.segmentPropertiesWrapper.getTableIdentifier().getTablePath();
        String segmentId = this.getTableTaskInfo(4);
        return CarbonTablePath.getSegmentPath(tablePath, segmentId);
    }

    protected String getFileNameWithFilePath(IndexRow indexRow, String filePath) {
        String fileName = filePath + "/" + new String(indexRow.getByteArray(3), CarbonCommonConstants.DEFAULT_CHARSET_CLASS) + CarbonTablePath.getCarbonDataExtension();
        return FileFactory.getUpdatedFilePath(fileName);
    }

    private void addTaskSummaryRowToUnsafeMemoryStore(CarbonRowSchema[] taskSummarySchema, IndexRow summaryRow, byte[] filePath, byte[] fileName, byte[] segmentId) {
        if (null != summaryRow) {
            summaryRow.setByteArray(fileName, 3);
            summaryRow.setByteArray(segmentId, 4);
            if (filePath.length > 0) {
                summaryRow.setByteArray(filePath, 6);
            }
            try {
                this.taskSummaryDMStore.addIndexRow(taskSummarySchema, summaryRow);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected IndexRow addMinMax(CarbonRowSchema carbonRowSchema, byte[][] minValues) {
        CarbonRowSchema[] minSchemas = ((CarbonRowSchema.StructCarbonRowSchema)carbonRowSchema).getChildSchemas();
        IndexRowImpl minRow = new IndexRowImpl(minSchemas);
        int minOrdinal = 0;
        for (int i = 0; i < minValues.length; ++i) {
            ((IndexRow)minRow).setByteArray(minValues[i], minOrdinal++);
        }
        return minRow;
    }

    protected void addTaskMinMaxValues(IndexRow taskMinMaxRow, CarbonRowSchema[] carbonRowSchema, int taskMinMaxOrdinal, byte[][] minMaxValue, int ordinal, boolean isMinValueComparison) {
        IndexRow row = taskMinMaxRow.getRow(ordinal);
        byte[][] updatedMinMaxValues = null;
        if (null == row) {
            CarbonRowSchema[] minSchemas = ((CarbonRowSchema.StructCarbonRowSchema)carbonRowSchema[taskMinMaxOrdinal]).getChildSchemas();
            row = new IndexRowImpl(minSchemas);
            updatedMinMaxValues = minMaxValue;
        } else {
            byte[][] existingMinMaxValues = this.getMinMaxValue(taskMinMaxRow, ordinal);
            updatedMinMaxValues = this.compareAndUpdateMinMax(minMaxValue, existingMinMaxValues, isMinValueComparison);
        }
        int minMaxOrdinal = 0;
        for (int i = 0; i < updatedMinMaxValues.length; ++i) {
            row.setByteArray(updatedMinMaxValues[i], minMaxOrdinal++);
        }
        taskMinMaxRow.setRow(row, ordinal);
    }

    private byte[][] compareAndUpdateMinMax(byte[][] minMaxValueCompare1, byte[][] minMaxValueCompare2, boolean isMinValueComparison) {
        byte[][] updatedMinMaxValues = new byte[minMaxValueCompare1.length][];
        System.arraycopy(minMaxValueCompare1, 0, updatedMinMaxValues, 0, minMaxValueCompare1.length);
        for (int i = 0; i < minMaxValueCompare1.length; ++i) {
            int compare = ByteUtil.UnsafeComparer.INSTANCE.compareTo(minMaxValueCompare2[i], minMaxValueCompare1[i]);
            if (isMinValueComparison) {
                if (compare >= 0) continue;
                updatedMinMaxValues[i] = minMaxValueCompare2[i];
                continue;
            }
            if (compare <= 0) continue;
            updatedMinMaxValues[i] = minMaxValueCompare2[i];
        }
        return updatedMinMaxValues;
    }

    protected void createMemorySchema(BlockletIndexModel blockletIndexModel) {
        this.memoryDMStore = this.getMemoryDMStore(blockletIndexModel.isAddToUnsafe());
    }

    protected void createSummaryDMStore(BlockletIndexModel blockletIndexModel) {
        this.taskSummaryDMStore = this.getMemoryDMStore(blockletIndexModel.isAddToUnsafe());
    }

    @Override
    public boolean isScanRequired(FilterResolverIntf filterExp) {
        IndexRow unsafeRow;
        FilterExecuter filterExecuter = FilterUtil.getFilterExecuterTree(filterExp, this.getSegmentProperties(), null, this.getMinMaxCacheColumns(), false);
        boolean isScanRequired = FilterExpressionProcessor.isScanRequired(filterExecuter, this.getMinMaxValue(unsafeRow = this.taskSummaryDMStore.getIndexRow(this.getTaskSummarySchema(), this.taskSummaryDMStore.getRowCount() - 1), 2), this.getMinMaxValue(unsafeRow, 1), this.getMinMaxFlag(unsafeRow, 5));
        return isScanRequired;
    }

    protected List<CarbonColumn> getMinMaxCacheColumns() {
        return this.segmentPropertiesWrapper.getMinMaxCacheColumns();
    }

    protected short getBlockletNumOfEntry(int index) {
        byte[] bytes = this.getBlockletRowCountForEachBlock();
        if (bytes.length == 0) {
            return 0;
        }
        return ByteBuffer.wrap(bytes).getShort(index * 2);
    }

    public int getTotalBlocks() {
        return this.memoryDMStore.getRowCount();
    }

    protected int getTotalBlocklets() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.getBlockletRowCountForEachBlock());
        int sum = 0;
        while (byteBuffer.hasRemaining()) {
            sum += byteBuffer.getShort();
        }
        return sum;
    }

    @Override
    public long getRowCount(Segment segment, List<PartitionSpec> partitions) {
        long totalRowCount = this.taskSummaryDMStore.getIndexRow(this.getTaskSummarySchema(), 0).getLong(0);
        if (totalRowCount == 0L) {
            HashMap<String, Long> blockletToRowCountMap = new HashMap<String, Long>();
            if (partitions != null && this.validatePartitionInfo(partitions)) {
                return totalRowCount;
            }
            this.getRowCountForEachBlock(segment, partitions, blockletToRowCountMap);
            Iterator iterator = blockletToRowCountMap.values().iterator();
            while (iterator.hasNext()) {
                long blockletRowCount = (Long)iterator.next();
                totalRowCount += blockletRowCount;
            }
        } else if (this.taskSummaryDMStore.getRowCount() == 0) {
            return 0L;
        }
        return totalRowCount;
    }

    @Override
    public Map<String, Long> getRowCountForEachBlock(Segment segment, List<PartitionSpec> partitions, Map<String, Long> blockletToRowCountMap) {
        if (this.memoryDMStore.getRowCount() == 0) {
            return new HashMap<String, Long>();
        }
        CarbonRowSchema[] schema = this.getFileFooterEntrySchema();
        int numEntries = this.memoryDMStore.getRowCount();
        for (int i = 0; i < numEntries; ++i) {
            IndexRow indexRow = this.memoryDMStore.getIndexRow(schema, i);
            String fileName = new String(indexRow.getByteArray(3), CarbonCommonConstants.DEFAULT_CHARSET_CLASS) + CarbonTablePath.getCarbonDataExtension();
            int rowCount = indexRow.getInt(2);
            String blockletMapKey = segment.getSegmentNo() + "," + fileName;
            Long existingCount = blockletToRowCountMap.get(blockletMapKey);
            if (null != existingCount) {
                blockletToRowCountMap.put(blockletMapKey, (long)rowCount + existingCount);
                continue;
            }
            blockletToRowCountMap.put(blockletMapKey, Long.valueOf(rowCount));
        }
        return blockletToRowCountMap;
    }

    private List<Blocklet> prune(FilterResolverIntf filterExp, FilterExecuter filterExecuter, SegmentProperties segmentProperties) {
        if (this.memoryDMStore.getRowCount() == 0) {
            return new ArrayList<Blocklet>();
        }
        ArrayList<Blocklet> blocklets = new ArrayList<Blocklet>();
        CarbonRowSchema[] schema = this.getFileFooterEntrySchema();
        String filePath = this.getFilePath();
        int numEntries = this.memoryDMStore.getRowCount();
        int totalBlocklets = 0;
        if (ExplainCollector.enabled()) {
            totalBlocklets = this.getTotalBlocklets();
        }
        int hitBlocklets = 0;
        if (filterExp == null) {
            for (int i = 0; i < numEntries; ++i) {
                IndexRow indexRow = this.memoryDMStore.getIndexRow(schema, i);
                blocklets.add(this.createBlocklet(indexRow, this.getFileNameWithFilePath(indexRow, filePath), this.getBlockletId(indexRow), false));
            }
            hitBlocklets = totalBlocklets;
        } else {
            int entryIndex = 0;
            boolean useMinMaxForPruning = this.useMinMaxForExecutorPruning(filterExp);
            if (!this.validateSegmentProperties(segmentProperties)) {
                filterExecuter = FilterUtil.getFilterExecuterTree(filterExp, this.getSegmentProperties(), null, this.getMinMaxCacheColumns(), false);
            }
            while (entryIndex < numEntries) {
                IndexRow row = this.memoryDMStore.getIndexRow(schema, entryIndex);
                boolean[] minMaxFlag = this.getMinMaxFlag(row, 9);
                String fileName = this.getFileNameWithFilePath(row, filePath);
                short blockletId = this.getBlockletId(row);
                boolean isValid = this.addBlockBasedOnMinMaxValue(filterExecuter, this.getMinMaxValue(row, 1), this.getMinMaxValue(row, 0), minMaxFlag, fileName, blockletId);
                if (isValid) {
                    blocklets.add(this.createBlocklet(row, fileName, blockletId, useMinMaxForPruning));
                    if (ExplainCollector.enabled()) {
                        hitBlocklets += this.getBlockletNumOfEntry(entryIndex);
                    }
                }
                ++entryIndex;
            }
        }
        if (ExplainCollector.enabled()) {
            ExplainCollector.setShowPruningInfo(true);
            ExplainCollector.addTotalBlocklets(totalBlocklets);
            ExplainCollector.addTotalBlocks(this.getTotalBlocks());
            ExplainCollector.addDefaultIndexPruningHit(hitBlocklets);
        }
        return blocklets;
    }

    protected boolean useMinMaxForExecutorPruning(FilterResolverIntf filterResolverIntf) {
        return false;
    }

    @Override
    public List<Blocklet> prune(Expression expression, SegmentProperties properties, CarbonTable carbonTable, FilterExecuter filterExecuter) {
        return this.prune(new IndexFilter(properties, carbonTable, expression).getResolver(), properties, filterExecuter, carbonTable);
    }

    @Override
    public List<Blocklet> prune(FilterResolverIntf filterExp, SegmentProperties segmentProperties, FilterExecuter filterExecuter, CarbonTable table) {
        if (this.memoryDMStore.getRowCount() == 0) {
            return new ArrayList<Blocklet>();
        }
        return this.prune(filterExp, filterExecuter, segmentProperties);
    }

    @Override
    public boolean validatePartitionInfo(List<PartitionSpec> partitions) {
        if (this.memoryDMStore.getRowCount() == 0) {
            return true;
        }
        String[] fileDetails = this.getFileDetails();
        boolean found = false;
        Path folderPath = new Path(fileDetails[0]);
        for (PartitionSpec spec : partitions) {
            if (!folderPath.equals((Object)spec.getLocation()) || !this.isCorrectUUID(fileDetails, spec)) continue;
            found = true;
            break;
        }
        return !found;
    }

    @Override
    public void finish() {
    }

    private boolean isCorrectUUID(String[] fileDetails, PartitionSpec spec) {
        boolean needToScan = false;
        if (spec.getUuid() != null) {
            String[] split = spec.getUuid().split("_");
            if (split[0].equals(fileDetails[2]) && CarbonTablePath.DataFileUtil.getTimeStampFromFileName(fileDetails[1]).equals(split[1])) {
                needToScan = true;
            }
        } else {
            needToScan = true;
        }
        return needToScan;
    }

    private boolean addBlockBasedOnMinMaxValue(FilterExecuter filterExecuter, byte[][] maxValue, byte[][] minValue, boolean[] minMaxFlag, String filePath, int blockletId) {
        BitSet bitSet = null;
        if (filterExecuter instanceof ImplicitColumnFilterExecutor) {
            CarbonTable carbonTable = this.segmentPropertiesWrapper.getCarbonTable();
            String uniqueBlockPath = carbonTable.isHivePartitionTable() ? CarbonUtil.getBlockId(carbonTable.getAbsoluteTableIdentifier(), filePath, "", true, false, true) : filePath.substring(filePath.lastIndexOf("/Part") + 1);
            if (blockletId != -1) {
                uniqueBlockPath = uniqueBlockPath + "/" + blockletId;
            }
            bitSet = ((ImplicitColumnFilterExecutor)((Object)filterExecuter)).isFilterValuesPresentInBlockOrBlocklet(maxValue, minValue, uniqueBlockPath, minMaxFlag);
        } else {
            bitSet = filterExecuter.isScanRequired(maxValue, minValue, minMaxFlag);
        }
        return !bitSet.isEmpty();
    }

    public ExtendedBlocklet getDetailedBlocklet(String blockletId) {
        int absoluteBlockletId = Integer.parseInt(blockletId);
        return this.createBlockletFromRelativeBlockletId(absoluteBlockletId);
    }

    private ExtendedBlocklet createBlockletFromRelativeBlockletId(int absoluteBlockletId) {
        short relativeBlockletId = -1;
        int rowIndex = 0;
        if (absoluteBlockletId == 0) {
            relativeBlockletId = (short)absoluteBlockletId;
        } else {
            int diff = absoluteBlockletId;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.getBlockletRowCountForEachBlock());
            while (byteBuffer.hasRemaining()) {
                short blockletCount = byteBuffer.getShort();
                if ((diff -= blockletCount) < 0) {
                    relativeBlockletId = (short)(diff + blockletCount);
                    break;
                }
                if (diff == 0) {
                    relativeBlockletId = (short)(relativeBlockletId + 1);
                    break;
                }
                ++rowIndex;
            }
        }
        IndexRow row = this.memoryDMStore.getIndexRow(this.getFileFooterEntrySchema(), rowIndex);
        String filePath = this.getFilePath();
        return this.createBlocklet(row, this.getFileNameWithFilePath(row, filePath), relativeBlockletId, false);
    }

    private byte[] getBlockletRowCountForEachBlock() {
        CarbonRowSchema[] taskSummarySchema = this.getTaskSummarySchema();
        return this.taskSummaryDMStore.getIndexRow(taskSummarySchema, this.taskSummaryDMStore.getRowCount() - 1).getByteArray(taskSummarySchema.length - 1);
    }

    public String getTableTaskInfo(int index) {
        IndexRow unsafeRow = this.taskSummaryDMStore.getIndexRow(this.getTaskSummarySchema(), 0);
        try {
            return new String(unsafeRow.getByteArray(index), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 encoding is not supported", e);
        }
    }

    private byte[][] getMinMaxValue(IndexRow row, int index) {
        IndexRow minMaxRow = row.getRow(index);
        byte[][] minMax = new byte[minMaxRow.getColumnCount()][];
        for (int i = 0; i < minMax.length; ++i) {
            minMax[i] = minMaxRow.getByteArray(i);
        }
        return minMax;
    }

    private boolean[] getMinMaxFlag(IndexRow row, int index) {
        IndexRow minMaxFlagRow = row.getRow(index);
        boolean[] minMaxFlag = new boolean[minMaxFlagRow.getColumnCount()];
        for (int i = 0; i < minMaxFlag.length; ++i) {
            minMaxFlag[i] = minMaxFlagRow.getBoolean(i);
        }
        return minMaxFlag;
    }

    protected short getBlockletId(IndexRow indexRow) {
        return -1;
    }

    protected ExtendedBlocklet createBlocklet(IndexRow row, String fileName, short blockletId, boolean useMinMaxForPruning) {
        short versionNumber = row.getShort(4);
        ExtendedBlocklet blocklet = new ExtendedBlocklet(fileName, blockletId + "", false, ColumnarFormatVersion.valueOf(versionNumber));
        blocklet.setIndexRow(row);
        blocklet.setUseMinMaxForPruning(useMinMaxForPruning);
        return blocklet;
    }

    private String[] getFileDetails() {
        try {
            String[] fileDetails = new String[3];
            IndexRow unsafeRow = this.taskSummaryDMStore.getIndexRow(this.getTaskSummarySchema(), 0);
            fileDetails[0] = new String(unsafeRow.getByteArray(6), "UTF-8");
            fileDetails[1] = new String(unsafeRow.getByteArray(3), "UTF-8");
            fileDetails[2] = new String(unsafeRow.getByteArray(4), "UTF-8");
            return fileDetails;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        if (this.memoryDMStore != null) {
            this.memoryDMStore.freeMemory();
        }
        if (null != this.taskSummaryDMStore) {
            this.taskSummaryDMStore.freeMemory();
        }
    }

    public long getMemorySize() {
        long memoryUsed = 0L;
        if (this.memoryDMStore != null) {
            memoryUsed += (long)this.memoryDMStore.getMemoryUsed();
        }
        if (null != this.taskSummaryDMStore) {
            memoryUsed += (long)this.taskSummaryDMStore.getMemoryUsed();
        }
        return memoryUsed;
    }

    protected boolean validateSegmentProperties(SegmentProperties tableSegmentProperties) {
        return tableSegmentProperties.equals(this.getSegmentProperties());
    }

    protected SegmentProperties getSegmentProperties() {
        return this.segmentPropertiesWrapper.getSegmentProperties();
    }

    public List<ColumnSchema> getColumnSchema() {
        return this.segmentPropertiesWrapper.getColumnsInTable();
    }

    protected AbstractMemoryDMStore getMemoryDMStore(boolean addToUnsafe) {
        AbstractMemoryDMStore memoryDMStore = addToUnsafe ? new UnsafeMemoryDMStore() : new SafeMemoryDMStore();
        return memoryDMStore;
    }

    protected CarbonRowSchema[] getFileFooterEntrySchema() {
        return this.segmentPropertiesWrapper.getBlockFileFooterEntrySchema();
    }

    protected CarbonRowSchema[] getTaskSummarySchema() {
        return this.segmentPropertiesWrapper.getTaskSummarySchemaForBlock(true, this.isFilePathStored);
    }

    public void convertToUnsafeDMStore() {
        if (this.memoryDMStore instanceof SafeMemoryDMStore) {
            UnsafeMemoryDMStore unsafeMemoryDMStore = this.memoryDMStore.convertToUnsafeDMStore(this.getFileFooterEntrySchema());
            this.memoryDMStore.freeMemory();
            this.memoryDMStore = unsafeMemoryDMStore;
        }
        if (this.taskSummaryDMStore instanceof SafeMemoryDMStore) {
            UnsafeMemoryDMStore unsafeSummaryMemoryDMStore = this.taskSummaryDMStore.convertToUnsafeDMStore(this.getTaskSummarySchema());
            this.taskSummaryDMStore.freeMemory();
            this.taskSummaryDMStore = unsafeSummaryMemoryDMStore;
        }
        if (this.memoryDMStore instanceof UnsafeMemoryDMStore && this.memoryDMStore.isSerialized()) {
            this.memoryDMStore.copyToMemoryBlock();
        }
        if (this.taskSummaryDMStore instanceof UnsafeMemoryDMStore && this.taskSummaryDMStore.isSerialized()) {
            this.taskSummaryDMStore.copyToMemoryBlock();
        }
    }

    public void setSegmentPropertiesWrapper(SegmentPropertiesAndSchemaHolder.SegmentPropertiesWrapper segmentPropertiesWrapper) {
        this.segmentPropertiesWrapper = segmentPropertiesWrapper;
    }

    public SegmentPropertiesAndSchemaHolder.SegmentPropertiesWrapper getSegmentPropertiesWrapper() {
        return this.segmentPropertiesWrapper;
    }

    @Override
    public int getNumberOfEntries() {
        if (this.memoryDMStore != null) {
            if (this.memoryDMStore.getRowCount() == 0) {
                return 1;
            }
            return this.memoryDMStore.getRowCount();
        }
        return 1;
    }
}

