/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore.blockletindex;

import java.io.IOException;
import java.util.List;
import org.apache.carbondata.core.datastore.DataRefNode;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.impl.MeasureRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.reader.CarbonDataReaderFactory;
import org.apache.carbondata.core.datastore.chunk.reader.DimensionColumnChunkReader;
import org.apache.carbondata.core.datastore.chunk.reader.MeasureColumnChunkReader;
import org.apache.carbondata.core.index.dev.BlockletSerializer;
import org.apache.carbondata.core.index.dev.fgindex.FineGrainBlocklet;
import org.apache.carbondata.core.indexstore.BlockletDetailInfo;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex;
import org.apache.carbondata.core.util.BitSetGroup;

public class BlockletDataRefNode
implements DataRefNode {
    private List<TableBlockInfo> blockInfos;
    private int index;
    private BlockletSerializer blockletSerializer;

    BlockletDataRefNode(List<TableBlockInfo> blockInfos, int index) {
        this.blockInfos = blockInfos;
        for (TableBlockInfo blockInfo : blockInfos) {
            BlockletDetailInfo detailInfo = blockInfo.getDetailInfo();
            detailInfo.getBlockletInfo().setNumberOfRows(detailInfo.getRowCount());
            detailInfo.getBlockletInfo().setNumberOfPages(detailInfo.getPagesCount());
            detailInfo.setBlockletId(blockInfo.getDetailInfo().getBlockletId());
            int[] pageRowCount = new int[detailInfo.getPagesCount()];
            int numberOfPagesCompletelyFilled = detailInfo.getRowCount() / 32000;
            int lastPageRowCount = detailInfo.getRowCount() % 32000;
            int fullyFilledRowsCount = 32000;
            for (int i = 0; i < numberOfPagesCompletelyFilled; ++i) {
                pageRowCount[i] = fullyFilledRowsCount;
            }
            if (lastPageRowCount > 0) {
                pageRowCount[pageRowCount.length - 1] = lastPageRowCount;
            }
            if (detailInfo.getBlockletInfo().getNumberOfRowsPerPage() != null) continue;
            detailInfo.getBlockletInfo().setNumberOfRowsPerPage(pageRowCount);
        }
        this.index = index;
        this.blockletSerializer = new BlockletSerializer();
    }

    @Override
    public DataRefNode getNextDataRefNode() {
        if (this.index + 1 < this.blockInfos.size()) {
            return new BlockletDataRefNode(this.blockInfos, this.index + 1);
        }
        return null;
    }

    @Override
    public int numRows() {
        return this.blockInfos.get(this.index).getDetailInfo().getRowCount();
    }

    @Override
    public short blockletIndex() {
        return this.blockInfos.get(this.index).getDetailInfo().getBlockletId();
    }

    @Override
    public byte[][] getColumnsMaxValue() {
        BlockletIndex blockletIndex = this.blockInfos.get(this.index).getDetailInfo().getBlockletInfo().getBlockletIndex();
        if (null != blockletIndex) {
            return blockletIndex.getMinMaxIndex().getMaxValues();
        }
        return null;
    }

    @Override
    public byte[][] getColumnsMinValue() {
        BlockletIndex blockletIndex = this.blockInfos.get(this.index).getDetailInfo().getBlockletInfo().getBlockletIndex();
        if (null != blockletIndex) {
            return blockletIndex.getMinMaxIndex().getMinValues();
        }
        return null;
    }

    @Override
    public boolean[] minMaxFlagArray() {
        BlockletIndex blockletIndex = this.blockInfos.get(this.index).getDetailInfo().getBlockletInfo().getBlockletIndex();
        boolean[] isMinMaxSet = null;
        if (null != blockletIndex) {
            isMinMaxSet = blockletIndex.getMinMaxIndex().getIsMinMaxSet();
        }
        return isMinMaxSet;
    }

    @Override
    public DimensionRawColumnChunk[] readDimensionChunks(FileReader fileReader, int[][] blockIndexes) throws IOException {
        DimensionColumnChunkReader dimensionChunksReader = this.getDimensionColumnChunkReader(fileReader);
        return dimensionChunksReader.readRawDimensionChunks(fileReader, blockIndexes);
    }

    @Override
    public DimensionRawColumnChunk readDimensionChunk(FileReader fileReader, int columnIndex) throws IOException {
        DimensionColumnChunkReader dimensionChunksReader = this.getDimensionColumnChunkReader(fileReader);
        return dimensionChunksReader.readRawDimensionChunk(fileReader, columnIndex);
    }

    @Override
    public MeasureRawColumnChunk[] readMeasureChunks(FileReader fileReader, int[][] columnIndexRange) throws IOException {
        MeasureColumnChunkReader measureColumnChunkReader = this.getMeasureColumnChunkReader(fileReader);
        MeasureRawColumnChunk[] measureRawColumnChunks = measureColumnChunkReader.readRawMeasureChunks(fileReader, columnIndexRange);
        return measureRawColumnChunks;
    }

    @Override
    public MeasureRawColumnChunk readMeasureChunk(FileReader fileReader, int columnIndex) throws IOException {
        MeasureColumnChunkReader measureColumnChunkReader = this.getMeasureColumnChunkReader(fileReader);
        MeasureRawColumnChunk measureRawColumnChunk = measureColumnChunkReader.readRawMeasureChunk(fileReader, columnIndex);
        return measureRawColumnChunk;
    }

    private DimensionColumnChunkReader getDimensionColumnChunkReader(FileReader fileReader) {
        ColumnarFormatVersion version = ColumnarFormatVersion.valueOf(this.blockInfos.get(this.index).getDetailInfo().getVersionNumber());
        if (fileReader.isReadPageByPage()) {
            return CarbonDataReaderFactory.getInstance().getDimensionColumnChunkReader(version, this.blockInfos.get(this.index).getDetailInfo().getBlockletInfo(), this.blockInfos.get(this.index).getFilePath(), true);
        }
        return CarbonDataReaderFactory.getInstance().getDimensionColumnChunkReader(version, this.blockInfos.get(this.index).getDetailInfo().getBlockletInfo(), this.blockInfos.get(this.index).getFilePath(), false);
    }

    private MeasureColumnChunkReader getMeasureColumnChunkReader(FileReader fileReader) {
        ColumnarFormatVersion version = ColumnarFormatVersion.valueOf(this.blockInfos.get(this.index).getDetailInfo().getVersionNumber());
        if (fileReader.isReadPageByPage()) {
            return CarbonDataReaderFactory.getInstance().getMeasureColumnChunkReader(version, this.blockInfos.get(this.index).getDetailInfo().getBlockletInfo(), this.blockInfos.get(this.index).getFilePath(), true);
        }
        return CarbonDataReaderFactory.getInstance().getMeasureColumnChunkReader(version, this.blockInfos.get(this.index).getDetailInfo().getBlockletInfo(), this.blockInfos.get(this.index).getFilePath(), false);
    }

    @Override
    public int numberOfPages() {
        return this.blockInfos.get(this.index).getDetailInfo().getPagesCount();
    }

    @Override
    public BitSetGroup getIndexedData() {
        String indexWriterPath = this.blockInfos.get(this.index).getIndexWriterPath();
        if (indexWriterPath != null) {
            try {
                FineGrainBlocklet blocklet = this.blockletSerializer.deserializeBlocklet(indexWriterPath);
                return blocklet.getBitSetGroup(this.numberOfPages());
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public int getPageRowCount(int pageNumber) {
        return this.blockInfos.get(this.index).getDetailInfo().getBlockletInfo().getNumberOfRowsPerPage()[pageNumber];
    }

    public int numberOfNodes() {
        return this.blockInfos.size();
    }

    public List<TableBlockInfo> getBlockInfos() {
        return this.blockInfos;
    }
}

