/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore.blockletindex;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.index.dev.IndexModel;
import org.apache.carbondata.core.indexstore.BlockMetaInfo;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.indexstore.blockletindex.BlockIndex;
import org.apache.carbondata.core.indexstore.blockletindex.BlockletIndexModel;
import org.apache.carbondata.core.indexstore.row.IndexRow;
import org.apache.carbondata.core.indexstore.row.IndexRowImpl;
import org.apache.carbondata.core.indexstore.schema.CarbonRowSchema;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.metadata.blocklet.index.BlockletMinMaxIndex;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.util.BlockletIndexUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;

public class BlockletIndex
extends BlockIndex
implements Serializable {
    private static final long serialVersionUID = -2170289352240810993L;
    private int blockNum = 0;

    @Override
    public void init(IndexModel indexModel) throws IOException {
        super.init(indexModel);
    }

    @Override
    protected IndexRowImpl loadMetadata(CarbonRowSchema[] taskSummarySchema, SegmentProperties segmentProperties, BlockletIndexModel blockletIndexModel, List<DataFileFooter> indexInfo) {
        return this.loadBlockletMetaInfo(taskSummarySchema, segmentProperties, blockletIndexModel, indexInfo);
    }

    @Override
    protected CarbonRowSchema[] getTaskSummarySchema() {
        return this.segmentPropertiesWrapper.getTaskSummarySchemaForBlocklet(false, this.isFilePathStored);
    }

    @Override
    protected CarbonRowSchema[] getFileFooterEntrySchema() {
        return this.segmentPropertiesWrapper.getBlockletFileFooterEntrySchema();
    }

    private IndexRowImpl loadBlockletMetaInfo(CarbonRowSchema[] taskSummarySchema, SegmentProperties segmentProperties, BlockletIndexModel blockletIndexModel, List<DataFileFooter> indexInfo) {
        String tempFilePath = null;
        IndexRowImpl summaryRow = null;
        CarbonRowSchema[] schema = this.getFileFooterEntrySchema();
        boolean[] summaryRowMinMaxFlag = new boolean[segmentProperties.getNumberOfColumns()];
        Arrays.fill(summaryRowMinMaxFlag, true);
        int relativeBlockletId = 0;
        for (DataFileFooter fileFooter : indexInfo) {
            this.updateMinMaxFlag(fileFooter, summaryRowMinMaxFlag);
            TableBlockInfo blockInfo = fileFooter.getBlockInfo();
            BlockMetaInfo blockMetaInfo = blockletIndexModel.getBlockMetaInfoMap().get(blockInfo.getFilePath());
            if (blockMetaInfo == null) continue;
            if (null == tempFilePath || !tempFilePath.equals(blockInfo.getFilePath())) {
                tempFilePath = blockInfo.getFilePath();
                relativeBlockletId = 0;
                ++this.blockNum;
            }
            summaryRow = this.loadToUnsafe(schema, taskSummarySchema, fileFooter, segmentProperties, this.getMinMaxCacheColumns(), blockInfo.getFilePath(), summaryRow, blockMetaInfo, relativeBlockletId);
            relativeBlockletId += fileFooter.getBlockletList().size();
        }
        summaryRow.setLong(0L, 0);
        this.setMinMaxFlagForTaskSummary(summaryRow, taskSummarySchema, segmentProperties, summaryRowMinMaxFlag);
        return summaryRow;
    }

    private IndexRowImpl loadToUnsafe(CarbonRowSchema[] schema, CarbonRowSchema[] taskSummarySchema, DataFileFooter fileFooter, SegmentProperties segmentProperties, List<CarbonColumn> minMaxCacheColumns, String filePath, IndexRowImpl summaryRow, BlockMetaInfo blockMetaInfo, int relativeBlockletId) {
        List<BlockletInfo> blockletList = fileFooter.getBlockletList();
        if (!blockletList.isEmpty() && summaryRow == null) {
            summaryRow = new IndexRowImpl(taskSummarySchema);
        }
        for (int index = 0; index < blockletList.size(); ++index) {
            IndexRowImpl row = new IndexRowImpl(schema);
            int ordinal = 0;
            int taskMinMaxOrdinal = 1;
            BlockletInfo blockletInfo = blockletList.get(index);
            blockletInfo.setSorted(fileFooter.isSorted());
            BlockletMinMaxIndex minMaxIndex = blockletInfo.getBlockletIndex().getMinMaxIndex();
            byte[][] minValuesForColumnsToBeCached = BlockletIndexUtil.getMinMaxForColumnsToBeCached(segmentProperties, minMaxCacheColumns, minMaxIndex.getMinValues());
            byte[][] maxValuesForColumnsToBeCached = BlockletIndexUtil.getMinMaxForColumnsToBeCached(segmentProperties, minMaxCacheColumns, minMaxIndex.getMaxValues());
            boolean[] minMaxFlagValuesForColumnsToBeCached = BlockletIndexUtil.getMinMaxFlagValuesForColumnsToBeCached(segmentProperties, minMaxCacheColumns, fileFooter.getBlockletIndex().getMinMaxIndex().getIsMinMaxSet());
            ((IndexRow)row).setRow(this.addMinMax(schema[ordinal], minValuesForColumnsToBeCached), ordinal);
            this.addTaskMinMaxValues(summaryRow, taskSummarySchema, taskMinMaxOrdinal, minValuesForColumnsToBeCached, 1, true);
            ((IndexRow)row).setRow(this.addMinMax(schema[++ordinal], maxValuesForColumnsToBeCached), ordinal);
            this.addTaskMinMaxValues(summaryRow, taskSummarySchema, ++taskMinMaxOrdinal, maxValuesForColumnsToBeCached, 2, false);
            int n = ++ordinal;
            ((IndexRow)row).setInt(blockletInfo.getNumberOfRows(), n);
            byte[] filePathBytes = CarbonTablePath.getCarbonDataFileName(filePath).getBytes(CarbonCommonConstants.DEFAULT_CHARSET_CLASS);
            int n2 = ++ordinal;
            ((IndexRow)row).setByteArray(filePathBytes, n2);
            int n3 = ++ordinal;
            ((IndexRow)row).setShort(fileFooter.getVersionId().number(), n3);
            int n4 = ++ordinal;
            ++ordinal;
            ((IndexRow)row).setLong(fileFooter.getSchemaUpdatedTimeStamp(), n4);
            try {
                ((IndexRow)row).setLong(fileFooter.getBlockInfo().getBlockOffset(), ordinal++);
                this.setLocations(blockMetaInfo.getLocationInfo(), row, ordinal++);
                ((IndexRow)row).setLong(blockMetaInfo.getSize(), ordinal++);
                this.addMinMaxFlagValues(row, schema[ordinal], minMaxFlagValuesForColumnsToBeCached, ordinal);
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                DataOutputStream dataOutput = new DataOutputStream(stream);
                blockletInfo.write(dataOutput);
                byte[] serializedData = stream.toByteArray();
                int n5 = ++ordinal;
                ((IndexRow)row).setByteArray(serializedData, n5);
                int n6 = ++ordinal;
                ((IndexRow)row).setShort((short)blockletInfo.getNumberOfPages(), n6);
                ((IndexRow)row).setShort((short)relativeBlockletId++, ++ordinal);
                this.memoryDMStore.addIndexRow(schema, row);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return summaryRow;
    }

    @Override
    public ExtendedBlocklet getDetailedBlocklet(String blockletId) {
        int absoluteBlockletId = Integer.parseInt(blockletId);
        IndexRow row = this.memoryDMStore.getIndexRow(this.getFileFooterEntrySchema(), absoluteBlockletId);
        short relativeBlockletId = row.getShort(12);
        String filePath = this.getFilePath();
        return this.createBlocklet(row, this.getFileNameWithFilePath(row, filePath), relativeBlockletId, false);
    }

    @Override
    protected short getBlockletId(IndexRow indexRow) {
        return indexRow.getShort(12);
    }

    @Override
    protected boolean useMinMaxForExecutorPruning(FilterResolverIntf filterResolverIntf) {
        return BlockletIndexUtil.useMinMaxForBlockletPruning(filterResolverIntf, this.getMinMaxCacheColumns());
    }

    @Override
    protected ExtendedBlocklet createBlocklet(IndexRow row, String fileName, short blockletId, boolean useMinMaxForPruning) {
        short versionNumber = row.getShort(4);
        ExtendedBlocklet blocklet = new ExtendedBlocklet(fileName, blockletId + "", ColumnarFormatVersion.valueOf(versionNumber));
        blocklet.setColumnSchema(this.getColumnSchema());
        blocklet.setUseMinMaxForPruning(useMinMaxForPruning);
        blocklet.setIsBlockCache(false);
        blocklet.setIndexRow(row);
        return blocklet;
    }

    @Override
    protected short getBlockletNumOfEntry(int index) {
        return 1;
    }

    @Override
    public int getTotalBlocks() {
        return this.blockNum;
    }

    @Override
    protected int getTotalBlocklets() {
        return this.memoryDMStore.getRowCount();
    }
}

