/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore.blockletindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.cache.CacheProvider;
import org.apache.carbondata.core.cache.CacheType;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.block.SegmentPropertiesAndSchemaHolder;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.features.TableOperation;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.index.IndexInputSplit;
import org.apache.carbondata.core.index.IndexMeta;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.dev.CacheableIndex;
import org.apache.carbondata.core.index.dev.Index;
import org.apache.carbondata.core.index.dev.IndexBuilder;
import org.apache.carbondata.core.index.dev.IndexWriter;
import org.apache.carbondata.core.index.dev.cgindex.CoarseGrainIndex;
import org.apache.carbondata.core.index.dev.cgindex.CoarseGrainIndexFactory;
import org.apache.carbondata.core.index.dev.expr.IndexExprWrapper;
import org.apache.carbondata.core.index.dev.expr.IndexInputSplitWrapper;
import org.apache.carbondata.core.indexstore.Blocklet;
import org.apache.carbondata.core.indexstore.BlockletDetailsFetcher;
import org.apache.carbondata.core.indexstore.BlockletIndexWrapper;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.indexstore.SegmentBlockIndexInfo;
import org.apache.carbondata.core.indexstore.SegmentPropertiesFetcher;
import org.apache.carbondata.core.indexstore.TableBlockIndexUniqueIdentifier;
import org.apache.carbondata.core.indexstore.TableBlockIndexUniqueIdentifierWrapper;
import org.apache.carbondata.core.indexstore.blockletindex.BlockIndex;
import org.apache.carbondata.core.indexstore.blockletindex.BlockletIndex;
import org.apache.carbondata.core.indexstore.blockletindex.BlockletIndexInputSplit;
import org.apache.carbondata.core.indexstore.blockletindex.SegmentIndexFileStore;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.IndexSchema;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.segmentmeta.SegmentColumnMetaDataInfo;
import org.apache.carbondata.core.segmentmeta.SegmentMetaDataInfo;
import org.apache.carbondata.core.util.BlockletIndexUtil;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.events.Event;
import org.apache.hadoop.fs.Path;

public class BlockletIndexFactory
extends CoarseGrainIndexFactory
implements BlockletDetailsFetcher,
SegmentPropertiesFetcher,
CacheableIndex {
    private static final String NAME = "clustered.btree.blocklet";
    public static final String CACHE_LEVEL_BLOCKLET = "BLOCKLET";
    public static final IndexSchema INDEX_SCHEMA = new IndexSchema("clustered.btree.blocklet", BlockletIndexFactory.class.getName());
    private AbsoluteTableIdentifier identifier;
    private Map<String, SegmentBlockIndexInfo> segmentMap = new ConcurrentHashMap<String, SegmentBlockIndexInfo>();
    private Cache<TableBlockIndexUniqueIdentifierWrapper, BlockletIndexWrapper> cache;

    public BlockletIndexFactory(CarbonTable carbonTable, IndexSchema indexSchema) {
        super(carbonTable, indexSchema);
        this.identifier = carbonTable.getAbsoluteTableIdentifier();
        this.cache = CacheProvider.getInstance().createCache(CacheType.DRIVER_BLOCKLET_INDEX);
    }

    public static Index createIndex(CarbonTable carbonTable) {
        boolean cacheLevelBlock = BlockletIndexUtil.isCacheLevelBlock(carbonTable);
        if (cacheLevelBlock) {
            return new BlockIndex();
        }
        return new BlockletIndex();
    }

    @Override
    public IndexWriter createWriter(Segment segment, String shardName, SegmentProperties segmentProperties) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public IndexBuilder createBuilder(Segment segment, String shardName, SegmentProperties segmentProperties) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public Map<Segment, List<CoarseGrainIndex>> getIndexes(List<Segment> segments, IndexFilter filter) throws IOException {
        return this.getIndexes(segments, new HashSet<Path>(), filter);
    }

    @Override
    public Map<Segment, List<CoarseGrainIndex>> getIndexes(List<Segment> segments, Set<Path> partitionLocations, IndexFilter filter) throws IOException {
        ArrayList<TableBlockIndexUniqueIdentifierWrapper> tableBlockIndexUniqueIdentifierWrappers = new ArrayList<TableBlockIndexUniqueIdentifierWrapper>();
        HashMap<Segment, List<CoarseGrainIndex>> indexMap = new HashMap<Segment, List<CoarseGrainIndex>>();
        HashMap<String, Segment> segmentMap = new HashMap<String, Segment>();
        for (Segment segment : segments) {
            segmentMap.put(segment.getSegmentNo(), segment);
            Set<TableBlockIndexUniqueIdentifier> identifiers = this.getTableBlockIndexUniqueIdentifiers(segment);
            if (!partitionLocations.isEmpty()) {
                this.getTableBlockUniqueIdentifierWrappers(partitionLocations, tableBlockIndexUniqueIdentifierWrappers, identifiers);
                continue;
            }
            SegmentMetaDataInfo segmentMetaDataInfo = segment.getSegmentMetaDataInfo();
            boolean isLoadAllIndex = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("carbon.load.all.segment.indexes.to.cache", "true"));
            if (!isLoadAllIndex && null != segmentMetaDataInfo && null != filter && !filter.isEmpty() && null != filter.getExpression() && null == FilterUtil.getImplicitFilterExpression(filter.getExpression())) {
                this.getTableBlockIndexUniqueIdentifierUsingSegmentMinMax(segment, segmentMetaDataInfo, filter, identifiers, tableBlockIndexUniqueIdentifierWrappers);
                continue;
            }
            for (TableBlockIndexUniqueIdentifier tableBlockIndexUniqueIdentifier : identifiers) {
                tableBlockIndexUniqueIdentifierWrappers.add(new TableBlockIndexUniqueIdentifierWrapper(tableBlockIndexUniqueIdentifier, this.getCarbonTable()));
            }
        }
        List<BlockletIndexWrapper> blockletIndexWrappers = this.cache.getAll(tableBlockIndexUniqueIdentifierWrappers);
        for (BlockletIndexWrapper wrapper : blockletIndexWrappers) {
            Segment segment = (Segment)segmentMap.get(wrapper.getSegmentId());
            ArrayList<BlockIndex> indexes = (ArrayList<BlockIndex>)indexMap.get(segment);
            if (null == indexes) {
                indexes = new ArrayList<BlockIndex>();
            }
            indexes.addAll(wrapper.getIndexes());
            indexMap.put(segment, indexes);
        }
        return indexMap;
    }

    private void getTableBlockUniqueIdentifierWrappers(Set<Path> partitionLocations, List<TableBlockIndexUniqueIdentifierWrapper> tableBlockIndexUniqueIdentifierWrappers, Set<TableBlockIndexUniqueIdentifier> identifiers) {
        for (TableBlockIndexUniqueIdentifier tableBlockIndexUniqueIdentifier : identifiers) {
            if (!partitionLocations.isEmpty()) {
                if (!partitionLocations.contains(new Path(tableBlockIndexUniqueIdentifier.getIndexFilePath()))) continue;
                tableBlockIndexUniqueIdentifierWrappers.add(new TableBlockIndexUniqueIdentifierWrapper(tableBlockIndexUniqueIdentifier, this.getCarbonTable()));
                continue;
            }
            tableBlockIndexUniqueIdentifierWrappers.add(new TableBlockIndexUniqueIdentifierWrapper(tableBlockIndexUniqueIdentifier, this.getCarbonTable()));
        }
    }

    private void getTableBlockIndexUniqueIdentifierUsingSegmentMinMax(Segment segment, SegmentMetaDataInfo segmentMetaDataInfo, IndexFilter filter, Set<TableBlockIndexUniqueIdentifier> identifiers, List<TableBlockIndexUniqueIdentifierWrapper> tableBlockIndexUniqueIdentifierWrappers) {
        boolean isScanRequired = false;
        Map<String, SegmentColumnMetaDataInfo> segmentColumnMetaDataInfoMap = segmentMetaDataInfo.getSegmentColumnMetaDataInfoMap();
        int length = segmentColumnMetaDataInfoMap.size();
        ArrayList<ColumnSchema> columnSchemas = new ArrayList<ColumnSchema>();
        byte[][] min = new byte[length][];
        byte[][] max = new byte[length][];
        boolean[] minMaxFlag = new boolean[length];
        int i = 0;
        Map<String, ColumnSchema> tableColumnSchemas = this.getCarbonTable().getTableInfo().getFactTable().getListOfColumns().stream().collect(Collectors.toMap(ColumnSchema::getColumnUniqueId, ColumnSchema::clone));
        for (Map.Entry<String, SegmentColumnMetaDataInfo> columnMetaData : segmentColumnMetaDataInfoMap.entrySet()) {
            ColumnSchema columnSchema = tableColumnSchemas.get(columnMetaData.getKey());
            if (null == columnSchema) continue;
            boolean isSortColumnInSegment = columnMetaData.getValue().isSortColumn();
            boolean isColumnDriftInSegment = columnMetaData.getValue().isColumnDrift();
            if (null != columnSchema.getColumnProperties()) {
                String isSortColumn = columnSchema.getColumnProperties().get("sort_columns");
                String isColumnDrift = columnSchema.getColumnProperties().get("column_drift");
                if (null != isSortColumn) {
                    if (isSortColumn.equalsIgnoreCase("true") && !isSortColumnInSegment) {
                        this.modifyColumnSchemaForSortColumn(columnSchema, isColumnDriftInSegment, isColumnDrift, false);
                    } else if (isSortColumn.equalsIgnoreCase("false") && isSortColumnInSegment) {
                        this.modifyColumnSchemaForSortColumn(columnSchema, isColumnDriftInSegment, isColumnDrift, true);
                    }
                } else {
                    this.modifyColumnSchemaForSortColumn(columnSchema, isColumnDriftInSegment, isColumnDrift, false);
                }
            }
            columnSchemas.add(columnSchema);
            min[i] = columnMetaData.getValue().getColumnMinValue();
            max[i] = columnMetaData.getValue().getColumnMaxValue();
            minMaxFlag[i] = min[i].length != 0 && max[i].length != 0;
            ++i;
        }
        SegmentProperties segmentProperties = SegmentPropertiesAndSchemaHolder.getInstance().addSegmentProperties(this.getCarbonTable(), columnSchemas, segment.getSegmentNo()).getSegmentProperties();
        FilterResolverIntf resolver = new IndexFilter(segmentProperties, this.getCarbonTable(), filter.getExpression()).getResolver();
        FilterExecuter filterExecuter = FilterUtil.getFilterExecuterTree(resolver, segmentProperties, null, null, false);
        BitSet scanRequired = filterExecuter.isScanRequired(max, min, minMaxFlag);
        if (!scanRequired.isEmpty()) {
            isScanRequired = true;
        }
        if (isScanRequired) {
            for (TableBlockIndexUniqueIdentifier tableBlockIndexUniqueIdentifier : identifiers) {
                tableBlockIndexUniqueIdentifierWrappers.add(new TableBlockIndexUniqueIdentifierWrapper(tableBlockIndexUniqueIdentifier, this.getCarbonTable()));
            }
        }
    }

    private void modifyColumnSchemaForSortColumn(ColumnSchema columnSchema, boolean columnDrift, String isColumnDrift, boolean isSortColumnInSegment) {
        if (!isSortColumnInSegment) {
            if (null != isColumnDrift && isColumnDrift.equalsIgnoreCase("true") && !columnDrift) {
                columnSchema.setDimensionColumn(false);
            }
            columnSchema.setSortColumn(false);
            columnSchema.getColumnProperties().clear();
        } else {
            columnSchema.setSortColumn(true);
            if (!columnSchema.isDimensionColumn()) {
                columnSchema.setDimensionColumn(true);
                columnSchema.getColumnProperties().put("column_drift", "true");
            }
            columnSchema.getColumnProperties().put("sort_columns", "true");
        }
    }

    @Override
    public List<CoarseGrainIndex> getIndexes(Segment segment) throws IOException {
        return this.getIndexes(segment, new HashSet<Path>());
    }

    @Override
    public List<CoarseGrainIndex> getIndexes(Segment segment, Set<Path> partitionLocations) throws IOException {
        ArrayList<CoarseGrainIndex> indexes = new ArrayList<CoarseGrainIndex>();
        Set<TableBlockIndexUniqueIdentifier> identifiers = this.getTableBlockIndexUniqueIdentifiers(segment);
        ArrayList<TableBlockIndexUniqueIdentifierWrapper> tableBlockIndexUniqueIdentifierWrappers = new ArrayList<TableBlockIndexUniqueIdentifierWrapper>(identifiers.size());
        this.getTableBlockUniqueIdentifierWrappers(partitionLocations, tableBlockIndexUniqueIdentifierWrappers, identifiers);
        List<BlockletIndexWrapper> blockletIndexWrappers = this.cache.getAll(tableBlockIndexUniqueIdentifierWrappers);
        for (BlockletIndexWrapper wrapper : blockletIndexWrappers) {
            indexes.addAll(wrapper.getIndexes());
        }
        return indexes;
    }

    public Set<TableBlockIndexUniqueIdentifier> getTableBlockIndexUniqueIdentifiers(Segment segment) throws IOException {
        SegmentBlockIndexInfo segmentBlockIndexInfo = this.segmentMap.get(segment.getSegmentNo());
        Set<TableBlockIndexUniqueIdentifier> tableBlockIndexUniqueIdentifiers = null;
        if (null != segmentBlockIndexInfo && null != segmentBlockIndexInfo.getSegmentMetaDataInfo()) {
            segment.setSegmentMetaDataInfo(this.segmentMap.get(segment.getSegmentNo()).getSegmentMetaDataInfo());
            return segmentBlockIndexInfo.getTableBlockIndexUniqueIdentifiers();
        }
        tableBlockIndexUniqueIdentifiers = BlockletIndexUtil.getTableBlockUniqueIdentifiers(segment);
        if (tableBlockIndexUniqueIdentifiers.size() > 0) {
            this.segmentMap.put(segment.getSegmentNo(), new SegmentBlockIndexInfo(tableBlockIndexUniqueIdentifiers, segment.getSegmentMetaDataInfo()));
        }
        return tableBlockIndexUniqueIdentifiers;
    }

    @Override
    public List<ExtendedBlocklet> getExtendedBlocklets(List<Blocklet> blocklets, Segment segment) throws IOException {
        ArrayList<ExtendedBlocklet> detailedBlocklets = new ArrayList<ExtendedBlocklet>(blocklets.size() + 1);
        if (blocklets.size() == 0) {
            return detailedBlocklets;
        }
        if (blocklets.size() > 0 && blocklets.get(0) instanceof ExtendedBlocklet) {
            for (Blocklet blocklet : blocklets) {
                detailedBlocklets.add((ExtendedBlocklet)blocklet);
            }
            return detailedBlocklets;
        }
        Set<TableBlockIndexUniqueIdentifier> identifiers = this.getTableBlockIndexUniqueIdentifiers(segment);
        HashSet<TableBlockIndexUniqueIdentifierWrapper> tableBlockIndexUniqueIdentifierWrappers = new HashSet<TableBlockIndexUniqueIdentifierWrapper>(identifiers.size());
        for (TableBlockIndexUniqueIdentifier tableBlockIndexUniqueIdentifier : identifiers) {
            tableBlockIndexUniqueIdentifierWrappers.add(new TableBlockIndexUniqueIdentifierWrapper(tableBlockIndexUniqueIdentifier, this.getCarbonTable()));
        }
        for (Blocklet blocklet : blocklets) {
            detailedBlocklets.add(this.getExtendedBlocklet(tableBlockIndexUniqueIdentifierWrappers, blocklet));
        }
        return detailedBlocklets;
    }

    @Override
    public ExtendedBlocklet getExtendedBlocklet(Blocklet blocklet, Segment segment) throws IOException {
        if (blocklet instanceof ExtendedBlocklet) {
            return (ExtendedBlocklet)blocklet;
        }
        Set<TableBlockIndexUniqueIdentifier> identifiers = this.getTableBlockIndexUniqueIdentifiers(segment);
        HashSet<TableBlockIndexUniqueIdentifierWrapper> tableBlockIndexUniqueIdentifierWrappers = new HashSet<TableBlockIndexUniqueIdentifierWrapper>(identifiers.size());
        for (TableBlockIndexUniqueIdentifier tableBlockIndexUniqueIdentifier : identifiers) {
            tableBlockIndexUniqueIdentifierWrappers.add(new TableBlockIndexUniqueIdentifierWrapper(tableBlockIndexUniqueIdentifier, this.getCarbonTable()));
        }
        return this.getExtendedBlocklet(tableBlockIndexUniqueIdentifierWrappers, blocklet);
    }

    private ExtendedBlocklet getExtendedBlocklet(Set<TableBlockIndexUniqueIdentifierWrapper> identifiersWrapper, Blocklet blocklet) throws IOException {
        for (TableBlockIndexUniqueIdentifierWrapper identifierWrapper : identifiersWrapper) {
            BlockletIndexWrapper wrapper = this.cache.get(identifierWrapper);
            List<BlockIndex> indexes = wrapper.getIndexes();
            for (Index index : indexes) {
                if (!((BlockIndex)index).getTableTaskInfo(3).startsWith(blocklet.getFilePath())) continue;
                return ((BlockIndex)index).getDetailedBlocklet(blocklet.getBlockletId());
            }
        }
        throw new IOException("Blocklet not found: " + blocklet.toString());
    }

    @Override
    public List<IndexInputSplit> toDistributable(Segment segment) {
        ArrayList<IndexInputSplit> distributables = new ArrayList<IndexInputSplit>();
        try {
            BlockletIndexInputSplit distributable = new BlockletIndexInputSplit();
            distributable.setSegment(segment);
            distributable.setIndexSchema(INDEX_SCHEMA);
            distributable.setSegmentPath(CarbonTablePath.getSegmentPath(this.identifier.getTablePath(), segment.getSegmentNo()));
            distributables.add(new IndexInputSplitWrapper(UUID.randomUUID().toString(), distributable).getDistributable());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return distributables;
    }

    @Override
    public void fireEvent(Event event) {
    }

    @Override
    public void clear(String segment) {
        SegmentBlockIndexInfo segmentBlockIndexInfo = this.segmentMap.remove(segment);
        Set<TableBlockIndexUniqueIdentifier> blockIndexes = null;
        if (null != segmentBlockIndexInfo) {
            blockIndexes = segmentBlockIndexInfo.getTableBlockIndexUniqueIdentifiers();
        }
        if (blockIndexes != null) {
            for (TableBlockIndexUniqueIdentifier blockIndex : blockIndexes) {
                TableBlockIndexUniqueIdentifierWrapper blockIndexWrapper = new TableBlockIndexUniqueIdentifierWrapper(blockIndex, this.getCarbonTable());
                BlockletIndexWrapper wrapper = this.cache.getIfPresent(blockIndexWrapper);
                if (null == wrapper) continue;
                List<BlockIndex> indexes = wrapper.getIndexes();
                for (Index index : indexes) {
                    if (index == null) continue;
                    this.cache.invalidate(blockIndexWrapper);
                    index.clear();
                }
            }
        }
    }

    @Override
    public synchronized void clear() {
        if (this.segmentMap.size() > 0) {
            for (String segmentId : this.segmentMap.keySet().toArray(new String[this.segmentMap.size()])) {
                this.clear(segmentId);
            }
        }
    }

    @Override
    public String getCacheSize() {
        long sum = 0L;
        int numOfIndexFiles = 0;
        for (Map.Entry<String, SegmentBlockIndexInfo> entry : this.segmentMap.entrySet()) {
            for (TableBlockIndexUniqueIdentifier tableBlockIndexUniqueIdentifier : entry.getValue().getTableBlockIndexUniqueIdentifiers()) {
                BlockletIndexWrapper blockletIndexWrapper = this.cache.getIfPresent(new TableBlockIndexUniqueIdentifierWrapper(tableBlockIndexUniqueIdentifier, this.getCarbonTable()));
                if (blockletIndexWrapper == null) continue;
                sum += blockletIndexWrapper.getMemorySize();
                ++numOfIndexFiles;
            }
        }
        return numOfIndexFiles + ":" + sum;
    }

    @Override
    public List<CoarseGrainIndex> getIndexes(IndexInputSplit distributable) throws IOException {
        BlockletIndexInputSplit mapDistributable = (BlockletIndexInputSplit)distributable;
        String segmentNo = mapDistributable.getSegment().getSegmentNo();
        List<TableBlockIndexUniqueIdentifierWrapper> identifiersWrapper = mapDistributable.getSegmentPath() != null ? this.getTableBlockIndexUniqueIdentifier(distributable) : this.getTableBlockIndexUniqueIdentifier(mapDistributable.getFilePath(), segmentNo);
        ArrayList<CoarseGrainIndex> indexes = new ArrayList<CoarseGrainIndex>();
        try {
            List<BlockletIndexWrapper> wrappers = this.cache.getAll(identifiersWrapper);
            for (BlockletIndexWrapper wrapper : wrappers) {
                indexes.addAll(wrapper.getIndexes());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return indexes;
    }

    private List<TableBlockIndexUniqueIdentifierWrapper> getTableBlockIndexUniqueIdentifier(IndexInputSplit distributable) throws IOException {
        ArrayList<TableBlockIndexUniqueIdentifierWrapper> identifiersWrapper = new ArrayList<TableBlockIndexUniqueIdentifierWrapper>();
        SegmentBlockIndexInfo segmentBlockIndexInfo = this.segmentMap.get(distributable.getSegment().getSegmentNo());
        Set<TableBlockIndexUniqueIdentifier> tableBlockIndexUniqueIdentifiers = null;
        if (null != segmentBlockIndexInfo) {
            tableBlockIndexUniqueIdentifiers = segmentBlockIndexInfo.getTableBlockIndexUniqueIdentifiers();
        }
        if (tableBlockIndexUniqueIdentifiers == null) {
            tableBlockIndexUniqueIdentifiers = new HashSet<TableBlockIndexUniqueIdentifier>();
            Set<String> indexFiles = distributable.getSegment().getCommittedIndexFile().keySet();
            for (String indexFile : indexFiles) {
                String mergeIndexName;
                String indexFileName;
                CarbonFile carbonFile = FileFactory.getCarbonFile(indexFile);
                if (indexFile.endsWith(".carbonindex")) {
                    indexFileName = carbonFile.getName();
                    mergeIndexName = null;
                } else {
                    indexFileName = carbonFile.getName();
                    mergeIndexName = carbonFile.getName();
                }
                String parentPath = carbonFile.getParentFile().getAbsolutePath();
                TableBlockIndexUniqueIdentifier tableBlockIndexUniqueIdentifier = new TableBlockIndexUniqueIdentifier(parentPath, indexFileName, mergeIndexName, distributable.getSegment().getSegmentNo());
                identifiersWrapper.add(new TableBlockIndexUniqueIdentifierWrapper(tableBlockIndexUniqueIdentifier, this.getCarbonTable()));
                tableBlockIndexUniqueIdentifiers.add(tableBlockIndexUniqueIdentifier);
            }
            this.segmentMap.put(distributable.getSegment().getSegmentNo(), new SegmentBlockIndexInfo(tableBlockIndexUniqueIdentifiers, distributable.getSegment().getSegmentMetaDataInfo()));
        } else {
            for (TableBlockIndexUniqueIdentifier tableBlockIndexUniqueIdentifier : tableBlockIndexUniqueIdentifiers) {
                identifiersWrapper.add(new TableBlockIndexUniqueIdentifierWrapper(tableBlockIndexUniqueIdentifier, this.getCarbonTable()));
            }
        }
        return identifiersWrapper;
    }

    private List<TableBlockIndexUniqueIdentifierWrapper> getTableBlockIndexUniqueIdentifier(String indexFilePath, String segmentId) throws IOException {
        ArrayList<TableBlockIndexUniqueIdentifierWrapper> identifiersWrapper = new ArrayList<TableBlockIndexUniqueIdentifierWrapper>();
        String parent = indexFilePath.substring(0, indexFilePath.lastIndexOf("/"));
        String name = indexFilePath.substring(indexFilePath.lastIndexOf("/") + 1, indexFilePath.length());
        if (indexFilePath.endsWith(".carbonindex")) {
            identifiersWrapper.add(new TableBlockIndexUniqueIdentifierWrapper(new TableBlockIndexUniqueIdentifier(parent, name, null, segmentId), this.getCarbonTable()));
        } else if (indexFilePath.endsWith(".carbonindexmerge")) {
            SegmentIndexFileStore fileStore = new SegmentIndexFileStore();
            List<String> indexFiles = fileStore.getIndexFilesFromMergeFile(indexFilePath);
            for (String indexFile : indexFiles) {
                identifiersWrapper.add(new TableBlockIndexUniqueIdentifierWrapper(new TableBlockIndexUniqueIdentifier(parent, indexFile, name, segmentId), this.getCarbonTable()));
            }
        }
        return identifiersWrapper;
    }

    @Override
    public IndexMeta getMeta() {
        return null;
    }

    @Override
    public void deleteIndexData(Segment segment) {
    }

    @Override
    public void deleteIndexData() {
    }

    @Override
    public SegmentProperties getSegmentProperties(Segment segment) throws IOException {
        return this.getSegmentProperties(segment, new HashSet<Path>());
    }

    @Override
    public SegmentProperties getSegmentProperties(Segment segment, Set<Path> partitionLocations) throws IOException {
        List<CoarseGrainIndex> indexes = this.getIndexes(segment, partitionLocations);
        assert (indexes.size() > 0);
        CoarseGrainIndex coarseGrainIndex = indexes.get(0);
        assert (coarseGrainIndex instanceof BlockIndex);
        BlockIndex index = (BlockIndex)coarseGrainIndex;
        return index.getSegmentProperties();
    }

    @Override
    public SegmentProperties getSegmentPropertiesFromIndex(Index coarseGrainIndex) {
        assert (coarseGrainIndex instanceof BlockIndex);
        BlockIndex index = (BlockIndex)coarseGrainIndex;
        return index.getSegmentProperties();
    }

    @Override
    public List<Blocklet> getAllBlocklets(Segment segment, Set<Path> partitionLocations) throws IOException {
        ArrayList<Blocklet> blocklets = new ArrayList<Blocklet>();
        List<CoarseGrainIndex> indexes = this.getIndexes(segment, partitionLocations);
        if (indexes.size() == 0) {
            return blocklets;
        }
        SegmentProperties segmentProperties = this.getSegmentPropertiesFromIndex(indexes.get(0));
        for (CoarseGrainIndex index : indexes) {
            blocklets.addAll(index.prune(null, segmentProperties, null, this.getCarbonTable()));
        }
        return blocklets;
    }

    @Override
    public boolean willBecomeStale(TableOperation operation) {
        return false;
    }

    @Override
    public void cache(TableBlockIndexUniqueIdentifierWrapper tableBlockIndexUniqueIdentifierWrapper, BlockletIndexWrapper blockletIndexWrapper) throws IOException {
        this.cache.put(tableBlockIndexUniqueIdentifierWrapper, blockletIndexWrapper);
    }

    @Override
    public List<IndexInputSplit> getAllUncachedDistributables(List<IndexInputSplit> distributables) throws IOException {
        ArrayList<IndexInputSplit> distributablesToBeLoaded = new ArrayList<IndexInputSplit>(distributables.size());
        for (IndexInputSplit distributable : distributables) {
            Segment segment = distributable.getSegment();
            Set<TableBlockIndexUniqueIdentifier> tableBlockIndexUniqueIdentifiers = this.getTableBlockIndexUniqueIdentifiers(segment);
            TableBlockIndexUniqueIdentifier validIdentifier = BlockletIndexUtil.filterIdentifiersBasedOnDistributable(tableBlockIndexUniqueIdentifiers, (BlockletIndexInputSplit)distributable);
            if (null != this.cache.getIfPresent(new TableBlockIndexUniqueIdentifierWrapper(validIdentifier, this.getCarbonTable()))) continue;
            ((BlockletIndexInputSplit)distributable).setTableBlockIndexUniqueIdentifier(validIdentifier);
            distributablesToBeLoaded.add(distributable);
        }
        return distributablesToBeLoaded;
    }

    private Set<TableBlockIndexUniqueIdentifier> getTableSegmentUniqueIdentifiers(Segment segment) throws IOException {
        SegmentBlockIndexInfo segmentBlockIndexInfo = this.segmentMap.get(segment.getSegmentNo());
        if (segmentBlockIndexInfo == null) {
            return BlockletIndexUtil.getSegmentUniqueIdentifiers(segment);
        }
        return segmentBlockIndexInfo.getTableBlockIndexUniqueIdentifiers();
    }

    @Override
    public void updateSegmentIndex(Map<String, Set<TableBlockIndexUniqueIdentifier>> indexUniqueIdentifiers) {
        for (Map.Entry<String, Set<TableBlockIndexUniqueIdentifier>> identifier : indexUniqueIdentifiers.entrySet()) {
            this.segmentMap.put(identifier.getKey(), new SegmentBlockIndexInfo(identifier.getValue(), null));
        }
    }

    @Override
    public List<IndexInputSplit> getAllUncachedDistributables(List<Segment> validSegments, IndexExprWrapper indexExprWrapper) throws IOException {
        ArrayList<IndexInputSplit> distributablesToBeLoaded = new ArrayList<IndexInputSplit>();
        for (Segment segment : validSegments) {
            IndexInputSplitWrapper indexInputSplitWrappers = indexExprWrapper.toDistributableSegment(segment);
            Set<TableBlockIndexUniqueIdentifier> tableBlockIndexUniqueIdentifiers = this.getTableSegmentUniqueIdentifiers(segment);
            for (TableBlockIndexUniqueIdentifier identifier : tableBlockIndexUniqueIdentifiers) {
                BlockletIndexWrapper blockletIndexWrapper = this.cache.getIfPresent(new TableBlockIndexUniqueIdentifierWrapper(identifier, this.getCarbonTable()));
                if (identifier.getIndexFilePath() != null && blockletIndexWrapper != null) continue;
                ((BlockletIndexInputSplit)indexInputSplitWrappers.getDistributable()).setTableBlockIndexUniqueIdentifier(identifier);
                distributablesToBeLoaded.add(indexInputSplitWrappers.getDistributable());
            }
        }
        return distributablesToBeLoaded;
    }

    @Override
    public IndexInputSplitWrapper toDistributableSegment(Segment segment, IndexSchema schema, AbsoluteTableIdentifier identifier, String uniqueId) {
        try {
            BlockletIndexInputSplit distributable = new BlockletIndexInputSplit();
            distributable.setIndexSchema(schema);
            distributable.setSegment(segment);
            distributable.setSegmentPath(CarbonTablePath.getSegmentPath(identifier.getTablePath(), segment.getSegmentNo()));
            distributable.setTablePath(identifier.getTablePath());
            return new IndexInputSplitWrapper(uniqueId, distributable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

