/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore.blockletindex;

import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.index.dev.IndexModel;
import org.apache.carbondata.core.indexstore.BlockMetaInfo;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.hadoop.conf.Configuration;

public class BlockletIndexModel
extends IndexModel {
    private byte[] fileData;
    private Map<String, BlockMetaInfo> blockMetaInfoMap;
    private CarbonTable carbonTable;
    private String segmentId;
    private boolean addToUnsafe = true;
    private List<DataFileFooter> indexInfos;
    private boolean serializeDmStore = false;

    public BlockletIndexModel(CarbonTable carbonTable, String filePath, byte[] fileData, Map<String, BlockMetaInfo> blockMetaInfoMap, String segmentId, Configuration configuration) {
        super(filePath, configuration);
        this.fileData = fileData;
        this.blockMetaInfoMap = blockMetaInfoMap;
        this.segmentId = segmentId;
        this.carbonTable = carbonTable;
    }

    public BlockletIndexModel(CarbonTable carbonTable, String filePath, byte[] fileData, Map<String, BlockMetaInfo> blockMetaInfoMap, String segmentId, boolean addToUnsafe, Configuration configuration, boolean serializeDmStore) {
        this(carbonTable, filePath, fileData, blockMetaInfoMap, segmentId, configuration);
        this.addToUnsafe = addToUnsafe;
        this.serializeDmStore = serializeDmStore;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public Map<String, BlockMetaInfo> getBlockMetaInfoMap() {
        return this.blockMetaInfoMap;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public boolean isAddToUnsafe() {
        return this.addToUnsafe;
    }

    public CarbonTable getCarbonTable() {
        return this.carbonTable;
    }

    public void setIndexInfos(List<DataFileFooter> indexInfos) {
        this.indexInfos = indexInfos;
    }

    public List<DataFileFooter> getIndexInfos() {
        return this.indexInfos;
    }

    public boolean isSerializeDmStore() {
        return this.serializeDmStore;
    }
}

