/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore.blockletindex;

import java.util.List;
import org.apache.carbondata.core.datastore.block.AbstractIndex;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.indexstore.blockletindex.BlockletDataRefNode;

public class IndexWrapper
extends AbstractIndex {
    private List<TableBlockInfo> blockInfos;

    public IndexWrapper(List<TableBlockInfo> blockInfos, SegmentProperties segmentProperties) {
        this.blockInfos = blockInfos;
        this.segmentProperties = segmentProperties;
        this.dataRefNode = new BlockletDataRefNode(blockInfos, 0);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.blockInfos != null) {
            for (TableBlockInfo blockInfo : this.blockInfos) {
                String indexWriterPath = blockInfo.getIndexWriterPath();
                if (indexWriterPath == null) continue;
                CarbonFile file = FileFactory.getCarbonFile(indexWriterPath);
                FileFactory.deleteAllCarbonFilesOfDir(file);
            }
        }
    }
}

