/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore.blockletindex;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.reader.CarbonIndexFileReader;
import org.apache.carbondata.core.reader.ThriftReader;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.util.CarbonMetadataUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataFileFooterConverter;
import org.apache.carbondata.format.BlockIndex;
import org.apache.carbondata.format.IndexHeader;
import org.apache.carbondata.format.MergedBlockIndex;
import org.apache.carbondata.format.MergedBlockIndexHeader;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;

public class SegmentIndexFileStore {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)SegmentIndexFileStore.class.getName());
    private Map<String, byte[]> carbonIndexMap = new HashMap<String, byte[]>();
    private Map<String, byte[]> carbonIndexMapWithFullPath = new TreeMap<String, byte[]>();
    private Map<String, List<String>> carbonMergeFileToIndexFilesMap = new HashMap<String, List<String>>();
    private Configuration configuration;

    public SegmentIndexFileStore() {
        this.configuration = FileFactory.getConfiguration();
    }

    public SegmentIndexFileStore(Configuration configuration) {
        this.configuration = configuration;
    }

    public void readAllIIndexOfSegment(String segmentPath) throws IOException {
        CarbonFile[] carbonIndexFiles = SegmentIndexFileStore.getCarbonIndexFiles(segmentPath, this.configuration);
        for (int i = 0; i < carbonIndexFiles.length; ++i) {
            if (carbonIndexFiles[i].getName().endsWith(".carbonindexmerge")) {
                this.readMergeFile(carbonIndexFiles[i].getCanonicalPath());
                continue;
            }
            if (!carbonIndexFiles[i].getName().endsWith(".carbonindex")) continue;
            this.readIndexFile(carbonIndexFiles[i]);
        }
    }

    public void readAllIIndexOfSegment(SegmentFileStore.SegmentFile segmentFile, String tablePath, SegmentStatus status, boolean ignoreStatus) throws IOException {
        ArrayList<CarbonFile> carbonIndexFiles = new ArrayList<CarbonFile>();
        HashSet<String> indexFiles = new HashSet<String>();
        if (segmentFile == null) {
            return;
        }
        for (Map.Entry<String, SegmentFileStore.FolderDetails> locations : segmentFile.getLocationMap().entrySet()) {
            CarbonFile mergeFile;
            String mergeFileName;
            String location = locations.getKey();
            if (!locations.getValue().getStatus().equals(status.getMessage()) && !ignoreStatus) continue;
            if (locations.getValue().isRelative()) {
                location = tablePath + "/" + location;
            }
            if ((mergeFileName = locations.getValue().getMergeFileName()) != null && (mergeFile = FileFactory.getCarbonFile(location + "/" + mergeFileName)).exists() && !indexFiles.contains(mergeFile.getAbsolutePath())) {
                carbonIndexFiles.add(mergeFile);
                indexFiles.add(mergeFile.getAbsolutePath());
            }
            for (String indexFile : locations.getValue().getFiles()) {
                CarbonFile carbonFile = FileFactory.getCarbonFile(location + "/" + indexFile);
                if (!carbonFile.exists() || indexFiles.contains(carbonFile.getAbsolutePath())) continue;
                carbonIndexFiles.add(carbonFile);
                indexFiles.add(carbonFile.getAbsolutePath());
            }
        }
        for (int i = 0; i < carbonIndexFiles.size(); ++i) {
            if (((CarbonFile)carbonIndexFiles.get(i)).getName().endsWith(".carbonindexmerge")) {
                this.readMergeFile(((CarbonFile)carbonIndexFiles.get(i)).getCanonicalPath());
                continue;
            }
            if (!((CarbonFile)carbonIndexFiles.get(i)).getName().endsWith(".carbonindex")) continue;
            this.readIndexFile((CarbonFile)carbonIndexFiles.get(i));
        }
    }

    public void readAllIndexAndFillBolckletInfo(String segmentPath) throws IOException {
        CarbonFile[] carbonIndexFiles = SegmentIndexFileStore.getCarbonIndexFiles(segmentPath, FileFactory.getConfiguration());
        for (int i = 0; i < carbonIndexFiles.length; ++i) {
            if (carbonIndexFiles[i].getName().endsWith(".carbonindexmerge")) {
                this.readMergeFile(carbonIndexFiles[i].getCanonicalPath());
                continue;
            }
            if (!carbonIndexFiles[i].getName().endsWith(".carbonindex")) continue;
            this.readIndexAndFillBlockletInfo(carbonIndexFiles[i]);
        }
    }

    public void readAllIIndexOfSegment(CarbonFile[] carbonFiles) throws IOException {
        CarbonFile[] carbonIndexFiles = SegmentIndexFileStore.getCarbonIndexFiles(carbonFiles);
        for (int i = 0; i < carbonIndexFiles.length; ++i) {
            if (carbonIndexFiles[i].getName().endsWith(".carbonindexmerge")) {
                this.readMergeFile(carbonIndexFiles[i].getCanonicalPath());
                continue;
            }
            if (!carbonIndexFiles[i].getName().endsWith(".carbonindex")) continue;
            this.readIndexFile(carbonIndexFiles[i]);
        }
    }

    public Map<String, String> getIndexFilesFromSegment(String segmentPath) throws IOException {
        CarbonFile[] carbonIndexFiles = SegmentIndexFileStore.getCarbonIndexFiles(segmentPath, FileFactory.getConfiguration());
        HashMap<String, String> indexFiles = new HashMap<String, String>();
        for (int i = 0; i < carbonIndexFiles.length; ++i) {
            if (carbonIndexFiles[i].getName().endsWith(".carbonindexmerge")) {
                List<String> indexFilesFromMergeFile = this.getIndexFilesFromMergeFile(carbonIndexFiles[i].getCanonicalPath());
                for (String file : indexFilesFromMergeFile) {
                    indexFiles.put(carbonIndexFiles[i].getParentFile().getAbsolutePath() + "/" + file, carbonIndexFiles[i].getName());
                }
                continue;
            }
            if (!carbonIndexFiles[i].getName().endsWith(".carbonindex")) continue;
            indexFiles.put(carbonIndexFiles[i].getAbsolutePath(), null);
        }
        return indexFiles;
    }

    public Map<String, String> getMergeOrIndexFilesFromSegment(String segmentPath) {
        CarbonFile[] carbonIndexFiles = SegmentIndexFileStore.getCarbonIndexFiles(segmentPath, FileFactory.getConfiguration());
        HashMap<String, String> indexFiles = new HashMap<String, String>();
        for (int i = 0; i < carbonIndexFiles.length; ++i) {
            if (carbonIndexFiles[i].getName().endsWith(".carbonindexmerge")) {
                indexFiles.put(carbonIndexFiles[i].getAbsolutePath(), carbonIndexFiles[i].getAbsolutePath());
                continue;
            }
            if (!carbonIndexFiles[i].getName().endsWith(".carbonindex")) continue;
            indexFiles.put(carbonIndexFiles[i].getAbsolutePath(), null);
        }
        return indexFiles;
    }

    public List<String> getIndexFilesFromMergeFile(String mergeFile) throws IOException {
        ThriftReader thriftReader = new ThriftReader(mergeFile);
        thriftReader.open();
        MergedBlockIndexHeader indexHeader = this.readMergeBlockIndexHeader(thriftReader);
        List fileNames = indexHeader.getFile_names();
        thriftReader.close();
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMergeFile(String mergeFilePath) throws IOException {
        try (ThriftReader thriftReader = new ThriftReader(mergeFilePath, this.configuration);){
            thriftReader.open();
            MergedBlockIndexHeader indexHeader = this.readMergeBlockIndexHeader(thriftReader);
            MergedBlockIndex mergedBlockIndex = this.readMergeBlockIndex(thriftReader);
            List file_names = indexHeader.getFile_names();
            this.carbonMergeFileToIndexFilesMap.put(mergeFilePath, file_names);
            List fileData = mergedBlockIndex.getFileData();
            CarbonFile mergeFile = FileFactory.getCarbonFile(mergeFilePath, this.configuration);
            String mergeFileAbsolutePath = mergeFile.getParentFile().getAbsolutePath();
            assert (file_names.size() == fileData.size());
            for (int i = 0; i < file_names.size(); ++i) {
                byte[] data = ((ByteBuffer)fileData.get(i)).array();
                this.carbonIndexMap.put((String)file_names.get(i), data);
                this.carbonIndexMapWithFullPath.put(mergeFileAbsolutePath + "/" + (String)file_names.get(i), data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readIndexFile(CarbonFile indexFile) throws IOException {
        String indexFilePath = indexFile.getCanonicalPath();
        byte[] bytes = new byte[(int)indexFile.getSize()];
        try (DataInputStream dataInputStream = FileFactory.getDataInputStream(indexFilePath, this.configuration);){
            dataInputStream.readFully(bytes);
            this.carbonIndexMap.put(indexFile.getName(), bytes);
            this.carbonIndexMapWithFullPath.put(indexFile.getAbsolutePath(), bytes);
        }
    }

    private MergedBlockIndexHeader readMergeBlockIndexHeader(ThriftReader thriftReader) throws IOException {
        return (MergedBlockIndexHeader)thriftReader.read(new ThriftReader.TBaseCreator(){

            @Override
            public TBase create() {
                return new MergedBlockIndexHeader();
            }
        });
    }

    private MergedBlockIndex readMergeBlockIndex(ThriftReader thriftReader) throws IOException {
        return (MergedBlockIndex)thriftReader.read(new ThriftReader.TBaseCreator(){

            @Override
            public TBase create() {
                return new MergedBlockIndex();
            }
        });
    }

    public byte[] getFileData(String fileName) {
        return this.carbonIndexMap.get(fileName);
    }

    public static CarbonFile[] getCarbonIndexFiles(CarbonFile carbonFile) {
        return carbonFile.listFiles(new CarbonFileFilter(){

            @Override
            public boolean accept(CarbonFile file) {
                return (file.getName().endsWith(".carbonindex") || file.getName().endsWith(".carbonindexmerge")) && file.getSize() > 0L;
            }
        });
    }

    public static void getCarbonIndexFilesRecursively(CarbonFile carbonFile, List<CarbonFile> indexFiles) {
        CarbonFile[] carbonFiles;
        for (CarbonFile file : carbonFiles = carbonFile.listFiles()) {
            if (file.isDirectory()) {
                SegmentIndexFileStore.getCarbonIndexFilesRecursively(file, indexFiles);
                continue;
            }
            if (!file.getName().endsWith(".carbonindex") && !file.getName().endsWith(".carbonindexmerge") || file.getSize() <= 0L) continue;
            indexFiles.add(file);
        }
    }

    public static CarbonFile[] getCarbonIndexFiles(String segmentPath, Configuration configuration) {
        CarbonFile carbonFile = FileFactory.getCarbonFile(segmentPath, configuration);
        return carbonFile.listFiles(new CarbonFileFilter(){

            @Override
            public boolean accept(CarbonFile file) {
                return (file.getName().endsWith(".carbonindex") || file.getName().endsWith(".carbonindexmerge")) && file.getSize() > 0L;
            }
        });
    }

    public static CarbonFile[] getCarbonIndexFiles(CarbonFile[] carbonFiles) {
        ArrayList<CarbonFile> indexFiles = new ArrayList<CarbonFile>();
        for (CarbonFile file : carbonFiles) {
            if (!file.getName().endsWith(".carbonindex") && !file.getName().endsWith(".carbonindexmerge")) continue;
            indexFiles.add(file);
        }
        return indexFiles.toArray(new CarbonFile[indexFiles.size()]);
    }

    public Map<String, byte[]> getCarbonIndexMap() {
        return this.carbonIndexMap;
    }

    public Map<String, byte[]> getCarbonIndexMapWithFullPath() {
        return this.carbonIndexMapWithFullPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndexAndFillBlockletInfo(CarbonFile indexFile) throws IOException {
        boolean isCarbonDataFileFooterReadRequired = true;
        List<BlockletInfo> blockletInfoList = null;
        ArrayList<BlockIndex> blockIndexThrift = new ArrayList<BlockIndex>(16);
        CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
        try {
            indexReader.openThriftReader(indexFile.getCanonicalPath());
            IndexHeader indexHeader = indexReader.readIndexHeader();
            DataFileFooterConverter fileFooterConverter = new DataFileFooterConverter(FileFactory.getConfiguration());
            String filePath = FileFactory.getUpdatedFilePath(indexFile.getCanonicalPath());
            String parentPath = filePath.substring(0, filePath.lastIndexOf("/"));
            while (indexReader.hasNext()) {
                BlockIndex blockIndex = indexReader.readBlockIndexInfo();
                if (blockIndex.isSetBlocklet_info()) {
                    isCarbonDataFileFooterReadRequired = false;
                    break;
                }
                TableBlockInfo blockInfo = fileFooterConverter.getTableBlockInfo(blockIndex, indexHeader, parentPath);
                blockletInfoList = this.getBlockletInfoFromIndexInfo(blockInfo);
                for (int i = 0; i < blockletInfoList.size(); ++i) {
                    BlockIndex blockIndexReplica = blockIndex.deepCopy();
                    BlockletInfo blockletInfo = blockletInfoList.get(i);
                    blockIndexReplica.setBlock_index(CarbonMetadataUtil.getBlockletIndex(blockletInfo.getBlockletIndex()));
                    blockIndexReplica.setBlocklet_info(CarbonMetadataUtil.getBlocletInfo3(blockletInfo));
                    blockIndexThrift.add(blockIndexReplica);
                }
            }
            if (!isCarbonDataFileFooterReadRequired) {
                this.readIndexFile(indexFile);
            } else {
                int totalSize = 0;
                ArrayList<byte[]> blockIndexByteArrayList = new ArrayList<byte[]>(16);
                byte[] indexHeaderBytes = CarbonUtil.getByteArray((TBase)indexHeader);
                totalSize += indexHeaderBytes.length;
                blockIndexByteArrayList.add(indexHeaderBytes);
                for (BlockIndex blockIndex : blockIndexThrift) {
                    byte[] indexInfoBytes = CarbonUtil.getByteArray((TBase)blockIndex);
                    totalSize += indexInfoBytes.length;
                    blockIndexByteArrayList.add(indexInfoBytes);
                }
                ByteBuffer byteBuffer = ByteBuffer.allocate(totalSize);
                for (byte[] blockIndexBytes : blockIndexByteArrayList) {
                    byteBuffer.put(blockIndexBytes);
                }
                this.carbonIndexMap.put(indexFile.getName(), byteBuffer.array());
            }
        }
        finally {
            indexReader.closeThriftReader();
        }
    }

    private List<BlockletInfo> getBlockletInfoFromIndexInfo(TableBlockInfo blockInfo) throws IOException {
        long startTime = System.currentTimeMillis();
        DataFileFooter carbondataFileFooter = CarbonUtil.readMetadataFile(blockInfo);
        LOGGER.info((Object)("Time taken to read carbondata file footer to get blocklet info " + blockInfo.getFilePath() + " is " + (System.currentTimeMillis() - startTime)));
        return carbondataFileFooter.getBlockletList();
    }

    public Map<String, List<String>> getCarbonMergeFileToIndexFilesMap() {
        return this.carbonMergeFileToIndexFilesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexHeader readIndexHeader(String indexFilePath, Configuration configuration) {
        byte[] indexContent = null;
        if (indexFilePath.toLowerCase().endsWith(".carbonindexmerge")) {
            SegmentIndexFileStore indexFileStore = new SegmentIndexFileStore(configuration);
            try {
                indexFileStore.readMergeFile(indexFilePath);
            }
            catch (IOException ex) {
                LOGGER.error((Object)ex);
            }
            Iterator<Map.Entry<String, byte[]>> iterator = indexFileStore.getCarbonIndexMap().entrySet().iterator();
            if (iterator.hasNext()) {
                indexContent = iterator.next().getValue();
            }
        }
        CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
        IndexHeader indexHeader = null;
        try {
            if (indexContent == null) {
                indexReader.openThriftReader(indexFilePath);
            } else {
                indexReader.openThriftReader(indexContent);
            }
            indexHeader = indexReader.readIndexHeader();
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex);
        }
        finally {
            indexReader.closeThriftReader();
        }
        return indexHeader;
    }
}

