/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore.row;

import java.io.Serializable;
import org.apache.carbondata.core.indexstore.schema.CarbonRowSchema;

public abstract class IndexRow
implements Serializable {
    protected transient CarbonRowSchema[] schemas;

    public IndexRow(CarbonRowSchema[] schemas) {
        this.schemas = schemas;
    }

    public abstract byte[] getByteArray(int var1);

    public abstract IndexRow getRow(int var1);

    public abstract void setRow(IndexRow var1, int var2);

    public abstract void setByteArray(byte[] var1, int var2);

    public abstract int getInt(int var1);

    public abstract void setInt(int var1, int var2);

    public abstract void setByte(byte var1, int var2);

    public abstract byte getByte(int var1);

    public abstract void setShort(short var1, int var2);

    public abstract short getShort(int var1);

    public abstract void setLong(long var1, int var3);

    public abstract long getLong(int var1);

    public abstract void setFloat(float var1, int var2);

    public abstract float getFloat(int var1);

    public abstract void setDouble(double var1, int var3);

    public abstract double getDouble(int var1);

    public abstract int getLengthInBytes(int var1);

    public abstract void setBoolean(boolean var1, int var2);

    public abstract boolean getBoolean(int var1);

    public int getTotalSizeInBytes() {
        int len = 0;
        for (int i = 0; i < this.schemas.length; ++i) {
            len += this.getSizeInBytes(i);
        }
        return len += 4;
    }

    public int getSizeInBytes(int ordinal) {
        switch (this.schemas[ordinal].getSchemaType()) {
            case FIXED: {
                return this.schemas[ordinal].getLength();
            }
            case VARIABLE_SHORT: 
            case VARIABLE_INT: {
                return this.getLengthInBytes(ordinal) + 4;
            }
            case STRUCT: {
                IndexRow row = this.getRow(ordinal);
                CarbonRowSchema[] childSchemas = ((CarbonRowSchema.StructCarbonRowSchema)this.schemas[ordinal]).getChildSchemas();
                row.setSchemas(childSchemas);
                return this.getRow(ordinal).getTotalSizeInBytes();
            }
        }
        throw new UnsupportedOperationException("wrong type");
    }

    public int getColumnCount() {
        return this.schemas.length;
    }

    public void setSchemas(CarbonRowSchema[] schemas) {
        if (null == this.schemas) {
            this.schemas = schemas;
        }
    }
}

