/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore.row;

import org.apache.carbondata.core.indexstore.row.IndexRow;
import org.apache.carbondata.core.indexstore.schema.CarbonRowSchema;
import org.apache.carbondata.core.metadata.datatype.DataTypes;

public class IndexRowImpl
extends IndexRow {
    private Object[] data;
    private int totalLengthInBytes;

    public IndexRowImpl(CarbonRowSchema[] schemas) {
        super(schemas);
        this.data = new Object[schemas.length];
    }

    @Override
    public byte[] getByteArray(int ordinal) {
        return (byte[])this.data[ordinal];
    }

    @Override
    public int getLengthInBytes(int ordinal) {
        if (this.data[ordinal] == null) {
            return 0;
        }
        return ((byte[])this.data[ordinal]).length;
    }

    @Override
    public void setBoolean(boolean value, int ordinal) {
        assert (this.schemas[ordinal].getDataType() == DataTypes.BOOLEAN);
        this.data[ordinal] = value;
    }

    @Override
    public boolean getBoolean(int ordinal) {
        return (Boolean)this.data[ordinal];
    }

    @Override
    public IndexRow getRow(int ordinal) {
        return (IndexRow)this.data[ordinal];
    }

    @Override
    public void setByteArray(byte[] byteArray, int ordinal) {
        assert (this.schemas[ordinal].getDataType() == DataTypes.BYTE_ARRAY);
        this.data[ordinal] = byteArray;
    }

    @Override
    public int getInt(int ordinal) {
        return (Integer)this.data[ordinal];
    }

    @Override
    public void setInt(int value, int ordinal) {
        assert (this.schemas[ordinal].getDataType() == DataTypes.INT);
        this.data[ordinal] = value;
    }

    @Override
    public void setByte(byte value, int ordinal) {
        assert (this.schemas[ordinal].getDataType() == DataTypes.BYTE);
        this.data[ordinal] = value;
    }

    @Override
    public byte getByte(int ordinal) {
        return (Byte)this.data[ordinal];
    }

    @Override
    public void setShort(short value, int ordinal) {
        assert (this.schemas[ordinal].getDataType() == DataTypes.SHORT);
        this.data[ordinal] = value;
    }

    @Override
    public short getShort(int ordinal) {
        return (Short)this.data[ordinal];
    }

    @Override
    public void setLong(long value, int ordinal) {
        assert (this.schemas[ordinal].getDataType() == DataTypes.LONG);
        this.data[ordinal] = value;
    }

    @Override
    public long getLong(int ordinal) {
        return (Long)this.data[ordinal];
    }

    @Override
    public void setFloat(float value, int ordinal) {
        assert (this.schemas[ordinal].getDataType() == DataTypes.FLOAT);
        this.data[ordinal] = Float.valueOf(value);
    }

    @Override
    public float getFloat(int ordinal) {
        return ((Float)this.data[ordinal]).floatValue();
    }

    @Override
    public void setDouble(double value, int ordinal) {
        assert (this.schemas[ordinal].getDataType() == DataTypes.DOUBLE);
        this.data[ordinal] = value;
    }

    @Override
    public void setRow(IndexRow row, int ordinal) {
        assert (DataTypes.isStructType(this.schemas[ordinal].getDataType()));
        this.data[ordinal] = row;
    }

    @Override
    public double getDouble(int ordinal) {
        return (Double)this.data[ordinal];
    }

    public void setTotalLengthInBytes(int totalLengthInBytes) {
        this.totalLengthInBytes = totalLengthInBytes;
    }

    @Override
    public int getTotalSizeInBytes() {
        if (this.totalLengthInBytes > 0) {
            return this.totalLengthInBytes;
        }
        return super.getTotalSizeInBytes();
    }
}

