/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore.row;

import org.apache.carbondata.core.indexstore.row.IndexRow;
import org.apache.carbondata.core.indexstore.schema.CarbonRowSchema;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.memory.MemoryBlock;

public class UnsafeIndexRow
extends IndexRow {
    private static final long serialVersionUID = -1156704133552046321L;
    private transient MemoryBlock block;
    private int pointer;

    public UnsafeIndexRow(CarbonRowSchema[] schemas, MemoryBlock block, int pointer) {
        super(schemas);
        this.block = block;
        this.pointer = pointer;
    }

    @Override
    public byte[] getByteArray(int ordinal) {
        int length;
        int currentOffset;
        switch (this.schemas[ordinal].getSchemaType()) {
            case VARIABLE_SHORT: 
            case VARIABLE_INT: {
                int schemaOrdinal = this.schemas[ordinal].getBytePosition();
                currentOffset = CarbonUnsafe.getUnsafe().getInt(this.block.getBaseObject(), this.block.getBaseOffset() + (long)this.pointer + (long)schemaOrdinal);
                int nextOffset = CarbonUnsafe.getUnsafe().getInt(this.block.getBaseObject(), this.block.getBaseOffset() + (long)this.pointer + (long)schemaOrdinal + 4L);
                length = nextOffset - currentOffset;
                break;
            }
            default: {
                currentOffset = this.schemas[ordinal].getBytePosition();
                length = this.schemas[ordinal].getLength();
            }
        }
        byte[] data = new byte[length];
        CarbonUnsafe.getUnsafe().copyMemory(this.block.getBaseObject(), this.block.getBaseOffset() + (long)this.pointer + (long)currentOffset, data, CarbonUnsafe.BYTE_ARRAY_OFFSET, data.length);
        return data;
    }

    @Override
    public int getLengthInBytes(int ordinal) {
        int length;
        int schemaOrdinal = this.schemas[ordinal].getBytePosition();
        switch (this.schemas[ordinal].getSchemaType()) {
            case VARIABLE_SHORT: 
            case VARIABLE_INT: {
                int currentOffset = CarbonUnsafe.getUnsafe().getInt(this.block.getBaseObject(), this.block.getBaseOffset() + (long)this.pointer + (long)schemaOrdinal);
                int nextOffset = CarbonUnsafe.getUnsafe().getInt(this.block.getBaseObject(), this.block.getBaseOffset() + (long)this.pointer + (long)schemaOrdinal + 4L);
                length = nextOffset - currentOffset;
                break;
            }
            default: {
                length = this.schemas[ordinal].getLength();
            }
        }
        return length;
    }

    @Override
    public void setBoolean(boolean value, int ordinal) {
        throw new UnsupportedOperationException("Not supported to set on unsafe row");
    }

    @Override
    public boolean getBoolean(int ordinal) {
        return CarbonUnsafe.getUnsafe().getBoolean(this.block.getBaseObject(), this.block.getBaseOffset() + (long)this.pointer + (long)this.schemas[ordinal].getBytePosition());
    }

    @Override
    public IndexRow getRow(int ordinal) {
        CarbonRowSchema[] childSchemas = ((CarbonRowSchema.StructCarbonRowSchema)this.schemas[ordinal]).getChildSchemas();
        return new UnsafeIndexRow(childSchemas, this.block, this.pointer);
    }

    @Override
    public void setByteArray(byte[] byteArray, int ordinal) {
        throw new UnsupportedOperationException("Not supported to set on unsafe row");
    }

    @Override
    public int getInt(int ordinal) {
        return CarbonUnsafe.getUnsafe().getInt(this.block.getBaseObject(), this.block.getBaseOffset() + (long)this.pointer + (long)this.schemas[ordinal].getBytePosition());
    }

    @Override
    public void setInt(int value, int ordinal) {
        throw new UnsupportedOperationException("Not supported to set on unsafe row");
    }

    @Override
    public void setByte(byte value, int ordinal) {
        throw new UnsupportedOperationException("Not supported to set on unsafe row");
    }

    @Override
    public byte getByte(int ordinal) {
        return CarbonUnsafe.getUnsafe().getByte(this.block.getBaseObject(), this.block.getBaseOffset() + (long)this.pointer + (long)this.schemas[ordinal].getBytePosition());
    }

    @Override
    public void setShort(short value, int ordinal) {
        throw new UnsupportedOperationException("Not supported to set on unsafe row");
    }

    @Override
    public short getShort(int ordinal) {
        return CarbonUnsafe.getUnsafe().getShort(this.block.getBaseObject(), this.block.getBaseOffset() + (long)this.pointer + (long)this.schemas[ordinal].getBytePosition());
    }

    @Override
    public void setLong(long value, int ordinal) {
        throw new UnsupportedOperationException("Not supported to set on unsafe row");
    }

    @Override
    public long getLong(int ordinal) {
        return CarbonUnsafe.getUnsafe().getLong(this.block.getBaseObject(), this.block.getBaseOffset() + (long)this.pointer + (long)this.schemas[ordinal].getBytePosition());
    }

    @Override
    public void setFloat(float value, int ordinal) {
        throw new UnsupportedOperationException("Not supported to set on unsafe row");
    }

    @Override
    public float getFloat(int ordinal) {
        return CarbonUnsafe.getUnsafe().getFloat(this.block.getBaseObject(), this.block.getBaseOffset() + (long)this.pointer + (long)this.schemas[ordinal].getBytePosition());
    }

    @Override
    public void setDouble(double value, int ordinal) {
        throw new UnsupportedOperationException("Not supported to set on unsafe row");
    }

    @Override
    public double getDouble(int ordinal) {
        return CarbonUnsafe.getUnsafe().getDouble(this.block.getBaseObject(), this.block.getBaseOffset() + (long)this.pointer + (long)this.schemas[ordinal].getBytePosition());
    }

    @Override
    public void setRow(IndexRow row, int ordinal) {
        throw new UnsupportedOperationException("Not supported to set on unsafe row");
    }
}

