/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore.schema;

import java.io.Serializable;
import org.apache.carbondata.core.metadata.datatype.DataType;

public abstract class CarbonRowSchema
implements Serializable {
    private static final long serialVersionUID = -8061282029097686495L;
    protected DataType dataType;
    private int bytePosition = -1;

    public CarbonRowSchema(DataType dataType) {
        this.dataType = dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getLength() {
        return this.dataType.getSizeInBytes();
    }

    public void setBytePosition(int bytePosition) {
        this.bytePosition = bytePosition;
    }

    public int getBytePosition() {
        return this.bytePosition;
    }

    public abstract IndexSchemaType getSchemaType();

    public static enum IndexSchemaType {
        FIXED,
        VARIABLE_INT,
        VARIABLE_SHORT,
        STRUCT;

    }

    public static class StructCarbonRowSchema
    extends CarbonRowSchema {
        private CarbonRowSchema[] childSchemas;

        public StructCarbonRowSchema(DataType dataType, CarbonRowSchema[] childSchemas) {
            super(dataType);
            this.childSchemas = childSchemas;
        }

        @Override
        public int getLength() {
            return this.dataType.getSizeInBytes();
        }

        public CarbonRowSchema[] getChildSchemas() {
            return this.childSchemas;
        }

        @Override
        public IndexSchemaType getSchemaType() {
            return IndexSchemaType.STRUCT;
        }
    }

    public static class VariableCarbonRowSchema
    extends CarbonRowSchema {
        private boolean isVarcharType = false;

        public VariableCarbonRowSchema(DataType dataType) {
            super(dataType);
        }

        public VariableCarbonRowSchema(DataType dataType, boolean isVarcharType) {
            super(dataType);
            this.isVarcharType = isVarcharType;
        }

        @Override
        public int getLength() {
            return this.dataType.getSizeInBytes();
        }

        @Override
        public IndexSchemaType getSchemaType() {
            return this.isVarcharType ? IndexSchemaType.VARIABLE_INT : IndexSchemaType.VARIABLE_SHORT;
        }
    }

    public static class FixedCarbonRowSchema
    extends CarbonRowSchema {
        private int length;

        public FixedCarbonRowSchema(DataType dataType) {
            super(dataType);
        }

        public FixedCarbonRowSchema(DataType dataType, int length) {
            super(dataType);
            this.length = length;
        }

        @Override
        public int getLength() {
            if (this.length == 0) {
                return this.dataType.getSizeInBytes();
            }
            return this.length;
        }

        @Override
        public IndexSchemaType getSchemaType() {
            return IndexSchemaType.FIXED;
        }
    }
}

