/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.indexstore.schema.CarbonRowSchema;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.util.BlockletIndexUtil;

public class SchemaGenerator {
    public static CarbonRowSchema[] createBlockSchema(SegmentProperties segmentProperties, List<CarbonColumn> minMaxCacheColumns) {
        ArrayList<CarbonRowSchema> indexSchemas = new ArrayList<CarbonRowSchema>();
        SchemaGenerator.getMinMaxSchema(segmentProperties, indexSchemas, minMaxCacheColumns);
        indexSchemas.add(new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.INT));
        indexSchemas.add(new CarbonRowSchema.VariableCarbonRowSchema(DataTypes.BYTE_ARRAY));
        indexSchemas.add(new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.SHORT));
        indexSchemas.add(new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.LONG));
        indexSchemas.add(new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.LONG));
        indexSchemas.add(new CarbonRowSchema.VariableCarbonRowSchema(DataTypes.BYTE_ARRAY));
        indexSchemas.add(new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.LONG));
        SchemaGenerator.addMinMaxFlagSchema(segmentProperties, indexSchemas, minMaxCacheColumns);
        CarbonRowSchema[] schema = indexSchemas.toArray(new CarbonRowSchema[indexSchemas.size()]);
        SchemaGenerator.updateBytePosition(schema);
        return schema;
    }

    private static void updateBytePosition(CarbonRowSchema[] schema) {
        int j;
        CarbonRowSchema[] childSchemas;
        int i;
        int bytePosition = 0;
        block6: for (i = 0; i < schema.length; ++i) {
            switch (schema[i].getSchemaType()) {
                case STRUCT: {
                    int currentSize;
                    childSchemas = ((CarbonRowSchema.StructCarbonRowSchema)schema[i]).getChildSchemas();
                    for (j = 0; j < childSchemas.length; ++j) {
                        currentSize = SchemaGenerator.getSchemaSize(childSchemas[j]);
                        if (currentSize == -1) continue;
                        childSchemas[j].setBytePosition(bytePosition);
                        bytePosition += currentSize;
                    }
                    continue block6;
                }
                default: {
                    int currentSize = SchemaGenerator.getSchemaSize(schema[i]);
                    if (currentSize == -1) continue block6;
                    schema[i].setBytePosition(bytePosition);
                    bytePosition += currentSize;
                }
            }
        }
        block8: for (i = 0; i < schema.length; ++i) {
            switch (schema[i].getSchemaType()) {
                case STRUCT: {
                    childSchemas = ((CarbonRowSchema.StructCarbonRowSchema)schema[i]).getChildSchemas();
                    for (j = 0; j < childSchemas.length; ++j) {
                        if (childSchemas[j].getBytePosition() != -1) continue;
                        childSchemas[j].setBytePosition(bytePosition);
                        bytePosition += 4;
                    }
                    continue block8;
                }
                default: {
                    if (schema[i].getBytePosition() != -1) continue block8;
                    schema[i].setBytePosition(bytePosition);
                    bytePosition += 4;
                }
            }
        }
    }

    private static int getSchemaSize(CarbonRowSchema schema) {
        switch (schema.getSchemaType()) {
            case FIXED: {
                return schema.getLength();
            }
            case VARIABLE_SHORT: 
            case VARIABLE_INT: {
                return -1;
            }
        }
        throw new UnsupportedOperationException("Invalid Type");
    }

    public static CarbonRowSchema[] createBlockletSchema(SegmentProperties segmentProperties, List<CarbonColumn> minMaxCacheColumns) {
        ArrayList<CarbonRowSchema> indexSchemas = new ArrayList<CarbonRowSchema>();
        SchemaGenerator.getMinMaxSchema(segmentProperties, indexSchemas, minMaxCacheColumns);
        indexSchemas.add(new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.INT));
        indexSchemas.add(new CarbonRowSchema.VariableCarbonRowSchema(DataTypes.BYTE_ARRAY));
        indexSchemas.add(new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.SHORT));
        indexSchemas.add(new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.LONG));
        indexSchemas.add(new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.LONG));
        indexSchemas.add(new CarbonRowSchema.VariableCarbonRowSchema(DataTypes.BYTE_ARRAY));
        indexSchemas.add(new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.LONG));
        SchemaGenerator.addMinMaxFlagSchema(segmentProperties, indexSchemas, minMaxCacheColumns);
        indexSchemas.add(new CarbonRowSchema.VariableCarbonRowSchema(DataTypes.BYTE_ARRAY));
        indexSchemas.add(new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.SHORT));
        indexSchemas.add(new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.SHORT));
        CarbonRowSchema[] schema = indexSchemas.toArray(new CarbonRowSchema[indexSchemas.size()]);
        SchemaGenerator.updateBytePosition(schema);
        return schema;
    }

    public static CarbonRowSchema[] createTaskSummarySchema(SegmentProperties segmentProperties, List<CarbonColumn> minMaxCacheColumns, boolean storeBlockletCount, boolean filePathToBeStored) {
        ArrayList<CarbonRowSchema> taskMinMaxSchemas = new ArrayList<CarbonRowSchema>();
        taskMinMaxSchemas.add(new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.LONG));
        SchemaGenerator.getMinMaxSchema(segmentProperties, taskMinMaxSchemas, minMaxCacheColumns);
        taskMinMaxSchemas.add(new CarbonRowSchema.VariableCarbonRowSchema(DataTypes.BYTE_ARRAY));
        taskMinMaxSchemas.add(new CarbonRowSchema.VariableCarbonRowSchema(DataTypes.BYTE_ARRAY));
        SchemaGenerator.addMinMaxFlagSchema(segmentProperties, taskMinMaxSchemas, minMaxCacheColumns);
        if (filePathToBeStored) {
            taskMinMaxSchemas.add(new CarbonRowSchema.VariableCarbonRowSchema(DataTypes.BYTE_ARRAY));
        }
        if (storeBlockletCount) {
            taskMinMaxSchemas.add(new CarbonRowSchema.VariableCarbonRowSchema(DataTypes.BYTE_ARRAY));
        }
        CarbonRowSchema[] schema = taskMinMaxSchemas.toArray(new CarbonRowSchema[taskMinMaxSchemas.size()]);
        SchemaGenerator.updateBytePosition(schema);
        return schema;
    }

    private static void getMinMaxSchema(SegmentProperties segmentProperties, List<CarbonRowSchema> minMaxSchemas, List<CarbonColumn> minMaxCacheColumns) {
        int[] minMaxLen = SchemaGenerator.getMinMaxLength(segmentProperties, minMaxCacheColumns);
        int[] columnOrdinals = SchemaGenerator.getColumnOrdinalsToAccess(segmentProperties, minMaxCacheColumns);
        for (int k = 0; k < 2; ++k) {
            CarbonRowSchema[] mapSchemas = new CarbonRowSchema[minMaxLen.length];
            for (int i = 0; i < minMaxLen.length; ++i) {
                if (minMaxLen[i] <= 0) {
                    boolean isVarchar = false;
                    if (columnOrdinals[i] < segmentProperties.getDimensions().size() && segmentProperties.getDimensions().get(columnOrdinals[i]).getDataType() == DataTypes.VARCHAR) {
                        isVarchar = true;
                    }
                    mapSchemas[i] = new CarbonRowSchema.VariableCarbonRowSchema(DataTypes.BYTE_ARRAY, isVarchar);
                    continue;
                }
                mapSchemas[i] = new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.BYTE_ARRAY, minMaxLen[i]);
            }
            CarbonRowSchema.StructCarbonRowSchema mapSchema = new CarbonRowSchema.StructCarbonRowSchema(DataTypes.createDefaultStructType(), mapSchemas);
            minMaxSchemas.add(mapSchema);
        }
    }

    private static void addMinMaxFlagSchema(SegmentProperties segmentProperties, List<CarbonRowSchema> indexSchemas, List<CarbonColumn> minMaxCacheColumns) {
        int minMaxFlagLength = segmentProperties.getNumberOfColumns();
        if (null != minMaxCacheColumns) {
            minMaxFlagLength = minMaxCacheColumns.size();
        }
        CarbonRowSchema[] minMaxFlagSchemas = new CarbonRowSchema[minMaxFlagLength];
        for (int i = 0; i < minMaxFlagLength; ++i) {
            minMaxFlagSchemas[i] = new CarbonRowSchema.FixedCarbonRowSchema(DataTypes.BOOLEAN);
        }
        CarbonRowSchema.StructCarbonRowSchema structMinMaxFlagSchema = new CarbonRowSchema.StructCarbonRowSchema(DataTypes.createDefaultStructType(), minMaxFlagSchemas);
        indexSchemas.add(structMinMaxFlagSchema);
    }

    private static int[] getMinMaxLength(SegmentProperties segmentProperties, List<CarbonColumn> minMaxCacheColumns) {
        int[] minMaxLen = null;
        if (null != minMaxCacheColumns) {
            minMaxLen = new int[minMaxCacheColumns.size()];
            int counter = 0;
            for (CarbonColumn column : minMaxCacheColumns) {
                minMaxLen[counter++] = segmentProperties.createColumnValueLength()[BlockletIndexUtil.getColumnOrdinal(segmentProperties, column)];
            }
        } else {
            minMaxLen = segmentProperties.createColumnValueLength();
        }
        return minMaxLen;
    }

    private static int[] getColumnOrdinalsToAccess(SegmentProperties segmentProperties, List<CarbonColumn> minMaxCacheColumns) {
        int[] columnOrdinalsTOAccess = null;
        if (null != minMaxCacheColumns) {
            columnOrdinalsTOAccess = new int[minMaxCacheColumns.size()];
            int counter = 0;
            for (CarbonColumn column : minMaxCacheColumns) {
                columnOrdinalsTOAccess[counter++] = BlockletIndexUtil.getColumnOrdinal(segmentProperties, column);
            }
        } else {
            columnOrdinalsTOAccess = new int[segmentProperties.getNumberOfColumns()];
            for (int i = 0; i < columnOrdinalsTOAccess.length; ++i) {
                columnOrdinalsTOAccess[i] = i;
            }
        }
        return columnOrdinalsTOAccess;
    }
}

