/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.keygenerator.directdictionary;

import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.timestamp.DateDirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.timestamp.TimeStampDirectDictionaryGenerator;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.CarbonUtil;

public final class DirectDictionaryKeyGeneratorFactory {
    private DirectDictionaryKeyGeneratorFactory() {
    }

    public static DirectDictionaryGenerator getDirectDictionaryGenerator(DataType dataType, String dateFormat) {
        DirectDictionaryGenerator directDictionaryGenerator = null;
        if (dataType == DataTypes.DATE) {
            directDictionaryGenerator = new DateDirectDictionaryGenerator(dateFormat);
        } else if (dataType == DataTypes.TIMESTAMP) {
            directDictionaryGenerator = new TimeStampDirectDictionaryGenerator(dateFormat);
        }
        return directDictionaryGenerator;
    }

    public static DirectDictionaryGenerator getDirectDictionaryGenerator(DataType dataType) {
        return DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator(dataType, CarbonUtil.getFormatFromProperty(dataType));
    }
}

