/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.keygenerator.directdictionary.timestamp;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.log4j.Logger;

public class DateDirectDictionaryGenerator
implements DirectDictionaryGenerator {
    public static final int cutOffDate = 0x3FFFFFFF;
    private static final long SECONDS_PER_DAY = 86400L;
    public static final long MILLIS_PER_DAY = 86400000L;
    private ThreadLocal<SimpleDateFormat> simpleDateFormatLocal = new ThreadLocal();
    private String dateFormat;
    public static final long MIN_VALUE;
    public static final long MAX_VALUE;
    private static final Logger LOGGER;

    public DateDirectDictionaryGenerator(String dateFormat) {
        this.dateFormat = dateFormat;
        this.initialize();
    }

    @Override
    public int generateDirectSurrogateKey(String memberStr) {
        if (null == memberStr || memberStr.trim().isEmpty() || memberStr.equals("@NU#LL$!")) {
            return 1;
        }
        return this.getDirectSurrogateForMember(memberStr);
    }

    @Override
    public int generateDirectSurrogateKey(String memberStr, String format) {
        if (null == format) {
            return this.generateDirectSurrogateKeyForNonTimestampType(memberStr);
        }
        if (null == memberStr || memberStr.trim().isEmpty() || memberStr.equals("@NU#LL$!")) {
            return 1;
        }
        return this.getDirectSurrogateForMember(memberStr);
    }

    private int getDirectSurrogateForMember(String memberStr) {
        Date dateToStr = null;
        try {
            SimpleDateFormat simpleDateFormat = this.simpleDateFormatLocal.get();
            if (null == simpleDateFormat) {
                this.initialize();
                simpleDateFormat = this.simpleDateFormatLocal.get();
            }
            dateToStr = simpleDateFormat.parse(memberStr);
        }
        catch (ParseException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Cannot convert value to Time/Long type value. Value considered as null." + e.getMessage()));
            }
            dateToStr = null;
        }
        if (null == dateToStr) {
            return 1;
        }
        return this.generateKey(dateToStr.getTime());
    }

    @Override
    public Object getValueFromSurrogate(int key) {
        if (key == 1) {
            return null;
        }
        return key - 0x3FFFFFFF;
    }

    private int generateDirectSurrogateKeyForNonTimestampType(String memberStr) {
        long timeValue;
        block3: {
            timeValue = -1L;
            try {
                timeValue = Long.parseLong(memberStr) / 1000L;
            }
            catch (NumberFormatException e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug((Object)("Cannot convert value to Long type value. Value considered as null." + e.getMessage()), (Throwable)e);
            }
        }
        if (timeValue == -1L) {
            return 1;
        }
        return this.generateKey(timeValue);
    }

    @Override
    public int generateKey(long timeValue) {
        if (timeValue < MIN_VALUE || timeValue > MAX_VALUE) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Value for date type column is not in valid range. Value considered as null.");
            }
            return 1;
        }
        return (int)Math.floor((double)timeValue / 8.64E7) + 0x3FFFFFFF;
    }

    @Override
    public void initialize() {
        if (this.simpleDateFormatLocal.get() == null) {
            this.simpleDateFormatLocal.set(new SimpleDateFormat(this.dateFormat));
            this.simpleDateFormatLocal.get().setLenient(false);
            this.simpleDateFormatLocal.get().setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    @Override
    public DataType getReturnType() {
        return DataTypes.INT;
    }

    static {
        LOGGER = LogServiceFactory.getLogService((String)DateDirectDictionaryGenerator.class.getName());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        long minValue = 0L;
        long maxValue = 0L;
        try {
            minValue = df.parse("0001-01-01").getTime();
            maxValue = df.parse("9999-12-31").getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        MIN_VALUE = minValue;
        MAX_VALUE = maxValue;
    }
}

