/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.keygenerator.directdictionary.timestamp;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.timestamp.TimeStampGranularityTypeValue;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.log4j.Logger;

public class TimeStampDirectDictionaryGenerator
implements DirectDictionaryGenerator {
    private ThreadLocal<SimpleDateFormat> simpleDateFormatLocal = new ThreadLocal();
    private String dateFormat;
    public static final long granularityFactor;
    public static final long cutOffTimeStamp;
    private static final Logger LOGGER;

    public TimeStampDirectDictionaryGenerator(String dateFormat) {
        this.dateFormat = dateFormat;
        this.initialize();
    }

    public TimeStampDirectDictionaryGenerator() {
        this(CarbonProperties.getInstance().getProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss"));
    }

    @Override
    public int generateDirectSurrogateKey(String memberStr) {
        if (null == memberStr || memberStr.trim().isEmpty() || memberStr.equals("@NU#LL$!")) {
            return 1;
        }
        return this.getDirectSurrogateForMember(memberStr);
    }

    @Override
    public int generateDirectSurrogateKey(String memberStr, String format) {
        if (null == format) {
            return this.generateDirectSurrogateKeyForNonTimestampType(memberStr);
        }
        if (null == memberStr || memberStr.trim().isEmpty() || memberStr.equals("@NU#LL$!")) {
            return 1;
        }
        return this.getDirectSurrogateForMember(memberStr);
    }

    private int getDirectSurrogateForMember(String memberStr) {
        Date dateToStr = null;
        try {
            SimpleDateFormat simpleDateFormat = this.simpleDateFormatLocal.get();
            if (null == simpleDateFormat) {
                this.initialize();
                simpleDateFormat = this.simpleDateFormatLocal.get();
            }
            dateToStr = simpleDateFormat.parse(memberStr);
        }
        catch (ParseException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Cannot convert value to Time/Long type value. Value considered as null." + e.getMessage()));
            }
            dateToStr = null;
        }
        if (null == dateToStr) {
            return 1;
        }
        return this.generateKey(dateToStr.getTime());
    }

    @Override
    public Object getValueFromSurrogate(int key) {
        if (key == 1) {
            return null;
        }
        long timeStamp = (long)(key - 2) * granularityFactor + cutOffTimeStamp;
        return timeStamp * 1000L;
    }

    private int generateDirectSurrogateKeyForNonTimestampType(String memberStr) {
        long timeValue;
        block3: {
            timeValue = -1L;
            try {
                timeValue = Long.parseLong(memberStr) / 1000L;
            }
            catch (NumberFormatException e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug((Object)("Cannot convert " + memberStr + " Long type value. Value considered as null." + e.getMessage()));
            }
        }
        if (timeValue == -1L) {
            return 1;
        }
        return this.generateKey(timeValue);
    }

    @Override
    public int generateKey(long timeValue) {
        long time = (timeValue - cutOffTimeStamp) / granularityFactor;
        int keyValue = -1;
        if (time >= Integer.MIN_VALUE && time <= Integer.MAX_VALUE) {
            keyValue = (int)time;
        }
        return keyValue < 0 ? 1 : keyValue + 2;
    }

    @Override
    public void initialize() {
        if (this.simpleDateFormatLocal.get() == null) {
            this.simpleDateFormatLocal.set(new SimpleDateFormat(this.dateFormat));
            this.simpleDateFormatLocal.get().setLenient(false);
        }
    }

    @Override
    public DataType getReturnType() {
        return DataTypes.LONG;
    }

    static {
        long cutOffTimeStampLocal;
        LOGGER = LogServiceFactory.getLogService((String)TimeStampDirectDictionaryGenerator.class.getName());
        String cutOffTimeStampString = CarbonProperties.getInstance().getProperty("carbon.cutOffTimestamp");
        String timeGranularity = CarbonProperties.getInstance().getProperty("carbon.timegranularity", "SECOND");
        long granularityFactorLocal = 1000L;
        switch (timeGranularity) {
            case "SECOND": {
                granularityFactorLocal = TimeStampGranularityTypeValue.MILLIS_SECONDS.getValue();
                break;
            }
            case "MINUTE": {
                granularityFactorLocal = TimeStampGranularityTypeValue.MILLIS_MINUTE.getValue();
                break;
            }
            case "HOUR": {
                granularityFactorLocal = TimeStampGranularityTypeValue.MILLIS_HOUR.getValue();
                break;
            }
            case "DAY": {
                granularityFactorLocal = TimeStampGranularityTypeValue.MILLIS_DAY.getValue();
                break;
            }
            default: {
                granularityFactorLocal = 1000L;
            }
        }
        if (null == cutOffTimeStampString) {
            cutOffTimeStampLocal = 0L;
        } else {
            try {
                SimpleDateFormat timeParser = new SimpleDateFormat(CarbonProperties.getInstance().getProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss"));
                timeParser.setLenient(false);
                Date dateToStr = timeParser.parse(cutOffTimeStampString);
                cutOffTimeStampLocal = dateToStr.getTime();
            }
            catch (ParseException e) {
                LOGGER.warn((Object)("Cannot convert" + cutOffTimeStampString + " to Time/Long type value. Value considered for cutOffTimeStamp is -1." + e.getMessage()));
                cutOffTimeStampLocal = 0L;
            }
        }
        granularityFactor = granularityFactorLocal;
        cutOffTimeStamp = cutOffTimeStampLocal;
    }
}

