/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.keygenerator.mdkey;

import java.io.Serializable;
import java.util.Arrays;

public class Bits
implements Serializable {
    private static final int MAX_LENGTH = 63;
    private static final int LONG_LENGTH = 64;
    private static final long serialVersionUID = 1555114921503304849L;
    private static final long LONG_MAX = Long.MAX_VALUE;
    private int length = 100;
    private int[] lens;
    private int wsize;
    private int byteSize;

    public Bits(int[] lens) {
        this.lens = lens;
        this.length = this.getTotalLength(lens);
        this.wsize = this.length / 64;
        this.byteSize = this.length / 8;
        if (this.length % 64 != 0) {
            ++this.wsize;
        }
        if (this.length % 8 != 0) {
            ++this.byteSize;
        }
    }

    public int getByteSize() {
        return this.byteSize;
    }

    private int getTotalLength(int[] lens) {
        int tLen = 0;
        for (int len : lens) {
            tLen += len;
        }
        return tLen;
    }

    public int getDimCount() {
        return this.lens.length;
    }

    public int[] getKeyByteOffsets(int index) {
        int priorLen = this.length % 8 == 0 ? 0 : 8 - this.length % 8;
        int start = 0;
        int end = 0;
        for (int i = 0; i < index; ++i) {
            priorLen += this.lens[i];
        }
        start = priorLen / 8;
        int tillKeyLength = priorLen + this.lens[index];
        end = tillKeyLength / 8;
        if (tillKeyLength % 8 == 0) {
            // empty if block
        }
        return new int[]{start, --end};
    }

    protected long[] get(long[] keys) {
        long[] words = new long[this.wsize];
        int ll = 0;
        int minLength = Math.min(this.lens.length, keys.length);
        for (int i = minLength - 1; i >= 0; --i) {
            int consideredBits;
            long val = keys[i];
            int idx = ll >> 6;
            int position = ll & 0x3F;
            long mask = (val &= Long.MAX_VALUE >> 63 - this.lens[i]) << position;
            long word = words[idx];
            words[idx] = word | mask;
            int nextIndex = (ll += this.lens[i]) >> 6;
            if (nextIndex == idx || (consideredBits = this.lens[i] - ll & 0x3F) >= this.lens[i]) continue;
            mask = val >> (this.lens[i] - ll & 0x3F);
            word = words[nextIndex];
            words[nextIndex] = word | mask;
        }
        return words;
    }

    protected long[] get(int[] keys) {
        long[] words = new long[this.wsize];
        int ll = 0;
        int minLength = Math.min(this.lens.length, keys.length);
        for (int i = minLength - 1; i >= 0; --i) {
            int consideredBits;
            long val = keys[i];
            int index = ll >> 6;
            int pos = ll & 0x3F;
            long mask = (val &= Long.MAX_VALUE >> 63 - this.lens[i]) << pos;
            long word = words[index];
            words[index] = word | mask;
            int nextIndex = (ll += this.lens[i]) >> 6;
            if (nextIndex == index || (consideredBits = this.lens[i] - ll & 0x3F) >= this.lens[i]) continue;
            mask = val >> (this.lens[i] - ll & 0x3F);
            word = words[nextIndex];
            words[nextIndex] = word | mask;
        }
        return words;
    }

    private long[] getArray(long[] words) {
        long[] vals = new long[this.lens.length];
        int ll = 0;
        for (int i = this.lens.length - 1; i >= 0; --i) {
            int index = ll >> 6;
            int pos = ll & 0x3F;
            long val = words[index];
            long mask = Long.MAX_VALUE >>> 63 - this.lens[i];
            vals[i] = val & (mask <<= pos);
            int n = i;
            vals[n] = vals[n] >>> pos;
            int nextIndex = (ll += this.lens[i]) >> 6;
            if (nextIndex == index || (pos = ll & 0x3F) == 0) continue;
            mask = Long.MAX_VALUE >>> 63 - pos;
            val = words[nextIndex];
            vals[i] = vals[i] | (val & mask) << this.lens[i] - pos;
        }
        return vals;
    }

    public byte[] getBytes(long[] keys) {
        long[] words = this.get(keys);
        return this.getBytesVal(words);
    }

    private byte[] getBytesVal(long[] words) {
        int length = 8;
        byte[] bytes = new byte[this.byteSize];
        int l = this.byteSize - 1;
        for (int i = 0; i < words.length; ++i) {
            long val = words[i];
            for (int j = length - 1; j > 0 && l > 0; --l, --j) {
                bytes[l] = (byte)val;
                val >>>= 8;
            }
            bytes[l] = (byte)val;
            --l;
        }
        return bytes;
    }

    public byte[] getBytes(int[] keys) {
        long[] words = this.get(keys);
        return this.getBytesVal(words);
    }

    public long[] getKeyArray(byte[] key, int offset) {
        int length = 8;
        int ls = this.byteSize;
        long[] words = new long[this.wsize];
        for (int i = 0; i < words.length; ++i) {
            long l = 0L;
            int m = 0;
            if ((ls -= 8) < 0) {
                m = ls + length;
                ls = 0;
            } else {
                m = ls + 8;
            }
            for (int j = ls; j < m; ++j) {
                l <<= 8;
                l ^= (long)(key[j + offset] & 0xFF);
            }
            words[i] = l;
        }
        return this.getArray(words);
    }

    public long[] getKeyArray(byte[] key, int[] maskByteRanges) {
        int length = 8;
        int ls = this.byteSize;
        long[] words = new long[this.wsize];
        for (int i = 0; i < words.length; ++i) {
            int j;
            long l = 0L;
            int m2 = 0;
            if ((ls -= 8) < 0) {
                m2 = ls + length;
                ls = 0;
            } else {
                m2 = ls + 8;
            }
            if (maskByteRanges == null) {
                for (j = ls; j < m2; ++j) {
                    l <<= 8;
                    l ^= (long)(key[j] & 0xFF);
                }
            } else {
                for (j = ls; j < m2; ++j) {
                    l <<= 8;
                    if (maskByteRanges[j] == -1) continue;
                    l ^= (long)(key[maskByteRanges[j]] & 0xFF);
                }
            }
            words[i] = l;
        }
        return this.getArray(words);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bits) {
            Bits other = (Bits)obj;
            return Arrays.equals(this.lens, other.lens);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.lens);
    }
}

