/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.keygenerator.mdkey;

import org.apache.carbondata.core.keygenerator.mdkey.AbstractKeyGenerator;
import org.apache.carbondata.core.keygenerator.mdkey.Bits;

public class MultiDimKeyVarLengthGenerator
extends AbstractKeyGenerator {
    private static final long serialVersionUID = 9134778127271586515L;
    protected int[][] byteRangesForKeys;
    private Bits bits;

    public MultiDimKeyVarLengthGenerator(int[] lens) {
        this.bits = new Bits(lens);
        this.byteRangesForKeys = new int[lens.length][];
        int keys = lens.length;
        for (int i = 0; i < keys; ++i) {
            this.byteRangesForKeys[i] = this.bits.getKeyByteOffsets(i);
        }
    }

    @Override
    public byte[] generateKey(int[] keys) {
        return this.bits.getBytes(keys);
    }

    @Override
    public long[] getKeyArray(byte[] key, int offset) {
        return this.bits.getKeyArray(key, offset);
    }

    @Override
    public int getDimCount() {
        return this.bits.getDimCount();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MultiDimKeyVarLengthGenerator) {
            MultiDimKeyVarLengthGenerator other = (MultiDimKeyVarLengthGenerator)obj;
            return this.bits.equals(other.bits);
        }
        return false;
    }

    public int hashCode() {
        return this.bits.hashCode();
    }
}

