/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.localdictionary;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.carbondata.core.datastore.ColumnType;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.datastore.page.encoding.compress.DirectCompressCodec;
import org.apache.carbondata.core.datastore.page.statistics.DummyStatsCollector;
import org.apache.carbondata.core.localdictionary.exception.DictionaryThresholdReachedException;
import org.apache.carbondata.core.localdictionary.generator.LocalDictionaryGenerator;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.format.LocalDictionaryChunk;

public class PageLevelDictionary {
    private LocalDictionaryGenerator localDictionaryGenerator;
    private BitSet usedDictionaryValues;
    private String columnName;
    private DataType dataType;
    private boolean isComplexTypePrimitive;
    private String columnCompressor;

    public PageLevelDictionary(LocalDictionaryGenerator localDictionaryGenerator, String columnName, DataType dataType, boolean isComplexTypePrimitive, String columnCompressor) {
        this.localDictionaryGenerator = localDictionaryGenerator;
        this.usedDictionaryValues = new BitSet();
        this.columnName = columnName;
        this.dataType = dataType;
        this.isComplexTypePrimitive = isComplexTypePrimitive;
        this.columnCompressor = columnCompressor;
    }

    public int getDictionaryValue(byte[] data) throws DictionaryThresholdReachedException {
        int dictionaryValue = this.localDictionaryGenerator.generateDictionary(data);
        this.usedDictionaryValues.set(dictionaryValue);
        return dictionaryValue;
    }

    public void mergerDictionaryValues(PageLevelDictionary pageLevelDictionary) {
        this.usedDictionaryValues.or(pageLevelDictionary.usedDictionaryValues);
    }

    public LocalDictionaryChunk getLocalDictionaryChunkForBlocklet() throws IOException {
        ColumnType columnType = ColumnType.PLAIN_VALUE;
        boolean isVarcharType = false;
        int lvSize = 2;
        if (DataTypes.VARCHAR == this.dataType) {
            columnType = ColumnType.PLAIN_LONG_VALUE;
            lvSize = 4;
            isVarcharType = true;
        }
        TableSpec.ColumnSpec spec = TableSpec.ColumnSpec.newInstance(this.columnName, DataTypes.BYTE_ARRAY, columnType);
        ColumnPage dictionaryColumnPage = ColumnPage.newPage(new ColumnPageEncoderMeta(spec, DataTypes.BYTE_ARRAY, this.columnCompressor), this.usedDictionaryValues.cardinality());
        dictionaryColumnPage.setStatsCollector(new DummyStatsCollector());
        int rowId = 0;
        ByteBuffer byteBuffer = null;
        int i = this.usedDictionaryValues.nextSetBit(0);
        while (i >= 0) {
            if (!this.isComplexTypePrimitive) {
                dictionaryColumnPage.putData(rowId++, this.localDictionaryGenerator.getDictionaryKeyBasedOnValue(i));
            } else {
                byte[] dictionaryKeyBasedOnValue = this.localDictionaryGenerator.getDictionaryKeyBasedOnValue(i);
                byteBuffer = ByteBuffer.allocate(lvSize + dictionaryKeyBasedOnValue.length);
                if (!isVarcharType) {
                    byteBuffer.putShort((short)dictionaryKeyBasedOnValue.length);
                } else {
                    byteBuffer.putInt(dictionaryKeyBasedOnValue.length);
                }
                byteBuffer.put(dictionaryKeyBasedOnValue);
                dictionaryColumnPage.putData(rowId++, byteBuffer.array());
            }
            i = this.usedDictionaryValues.nextSetBit(i + 1);
        }
        ColumnPageEncoder encoder = new DirectCompressCodec(DataTypes.BYTE_ARRAY).createEncoder(null);
        LocalDictionaryChunk localDictionaryChunk = encoder.encodeDictionary(dictionaryColumnPage);
        localDictionaryChunk.setDictionary_values(CompressorFactory.getInstance().getCompressor(this.columnCompressor).compressByte(this.usedDictionaryValues.toByteArray()));
        dictionaryColumnPage.freeMemory();
        return localDictionaryChunk;
    }
}

