/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.localdictionary.dictionaryholder;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.core.cache.dictionary.DictionaryByteArrayWrapper;
import org.apache.carbondata.core.localdictionary.dictionaryholder.DictionaryStore;
import org.apache.carbondata.core.localdictionary.exception.DictionaryThresholdReachedException;
import org.apache.carbondata.core.util.CarbonProperties;

public class MapBasedDictionaryStore
implements DictionaryStore {
    private int lastAssignValue;
    private final Map<DictionaryByteArrayWrapper, Integer> dictionary;
    private DictionaryByteArrayWrapper[] referenceDictionaryArray;
    private int dictionaryThreshold;
    private long dictionarySizeThresholdInBytes;
    private boolean isThresholdReached;
    private long currentSize;

    public MapBasedDictionaryStore(int dictionaryThreshold) {
        this.dictionaryThreshold = dictionaryThreshold;
        this.dictionarySizeThresholdInBytes = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.local.dictionary.size.threshold.inmb")) << 20;
        this.dictionary = new ConcurrentHashMap<DictionaryByteArrayWrapper, Integer>();
        this.referenceDictionaryArray = new DictionaryByteArrayWrapper[dictionaryThreshold];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putIfAbsent(byte[] data) throws DictionaryThresholdReachedException {
        this.checkIfThresholdReached();
        DictionaryByteArrayWrapper key = new DictionaryByteArrayWrapper(data);
        Integer value = this.dictionary.get(key);
        if (null == value) {
            Map<DictionaryByteArrayWrapper, Integer> map = this.dictionary;
            synchronized (map) {
                this.checkIfThresholdReached();
                value = this.dictionary.get(key);
                if (null == value) {
                    value = ++this.lastAssignValue;
                    this.currentSize += (long)data.length;
                    if (value > this.dictionaryThreshold || this.currentSize > this.dictionarySizeThresholdInBytes) {
                        this.isThresholdReached = true;
                        this.checkIfThresholdReached();
                    }
                    this.referenceDictionaryArray[value.intValue() - 1] = key;
                    this.dictionary.put(key, value);
                }
            }
        }
        return value;
    }

    private void checkIfThresholdReached() throws DictionaryThresholdReachedException {
        if (this.isThresholdReached) {
            if (this.currentSize > this.dictionarySizeThresholdInBytes) {
                throw new DictionaryThresholdReachedException("Unable to generate dictionary. Dictionary Size crossed bytes: " + this.dictionarySizeThresholdInBytes);
            }
            throw new DictionaryThresholdReachedException("Unable to generate dictionary value. Dictionary threshold reached");
        }
    }

    @Override
    public boolean isThresholdReached() {
        return this.isThresholdReached;
    }

    @Override
    public byte[] getDictionaryKeyBasedOnValue(int value) {
        assert (this.referenceDictionaryArray != null);
        return this.referenceDictionaryArray[value - 1].getData();
    }
}

