/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.localdictionary.generator;

import java.nio.ByteBuffer;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.localdictionary.dictionaryholder.DictionaryStore;
import org.apache.carbondata.core.localdictionary.dictionaryholder.MapBasedDictionaryStore;
import org.apache.carbondata.core.localdictionary.exception.DictionaryThresholdReachedException;
import org.apache.carbondata.core.localdictionary.generator.LocalDictionaryGenerator;

public class ColumnLocalDictionaryGenerator
implements LocalDictionaryGenerator {
    private DictionaryStore dictionaryHolder;

    public ColumnLocalDictionaryGenerator(int threshold, int lvLength) {
        int newThreshold = threshold + 1;
        this.dictionaryHolder = new MapBasedDictionaryStore(newThreshold);
        ByteBuffer byteBuffer = ByteBuffer.allocate(lvLength + CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY.length);
        if (lvLength == 2) {
            byteBuffer.putShort((short)CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY.length);
        } else {
            byteBuffer.putInt(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY.length);
        }
        byteBuffer.put(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY);
        try {
            this.dictionaryHolder.putIfAbsent(byteBuffer.array());
        }
        catch (DictionaryThresholdReachedException dictionaryThresholdReachedException) {
            // empty catch block
        }
    }

    @Override
    public int generateDictionary(byte[] data) throws DictionaryThresholdReachedException {
        return this.dictionaryHolder.putIfAbsent(data);
    }

    @Override
    public boolean isThresholdReached() {
        return this.dictionaryHolder.isThresholdReached();
    }

    @Override
    public byte[] getDictionaryKeyBasedOnValue(int value) {
        return this.dictionaryHolder.getDictionaryKeyBasedOnValue(value);
    }
}

