/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.locks;

import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.util.CarbonProperties;

public abstract class AbstractCarbonLock
implements ICarbonLock {
    private int retryCount;
    private int retryTimeout;
    protected String lockFilePath;

    public abstract boolean lock();

    @Override
    public String getLockFilePath() {
        return this.lockFilePath;
    }

    @Override
    public boolean lockWithRetries() {
        try {
            for (int i = 0; i < this.retryCount; ++i) {
                if (this.lock()) {
                    return true;
                }
                Thread.sleep((long)this.retryTimeout * 1000L);
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean lockWithRetries(int retries, int retryInterval) {
        this.retryCount = retries;
        this.retryTimeout = retryInterval;
        return this.lockWithRetries();
    }

    protected void initRetry() {
        String retries = CarbonProperties.getInstance().getProperty("carbon.lock.retries");
        try {
            this.retryCount = Integer.parseInt(retries);
        }
        catch (NumberFormatException e) {
            this.retryCount = 3;
        }
        String maxTimeout = CarbonProperties.getInstance().getProperty("carbon.lock.retry.timeout.sec");
        try {
            this.retryTimeout = Integer.parseInt(maxTimeout);
        }
        catch (NumberFormatException e) {
            this.retryTimeout = 5;
        }
    }

    @Override
    public boolean releaseLockManually(String lockFile) {
        try {
            return FileFactory.deleteFile(lockFile);
        }
        catch (Exception e) {
            return false;
        }
    }
}

