/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.locks;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.locks.AlluxioFileLock;
import org.apache.carbondata.core.locks.HdfsFileLock;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.locks.LocalFileLock;
import org.apache.carbondata.core.locks.S3FileLock;
import org.apache.carbondata.core.locks.ZooKeeperLocking;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.log4j.Logger;

public class CarbonLockFactory {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonLockFactory.class.getName());
    private static String lockTypeConfigured;
    private static String lockPath;
    private static Constructor lockConstructor;

    public static ICarbonLock getCarbonLockObj(AbsoluteTableIdentifier absoluteTableIdentifier, String lockFile) {
        String absoluteLockPath = lockPath.isEmpty() ? absoluteTableIdentifier.getTablePath() : CarbonLockFactory.getLockpath(absoluteTableIdentifier.getCarbonTableIdentifier().getTableId());
        FileFactory.FileType fileType = FileFactory.getFileType(absoluteLockPath);
        if (lockTypeConfigured.equals("CUSTOM")) {
            return CarbonLockFactory.newCustomLock(absoluteLockPath, lockFile);
        }
        if (lockTypeConfigured.equals("ZOOKEEPERLOCK")) {
            return new ZooKeeperLocking(absoluteLockPath, lockFile);
        }
        if (fileType == FileFactory.FileType.S3) {
            lockTypeConfigured = "S3LOCK";
            return new S3FileLock(absoluteLockPath, lockFile);
        }
        if (fileType == FileFactory.FileType.HDFS || fileType == FileFactory.FileType.VIEWFS) {
            lockTypeConfigured = "HDFSLOCK";
            return new HdfsFileLock(absoluteLockPath, lockFile);
        }
        if (fileType == FileFactory.FileType.ALLUXIO) {
            lockTypeConfigured = "ALLUXIOLOCK";
            return new AlluxioFileLock(absoluteLockPath, lockFile);
        }
        lockTypeConfigured = "LOCALLOCK";
        return new LocalFileLock(absoluteLockPath, lockFile);
    }

    public static ICarbonLock getSystemLevelCarbonLockObj(String locFileLocation, String lockFile) {
        String lockFileLocation = lockPath.isEmpty() ? locFileLocation : CarbonLockFactory.getLockpath("1");
        switch (lockTypeConfigured) {
            case "CUSTOM": {
                return CarbonLockFactory.newCustomLock(lockFileLocation, lockFile);
            }
            case "LOCALLOCK": {
                return new LocalFileLock(lockFileLocation, lockFile);
            }
            case "ZOOKEEPERLOCK": {
                return new ZooKeeperLocking(lockFileLocation, lockFile);
            }
            case "HDFSLOCK": {
                return new HdfsFileLock(lockFileLocation, lockFile);
            }
            case "S3LOCK": {
                return new S3FileLock(lockFileLocation, lockFile);
            }
            case "ALLUXIOLOCK": {
                return new AlluxioFileLock(lockFileLocation, lockFile);
            }
        }
        throw new UnsupportedOperationException("Not supported the lock type");
    }

    private static void getLockTypeConfigured() {
        lockTypeConfigured = CarbonProperties.getInstance().getProperty("carbon.lock.type", "LOCALLOCK").toUpperCase();
        LOGGER.info((Object)("Configured lock type is: " + lockTypeConfigured));
        String lockClassName = CarbonProperties.getInstance().getProperty("carbon.lock.class");
        if (lockClassName == null) {
            return;
        }
        lockConstructor = CarbonLockFactory.getCustomLockConstructor(lockClassName);
    }

    public static String getLockpath(String tableId) {
        return lockPath + "/" + tableId;
    }

    private static ICarbonLock newCustomLock(String lockFileLocation, String lockFile) {
        if (lockConstructor == null) {
            throw new IllegalArgumentException("Carbon property [carbon.lock.class] is not set.");
        }
        try {
            return (ICarbonLock)lockConstructor.newInstance(lockFileLocation, lockFile);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Constructor<?> getCustomLockConstructor(String lockClassName) {
        Constructor<?> lockConstructor;
        Class<?> lockClass;
        try {
            lockClass = CarbonLockFactory.class.getClassLoader().loadClass(lockClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("The class [" + lockClassName + "] is not found.");
        }
        if (!ICarbonLock.class.isAssignableFrom(lockClass)) {
            throw new IllegalArgumentException("The class [" + lockClassName + "] is not an ICarbonLock class.");
        }
        if (Modifier.isAbstract(lockClass.getModifiers())) {
            throw new IllegalArgumentException("The class [" + lockClassName + "] can not be initialized.");
        }
        if (!Modifier.isPublic(lockClass.getModifiers())) {
            throw new IllegalArgumentException("The class [" + lockClassName + "] is not a public class.");
        }
        try {
            lockConstructor = lockClass.getConstructor(String.class, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The class [" + lockClassName + "] do not have the constructor(String, String).", e);
        }
        if (!Modifier.isPublic(lockClass.getModifiers())) {
            throw new IllegalArgumentException("The constructor [" + lockConstructor + "] is not a public constructor.");
        }
        return lockConstructor;
    }

    static {
        lockPath = CarbonProperties.getInstance().getProperty("carbon.lock.path", "").toLowerCase();
        CarbonLockFactory.getLockTypeConfigured();
    }
}

