/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.locks;

import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.locks.CarbonLockFactory;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CarbonLockUtil {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonLockUtil.class.getName());

    public static void fileUnlock(ICarbonLock carbonLock, String locktype) {
        if (carbonLock.unlock()) {
            if (locktype.equals("meta.lock")) {
                LOGGER.info((Object)"Metadata lock has been successfully released");
            } else if (locktype.equals("tablestatus.lock")) {
                LOGGER.info((Object)"Table status lock has been successfully released");
            } else if (locktype.equals("clean_files.lock")) {
                LOGGER.info((Object)"Clean files lock has been successfully released");
            } else if (locktype.equals("delete_segment.lock")) {
                LOGGER.info((Object)"Delete segments lock has been successfully released");
            } else if (locktype.equals("indexstatus.lock")) {
                LOGGER.info((Object)"Index status lock has been successfully released");
            }
        } else if (locktype.equals("meta.lock")) {
            LOGGER.error((Object)"Not able to release the metadata lock");
        } else if (locktype.equals("tablestatus.lock")) {
            LOGGER.error((Object)"Not able to release the table status lock");
        } else if (locktype.equals("clean_files.lock")) {
            LOGGER.info((Object)"Not able to release the clean files lock");
        } else if (locktype.equals("delete_segment.lock")) {
            LOGGER.info((Object)"Not able to release the delete segments lock");
        } else if (locktype.equals("indexstatus.lock")) {
            LOGGER.info((Object)"Not able to release the index status lock");
        }
    }

    public static ICarbonLock getLockObject(AbsoluteTableIdentifier absoluteTableIdentifier, String lockType, String errorMsg) {
        ICarbonLock carbonLock = CarbonLockFactory.getCarbonLockObj(absoluteTableIdentifier, lockType);
        LOGGER.info((Object)("Trying to acquire lock: " + lockType + "for table: " + absoluteTableIdentifier.toString()));
        if (!carbonLock.lockWithRetries()) {
            LOGGER.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        LOGGER.info((Object)("Successfully acquired the lock " + lockType + "for table: " + absoluteTableIdentifier.toString()));
        return carbonLock;
    }

    public static ICarbonLock getLockObject(AbsoluteTableIdentifier identifier, String lockType) {
        return CarbonLockUtil.getLockObject(identifier, lockType, "Acquire table lock failed after retry, please try after some time");
    }

    public static int getLockProperty(String property, int defaultValue) {
        try {
            return Integer.parseInt(CarbonProperties.getInstance().getProperty(property));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static void deleteExpiredSegmentLockFiles(CarbonTable carbonTable) {
        CarbonFile[] files;
        final long currTime = System.currentTimeMillis();
        final long segmentLockFilesPreserveTime = CarbonProperties.getInstance().getSegmentLockFilesPreserveHours();
        AbsoluteTableIdentifier absoluteTableIdentifier = carbonTable.getAbsoluteTableIdentifier();
        String lockFilesDir = CarbonProperties.getInstance().getProperty("carbon.lock.path", "");
        lockFilesDir = StringUtils.isEmpty((String)lockFilesDir) ? CarbonTablePath.getLockFilesDirPath(absoluteTableIdentifier.getTablePath()) : CarbonTablePath.getLockFilesDirPath(CarbonLockFactory.getLockpath(carbonTable.getTableInfo().getFactTable().getTableId()));
        for (CarbonFile file : files = FileFactory.getCarbonFile(lockFilesDir).listFiles(new CarbonFileFilter(){

            @Override
            public boolean accept(CarbonFile pathName) {
                if (CarbonTablePath.isSegmentLockFilePath(pathName.getName())) {
                    return currTime - pathName.getLastModifiedTime() > segmentLockFilesPreserveTime;
                }
                return false;
            }
        })) {
            file.delete();
        }
    }
}

