/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.locks;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.locks.AbstractCarbonLock;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.log4j.Logger;

public class LocalFileLock
extends AbstractCarbonLock {
    private String lockFileDir;
    private FileChannel channel;
    private FileLock fileLock;
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)LocalFileLock.class.getName());

    public LocalFileLock(String lockFileLocation, String lockFile) {
        this.lockFileDir = CarbonTablePath.getLockFilesDirPath(lockFileLocation);
        this.lockFilePath = CarbonTablePath.getLockFilePath(lockFileLocation, lockFile);
        this.initRetry();
    }

    @Override
    public boolean lock() {
        try {
            if (!FileFactory.isFileExist(this.lockFileDir)) {
                FileFactory.mkdirs(this.lockFileDir);
            }
            if (!FileFactory.isFileExist(this.lockFilePath)) {
                FileFactory.createNewLockFile(this.lockFilePath);
            }
            this.channel = FileChannel.open(Paths.get(this.lockFilePath, new String[0]), StandardOpenOption.WRITE, StandardOpenOption.APPEND);
            try {
                this.fileLock = this.channel.tryLock();
            }
            catch (OverlappingFileLockException e) {
                return false;
            }
            return null != this.fileLock;
        }
        catch (IOException e) {
            LOGGER.info((Object)e.getMessage());
            return false;
        }
    }

    @Override
    public boolean unlock() {
        boolean status;
        block4: {
            status = false;
            try {
                if (null == this.fileLock) break block4;
                this.fileLock.release();
                status = true;
            }
            catch (IOException e) {
                try {
                    status = false;
                }
                catch (Throwable throwable) {
                    CarbonUtil.closeStreams(this.channel);
                    throw throwable;
                }
                CarbonUtil.closeStreams(this.channel);
            }
        }
        CarbonUtil.closeStreams(this.channel);
        return status;
    }
}

