/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.locks;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.locks.AbstractCarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.log4j.Logger;

public class S3FileLock
extends AbstractCarbonLock {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)S3FileLock.class.getName());
    private String lockFileDir;
    private DataOutputStream dataOutputStream;

    public S3FileLock(AbsoluteTableIdentifier tableIdentifier, String lockFile) {
        this(tableIdentifier.getTablePath(), lockFile);
    }

    public S3FileLock(String lockFileLocation, String lockFile) {
        this.lockFileDir = CarbonTablePath.getLockFilesDirPath(lockFileLocation);
        this.lockFilePath = CarbonTablePath.getLockFilePath(lockFileLocation, lockFile);
        LOGGER.info((Object)("S3 lock path:" + this.lockFilePath));
        this.initRetry();
    }

    @Override
    public boolean unlock() {
        boolean status = false;
        if (null != this.dataOutputStream) {
            try {
                this.dataOutputStream.close();
                status = true;
            }
            catch (IOException e) {
                status = false;
            }
        }
        return status;
    }

    @Override
    public boolean lock() {
        try {
            if (!FileFactory.isFileExist(this.lockFileDir)) {
                FileFactory.mkdirs(this.lockFileDir);
            }
            if (!FileFactory.isFileExist(this.lockFilePath)) {
                FileFactory.createNewLockFile(this.lockFilePath);
            }
            this.dataOutputStream = FileFactory.getDataOutputStreamUsingAppend(this.lockFilePath);
            return true;
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

