/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.locks;

import java.util.Collections;
import java.util.List;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.locks.AbstractCarbonLock;
import org.apache.carbondata.core.locks.ZookeeperInit;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class ZooKeeperLocking
extends AbstractCarbonLock {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)ZooKeeperLocking.class.getName());
    private static ZooKeeper zk;
    private static final String zooKeeperLocation = "/CarbonLocks";
    private final String tableIdFolder;
    private String lockName;
    private String lockPath;
    private String lockTypeFolder;

    public ZooKeeperLocking(AbsoluteTableIdentifier absoluteTableIdentifier, String lockFile) {
        this(absoluteTableIdentifier.getCarbonTableIdentifier().getDatabaseName() + "/" + absoluteTableIdentifier.getCarbonTableIdentifier().getTableName(), lockFile);
    }

    public static void initialize() {
        String zooKeeperUrl = CarbonProperties.getInstance().getProperty("spark.deploy.zookeeper.url");
        if (null == zk) {
            zk = ZookeeperInit.getInstance(zooKeeperUrl).getZookeeper();
        }
    }

    public ZooKeeperLocking(String lockLocation, String lockFile) {
        this.lockName = lockFile;
        this.tableIdFolder = "/CarbonLocks/" + CarbonTablePath.getLockFilesDirPath(lockLocation);
        ZooKeeperLocking.initialize();
        this.lockTypeFolder = this.tableIdFolder + "/" + lockFile;
        try {
            this.createBaseNode();
            if (null == zk.exists(this.tableIdFolder, true)) {
                this.createRecursivly(this.tableIdFolder);
            }
            if (null == zk.exists(this.lockTypeFolder, true)) {
                zk.create(this.lockTypeFolder, new byte[1], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (InterruptedException | KeeperException e) {
            LOGGER.error((Object)e.getMessage(), e);
        }
        this.initRetry();
    }

    private void createBaseNode() throws KeeperException, InterruptedException {
        if (null == zk.exists(zooKeeperLocation, true)) {
            zk.create(zooKeeperLocation, new byte[1], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    private void createRecursivly(String path) throws KeeperException, InterruptedException {
        if (zk.exists(path, true) == null && path.length() > 0) {
            String temp = path.substring(0, path.lastIndexOf("/"));
            this.createRecursivly(temp);
            zk.create(path, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    @Override
    public boolean lock() {
        try {
            this.lockPath = zk.create(this.lockTypeFolder + "/" + this.lockName, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            List nodes = zk.getChildren(this.lockTypeFolder, null);
            Collections.sort(nodes);
            if (this.lockPath.endsWith((String)nodes.get(0))) {
                return true;
            }
            zk.delete(this.lockPath, -1);
            return false;
        }
        catch (InterruptedException | KeeperException e) {
            LOGGER.error((Object)e.getMessage(), e);
            return false;
        }
    }

    @Override
    public boolean unlock() {
        try {
            if (this.lockPath != null && null != zk.exists(this.lockPath, true)) {
                zk.delete(this.lockPath, -1);
                this.lockPath = null;
            }
        }
        catch (InterruptedException | KeeperException e) {
            LOGGER.error((Object)e.getMessage(), e);
            return false;
        }
        return true;
    }
}

