/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.locks;

import java.io.IOException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.log4j.Logger;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ZookeeperInit {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)ZookeeperInit.class.getName());
    private static ZookeeperInit zooKeeperInit;
    private ZooKeeper zk;

    private ZookeeperInit(String zooKeeperUrl) {
        int sessionTimeOut = 100000;
        try {
            this.zk = new ZooKeeper(zooKeeperUrl, sessionTimeOut, (Watcher)new DummyWatcher());
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZookeeperInit getInstance(String zooKeeperUrl) {
        Class<ZookeeperInit> clazz = ZookeeperInit.class;
        synchronized (ZookeeperInit.class) {
            if (null == zooKeeperInit) {
                LOGGER.info((Object)"Initiating Zookeeper client.");
                zooKeeperInit = new ZookeeperInit(zooKeeperUrl);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zooKeeperInit;
        }
    }

    public ZooKeeper getZookeeper() {
        return this.zk;
    }

    private static class DummyWatcher
    implements Watcher {
        private DummyWatcher() {
        }

        public void process(WatchedEvent event) {
        }
    }
}

