/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.memory;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.memory.MemoryAllocator;
import org.apache.carbondata.core.memory.MemoryBlock;
import org.apache.carbondata.core.memory.MemoryType;
import org.apache.carbondata.core.util.CarbonProperties;

public class HeapMemoryAllocator
implements MemoryAllocator {
    @GuardedBy(value="this")
    private final Map<Long, LinkedList<WeakReference<long[]>>> bufferPoolsBySize = new HashMap<Long, LinkedList<WeakReference<long[]>>>();
    private int poolingThresholdBytes = CarbonProperties.getInstance().getHeapMemoryPoolingThresholdBytes();
    private boolean shouldPooling = true;

    public HeapMemoryAllocator() {
        boolean isDriver = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("is.driver.instance", "false"));
        if (this.poolingThresholdBytes == -1 || isDriver) {
            this.shouldPooling = false;
        }
    }

    private boolean shouldPool(long size) {
        return this.shouldPooling && size >= (long)this.poolingThresholdBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryBlock allocate(long size) throws OutOfMemoryError {
        int numWords = (int)((size + 7L) / 8L);
        long alignedSize = (long)numWords * 8L;
        assert (alignedSize >= size);
        if (this.shouldPool(alignedSize)) {
            HeapMemoryAllocator heapMemoryAllocator = this;
            synchronized (heapMemoryAllocator) {
                LinkedList<WeakReference<long[]>> pool = this.bufferPoolsBySize.get(alignedSize);
                if (pool != null) {
                    while (!pool.isEmpty()) {
                        WeakReference<long[]> arrayReference = pool.pop();
                        long[] array = (long[])arrayReference.get();
                        if (array == null) continue;
                        assert ((long)array.length * 8L >= size);
                        MemoryBlock memory = new MemoryBlock(array, CarbonUnsafe.LONG_ARRAY_OFFSET, size, MemoryType.ONHEAP);
                        memory.setFreedStatus(false);
                        return memory;
                    }
                    this.bufferPoolsBySize.remove(alignedSize);
                }
            }
        }
        long[] array = new long[numWords];
        return new MemoryBlock(array, CarbonUnsafe.LONG_ARRAY_OFFSET, size, MemoryType.ONHEAP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(MemoryBlock memory) {
        long size = memory.size();
        long[] array = (long[])memory.obj;
        long alignedSize = (size + 7L) / 8L * 8L;
        if (this.shouldPool(alignedSize)) {
            HeapMemoryAllocator heapMemoryAllocator = this;
            synchronized (heapMemoryAllocator) {
                LinkedList<WeakReference<Object>> pool = this.bufferPoolsBySize.get(alignedSize);
                if (pool == null) {
                    pool = new LinkedList();
                    this.bufferPoolsBySize.put(alignedSize, pool);
                }
                pool.add(new WeakReference<long[]>(array));
            }
        }
        memory.setFreedStatus(true);
    }
}

