/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.memory;

import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.memory.MemoryBlock;
import org.apache.carbondata.core.memory.UnsafeSortMemoryManager;
import org.apache.log4j.Logger;

public class IntPointerBuffer {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)IntPointerBuffer.class.getName());
    private int length;
    private int actualSize;
    private int[] pointerBlock;
    private MemoryBlock pointerMemoryBlock;
    private String taskId;

    public IntPointerBuffer(String taskId) {
        this.length = 100000;
        this.pointerBlock = new int[this.length];
        this.taskId = taskId;
    }

    public IntPointerBuffer(int length) {
        this.length = length;
        this.pointerBlock = new int[length];
    }

    public void set(int rowId, int value) {
        this.pointerBlock[rowId] = value;
    }

    public void set(int value) {
        this.ensureMemory();
        this.pointerBlock[this.actualSize] = value;
        ++this.actualSize;
    }

    public int get(int rowId) {
        assert (rowId >= 0) : "rowId (" + rowId + ") should >= 0";
        assert (rowId < this.length) : "rowId (" + rowId + ") should < length (" + this.length + ")";
        if (this.pointerBlock == null) {
            return CarbonUnsafe.getUnsafe().getInt(this.pointerMemoryBlock.getBaseObject(), this.pointerMemoryBlock.getBaseOffset() + (long)(rowId << 2));
        }
        return this.pointerBlock[rowId];
    }

    public void loadToUnsafe() {
        this.pointerMemoryBlock = UnsafeSortMemoryManager.INSTANCE.allocateMemory(this.taskId, this.pointerBlock.length * 4);
        if (null != this.pointerMemoryBlock) {
            for (int i = 0; i < this.pointerBlock.length; ++i) {
                CarbonUnsafe.getUnsafe().putInt(this.pointerMemoryBlock.getBaseObject(), this.pointerMemoryBlock.getBaseOffset() + (long)(i * 4), this.pointerBlock[i]);
            }
            this.pointerBlock = null;
        }
    }

    public int getActualSize() {
        return this.actualSize;
    }

    public int[] getPointerBlock() {
        return this.pointerBlock;
    }

    private void ensureMemory() {
        if (this.actualSize >= this.length) {
            int localLength = this.length + (int)((double)this.length * 0.25);
            int[] memoryAddress = new int[localLength];
            System.arraycopy(this.pointerBlock, 0, memoryAddress, 0, this.length);
            this.pointerBlock = memoryAddress;
            this.length = localLength;
        }
    }

    public void freeMemory() {
        this.pointerBlock = null;
        if (this.pointerMemoryBlock != null) {
            UnsafeSortMemoryManager.INSTANCE.freeMemory(this.taskId, this.pointerMemoryBlock);
        }
    }
}

