/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.memory;

import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.memory.MemoryAllocator;
import org.apache.carbondata.core.memory.MemoryBlock;
import org.apache.carbondata.core.memory.MemoryType;

public class UnsafeMemoryAllocator
implements MemoryAllocator {
    @Override
    public MemoryBlock allocate(long size) throws OutOfMemoryError {
        long address = CarbonUnsafe.getUnsafe().allocateMemory(size);
        CarbonUnsafe.getUnsafe().setMemory(null, address, size, (byte)0);
        return new MemoryBlock(null, address, size, MemoryType.OFFHEAP);
    }

    @Override
    public void free(MemoryBlock memory) {
        assert (memory.obj == null) : "baseObject not null; are you trying to use the off-heap allocator to free on-heap memory?";
        CarbonUnsafe.getUnsafe().freeMemory(memory.offset);
        memory.setFreedStatus(true);
    }
}

