/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.memory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.memory.MemoryAllocator;
import org.apache.carbondata.core.memory.MemoryBlock;
import org.apache.carbondata.core.memory.MemoryType;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class UnsafeMemoryManager {
    private static final Logger LOGGER;
    private static boolean offHeap;
    private static Map<String, Set<MemoryBlock>> taskIdToOffheapMemoryBlockMap;
    public static final UnsafeMemoryManager INSTANCE;
    private long totalMemory;
    private long memoryUsed;
    private MemoryType memoryType;

    private UnsafeMemoryManager(long totalMemory, MemoryType memoryType) {
        this.totalMemory = totalMemory;
        this.memoryType = memoryType;
        LOGGER.info((Object)("Offheap Working Memory manager is created with size " + totalMemory + " with " + (Object)((Object)memoryType)));
    }

    private synchronized MemoryBlock allocateMemory(MemoryType memoryType, String taskId, long memoryRequested) {
        MemoryBlock memoryBlock;
        if (this.memoryUsed + memoryRequested <= this.totalMemory && memoryType == MemoryType.OFFHEAP) {
            memoryBlock = MemoryAllocator.UNSAFE.allocate(memoryRequested);
            this.memoryUsed += memoryBlock.size();
            Set<MemoryBlock> listOfMemoryBlock = taskIdToOffheapMemoryBlockMap.get(taskId);
            if (null == listOfMemoryBlock) {
                listOfMemoryBlock = new HashSet<MemoryBlock>();
                taskIdToOffheapMemoryBlockMap.put(taskId, listOfMemoryBlock);
            }
            listOfMemoryBlock.add(memoryBlock);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Creating Offheap working Memory block (%s) with size %d. Total memory used %d Bytes, left %d Bytes.", memoryBlock.toString(), memoryBlock.size(), this.memoryUsed, this.totalMemory - this.memoryUsed));
            }
        } else {
            memoryBlock = MemoryAllocator.HEAP.allocate(memoryRequested);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Creating onheap working Memory block with size: (%d)", memoryBlock.size()));
            }
        }
        return memoryBlock;
    }

    public synchronized void freeMemory(String taskId, MemoryBlock memoryBlock) {
        if (taskIdToOffheapMemoryBlockMap.containsKey(taskId)) {
            taskIdToOffheapMemoryBlockMap.get(taskId).remove(memoryBlock);
        }
        if (!memoryBlock.isFreedStatus()) {
            this.getMemoryAllocator(memoryBlock.getMemoryType()).free(memoryBlock);
            this.memoryUsed -= memoryBlock.size();
            long l = this.memoryUsed = this.memoryUsed < 0L ? 0L : this.memoryUsed;
            if (LOGGER.isDebugEnabled() && memoryBlock.getMemoryType() == MemoryType.OFFHEAP) {
                LOGGER.debug((Object)String.format("Freeing offheap working memory block (%s) with size: %d, current available memory is: %d", memoryBlock.toString(), memoryBlock.size(), this.totalMemory - this.memoryUsed));
            }
        }
    }

    public synchronized void freeMemoryAll(String taskId) {
        Set<MemoryBlock> memoryBlockSet = taskIdToOffheapMemoryBlockMap.remove(taskId);
        long occuppiedMemory = 0L;
        if (null != memoryBlockSet) {
            Iterator<MemoryBlock> iterator = memoryBlockSet.iterator();
            MemoryBlock memoryBlock = null;
            while (iterator.hasNext()) {
                memoryBlock = iterator.next();
                if (memoryBlock.isFreedStatus()) continue;
                occuppiedMemory += memoryBlock.size();
                this.getMemoryAllocator(memoryBlock.getMemoryType()).free(memoryBlock);
            }
        }
        this.memoryUsed -= occuppiedMemory;
        long l = this.memoryUsed = this.memoryUsed < 0L ? 0L : this.memoryUsed;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Freeing offheap working memory of size %d. Current available memory is %d", occuppiedMemory, this.totalMemory - this.memoryUsed));
        }
        LOGGER.info((Object)String.format("Total offheap working memory used after task %s is %d. Current running tasks are %s", taskId, this.memoryUsed, StringUtils.join(taskIdToOffheapMemoryBlockMap.keySet(), (String)", ")));
    }

    public long getUsableMemory() {
        return this.totalMemory;
    }

    public static MemoryBlock allocateMemoryWithRetry(String taskId, long size) {
        return UnsafeMemoryManager.allocateMemoryWithRetry(UnsafeMemoryManager.INSTANCE.memoryType, taskId, size);
    }

    public static MemoryBlock allocateMemoryWithRetry(MemoryType memoryType, String taskId, long size) {
        return INSTANCE.allocateMemory(memoryType, taskId, size);
    }

    private MemoryAllocator getMemoryAllocator(MemoryType memoryType) {
        switch (memoryType) {
            case ONHEAP: {
                return MemoryAllocator.HEAP;
            }
        }
        return MemoryAllocator.UNSAFE;
    }

    public static boolean isOffHeap() {
        return offHeap;
    }

    public static void destroyDirectByteBuffer(ByteBuffer toBeDestroyed) {
        if (!toBeDestroyed.isDirect()) {
            return;
        }
        try {
            Method cleanerMethod = toBeDestroyed.getClass().getMethod("cleaner", new Class[0]);
            cleanerMethod.setAccessible(true);
            Object cleaner = cleanerMethod.invoke((Object)toBeDestroyed, new Object[0]);
            Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
            cleanMethod.setAccessible(true);
            cleanMethod.invoke(cleaner, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        MemoryType memoryType;
        LOGGER = LogServiceFactory.getLogService((String)UnsafeMemoryManager.class.getName());
        offHeap = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("enable.offheap.sort", "true"));
        long size = 0L;
        String configuredWorkingMemorySize = null;
        try {
            boolean isDriver = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("is.driver.instance", "false"));
            boolean initializedWithUnsafeDriverMemory = false;
            if (isDriver && null != (configuredWorkingMemorySize = CarbonProperties.getInstance().getProperty("carbon.unsafe.driver.working.memory.in.mb"))) {
                size = Long.parseLong(configuredWorkingMemorySize);
                initializedWithUnsafeDriverMemory = true;
            }
            if (!initializedWithUnsafeDriverMemory && null != (configuredWorkingMemorySize = CarbonProperties.getInstance().getProperty("carbon.unsafe.working.memory.in.mb"))) {
                size = Long.parseLong(configuredWorkingMemorySize);
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)("Invalid offheap working memory size value: " + configuredWorkingMemorySize));
        }
        long takenSize = size;
        if (offHeap) {
            memoryType = MemoryType.OFFHEAP;
            long defaultSize = Long.parseLong("512");
            if (takenSize < defaultSize) {
                takenSize = defaultSize;
                LOGGER.warn((Object)String.format("It is not recommended to set offheap working memory size less than %sMB, so setting default value to %d", "512", defaultSize));
            }
            takenSize = takenSize * 1024L * 1024L;
        } else {
            memoryType = MemoryType.ONHEAP;
        }
        INSTANCE = new UnsafeMemoryManager(takenSize, memoryType);
        taskIdToOffheapMemoryBlockMap = new HashMap<String, Set<MemoryBlock>>();
    }
}

