/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.memory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.memory.MemoryAllocator;
import org.apache.carbondata.core.memory.MemoryBlock;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class UnsafeSortMemoryManager {
    private static final Logger LOGGER;
    private static boolean offHeap;
    private static Map<String, Set<MemoryBlock>> taskIdToMemoryBlockMap;
    public static final UnsafeSortMemoryManager INSTANCE;
    private long totalMemory;
    private long memoryUsed;
    private MemoryAllocator allocator;

    private UnsafeSortMemoryManager(long totalMemory, MemoryAllocator allocator) {
        this.totalMemory = totalMemory;
        this.allocator = allocator;
        LOGGER.info((Object)("Sort Memory manager is created with size " + totalMemory + " with " + allocator));
    }

    public long getUsableMemory() {
        return this.totalMemory;
    }

    public synchronized void freeMemory(String taskId, MemoryBlock memoryBlock) {
        if (taskIdToMemoryBlockMap.containsKey(taskId)) {
            taskIdToMemoryBlockMap.get(taskId).remove(memoryBlock);
        }
        if (!memoryBlock.isFreedStatus()) {
            this.allocator.free(memoryBlock);
            this.memoryUsed -= memoryBlock.size();
            long l = this.memoryUsed = this.memoryUsed < 0L ? 0L : this.memoryUsed;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Freeing sort memory block (%s) with size: %d, current available memory is: %d", memoryBlock.toString(), memoryBlock.size(), this.totalMemory - this.memoryUsed));
            }
        }
    }

    public synchronized void freeMemoryAll(String taskId) {
        Set<MemoryBlock> memoryBlockSet = null;
        memoryBlockSet = taskIdToMemoryBlockMap.remove(taskId);
        long occuppiedMemory = 0L;
        if (null != memoryBlockSet) {
            Iterator<MemoryBlock> iterator = memoryBlockSet.iterator();
            MemoryBlock memoryBlock = null;
            while (iterator.hasNext()) {
                memoryBlock = iterator.next();
                if (memoryBlock.isFreedStatus()) continue;
                occuppiedMemory += memoryBlock.size();
                this.allocator.free(memoryBlock);
            }
        }
        this.memoryUsed -= occuppiedMemory;
        long l = this.memoryUsed = this.memoryUsed < 0L ? 0L : this.memoryUsed;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Freeing sort memory of size: %d, current available memory is: %d", occuppiedMemory, this.totalMemory - this.memoryUsed));
        }
        LOGGER.info((Object)String.format("Total sort memory used after task %s is %d. Current running tasks are: %s", taskId, this.memoryUsed, StringUtils.join(taskIdToMemoryBlockMap.keySet(), (String)", ")));
    }

    public synchronized boolean isMemoryAvailable(long required) {
        return this.memoryUsed + required < this.totalMemory;
    }

    public synchronized MemoryBlock allocateMemory(String taskId, long memoryRequested) {
        if (this.memoryUsed + memoryRequested <= this.totalMemory) {
            Set<MemoryBlock> listOfMemoryBlock;
            MemoryBlock allocate = this.allocator.allocate(memoryRequested);
            this.memoryUsed += allocate.size();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Sort Memory block is created with size %d. Total memory used %d Bytes, left %d Bytes", allocate.size(), this.memoryUsed, this.totalMemory - this.memoryUsed));
            }
            if (null == (listOfMemoryBlock = taskIdToMemoryBlockMap.get(taskId))) {
                listOfMemoryBlock = new HashSet<MemoryBlock>();
                taskIdToMemoryBlockMap.put(taskId, listOfMemoryBlock);
            }
            listOfMemoryBlock.add(allocate);
            return allocate;
        }
        return null;
    }

    public static boolean isOffHeap() {
        return offHeap;
    }

    static {
        MemoryAllocator allocator;
        long size;
        LOGGER = LogServiceFactory.getLogService((String)UnsafeSortMemoryManager.class.getName());
        offHeap = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("enable.offheap.sort", "true"));
        try {
            size = Long.parseLong(CarbonProperties.getInstance().getProperty("carbon.sort.storage.inmemory.size.inmb"));
        }
        catch (Exception e) {
            size = 512L;
            LOGGER.info((Object)("Wrong memory size given, so setting default value to " + size));
        }
        if (size < 512L) {
            size = 512L;
            LOGGER.warn((Object)String.format("It is not recommended to set unsafe sort memory size less than %dMB, so setting default value to %d", 512, size));
        }
        long takenSize = size * 1024L * 1024L;
        if (offHeap) {
            allocator = MemoryAllocator.UNSAFE;
        } else {
            long maxMemory = Runtime.getRuntime().maxMemory() * 60L / 100L;
            if (takenSize > maxMemory) {
                takenSize = maxMemory;
            }
            allocator = MemoryAllocator.HEAP;
        }
        INSTANCE = new UnsafeSortMemoryManager(takenSize, allocator);
        taskIdToMemoryBlockMap = new HashMap<String, Set<MemoryBlock>>();
    }
}

