/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata;

import java.io.Serializable;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;

public class AbsoluteTableIdentifier
implements Serializable {
    private static final long serialVersionUID = 4695047103484427506L;
    private String tablePath;
    private CarbonTableIdentifier carbonTableIdentifier;

    private AbsoluteTableIdentifier(String tablePath, CarbonTableIdentifier carbonTableIdentifier) {
        this.tablePath = FileFactory.getUpdatedFilePath(tablePath);
        this.carbonTableIdentifier = carbonTableIdentifier;
    }

    public CarbonTableIdentifier getCarbonTableIdentifier() {
        return this.carbonTableIdentifier;
    }

    public static AbsoluteTableIdentifier from(String tablePath, String dbName, String tableName, String tableId) {
        CarbonTableIdentifier identifier = new CarbonTableIdentifier(dbName, tableName, tableId);
        return new AbsoluteTableIdentifier(tablePath, identifier);
    }

    public static AbsoluteTableIdentifier from(String tablePath, String dbName, String tableName) {
        return AbsoluteTableIdentifier.from(tablePath, dbName, tableName, "");
    }

    public static AbsoluteTableIdentifier from(String tablePath) {
        return AbsoluteTableIdentifier.from(tablePath, "", "", "");
    }

    public static AbsoluteTableIdentifier from(String tablePath, CarbonTableIdentifier carbonTableIdentifier) {
        return new AbsoluteTableIdentifier(tablePath, carbonTableIdentifier);
    }

    public String getTablePath() {
        return this.tablePath;
    }

    public String appendWithLocalPrefix(String path) {
        if (this.tablePath.startsWith("file://")) {
            return "file://" + path;
        }
        return path;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.carbonTableIdentifier == null ? 0 : this.carbonTableIdentifier.hashCode());
        result = 31 * result + (this.tablePath == null ? 0 : this.tablePath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbsoluteTableIdentifier)) {
            return false;
        }
        AbsoluteTableIdentifier other = (AbsoluteTableIdentifier)obj;
        if (this.carbonTableIdentifier == null ? other.carbonTableIdentifier != null : !this.carbonTableIdentifier.equals(other.carbonTableIdentifier)) {
            return false;
        }
        return !(this.tablePath == null ? other.tablePath != null : !this.tablePath.equals(other.tablePath));
    }

    public String uniqueName() {
        return this.tablePath + "/" + this.carbonTableIdentifier.toString().toLowerCase();
    }

    public String getDatabaseName() {
        return this.carbonTableIdentifier.getDatabaseName();
    }

    public String getTableName() {
        return this.carbonTableIdentifier.getTableName();
    }

    public String toString() {
        return this.carbonTableIdentifier.toString();
    }
}

