/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;

public final class CarbonMetadata {
    private static final CarbonMetadata CARBONMETADATAINSTANCE = new CarbonMetadata();
    private Map<String, CarbonTable> tableInfoMap = new ConcurrentHashMap<String, CarbonTable>();

    private CarbonMetadata() {
    }

    public static CarbonMetadata getInstance() {
        return CARBONMETADATAINSTANCE;
    }

    public void removeTable(String tableUniquName) {
        this.tableInfoMap.remove(this.convertToLowerCase(tableUniquName));
    }

    public void removeTable(String databaseName, String tableName) {
        this.removeTable(CarbonTable.buildUniqueName(databaseName, tableName));
    }

    public void loadTableMetadata(TableInfo tableInfo) {
        CarbonTable carbonTable = this.tableInfoMap.get(this.convertToLowerCase(tableInfo.getTableUniqueName()));
        if (null == carbonTable || carbonTable.getTableLastUpdatedTime() < tableInfo.getLastUpdatedTime()) {
            carbonTable = CarbonTable.buildFromTableInfo(tableInfo);
            this.tableInfoMap.put(this.convertToLowerCase(tableInfo.getTableUniqueName()), carbonTable);
        }
    }

    public CarbonTable getCarbonTable(String tableUniqueName) {
        return this.tableInfoMap.get(this.convertToLowerCase(tableUniqueName));
    }

    public CarbonTable getCarbonTable(String databaseName, String tableName) {
        return this.getCarbonTable(CarbonTable.buildUniqueName(databaseName, tableName));
    }

    public int getNumberOfTables() {
        return this.tableInfoMap.size();
    }

    public String convertToLowerCase(String table) {
        return table.toLowerCase();
    }

    public CarbonDimension getCarbonDimensionBasedOnColIdentifier(CarbonTable carbonTable, String columnIdentifier) {
        List<CarbonDimension> listOfCarbonDims = carbonTable.getVisibleDimensions();
        for (CarbonDimension dimension : listOfCarbonDims) {
            CarbonDimension childDim;
            if (dimension.getColumnId().equalsIgnoreCase(columnIdentifier)) {
                return dimension;
            }
            if (dimension.getNumberOfChild() <= 0 || null == (childDim = this.getCarbonChildDimsBasedOnColIdentifier(columnIdentifier, dimension))) continue;
            return childDim;
        }
        return null;
    }

    private CarbonDimension getCarbonChildDimsBasedOnColIdentifier(String columnIdentifier, CarbonDimension dimension) {
        for (int i = 0; i < dimension.getNumberOfChild(); ++i) {
            CarbonDimension childDim;
            if (dimension.getListOfChildDimensions().get(i).getColumnId().equalsIgnoreCase(columnIdentifier)) {
                return dimension.getListOfChildDimensions().get(i);
            }
            if (dimension.getListOfChildDimensions().get(i).getNumberOfChild() <= 0 || null == (childDim = this.getCarbonChildDimsBasedOnColIdentifier(columnIdentifier, dimension.getListOfChildDimensions().get(i)))) continue;
            return childDim;
        }
        return null;
    }

    public List<CarbonTable> getAllTables() {
        return new ArrayList<CarbonTable>(this.tableInfoMap.values());
    }

    public void clearAll() {
        this.tableInfoMap.clear();
    }
}

