/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata;

import java.io.File;
import java.io.Serializable;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;

public class CarbonTableIdentifier
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String tableUniqueName;
    private String databaseName;
    private String tableName;
    private String tableId;

    public CarbonTableIdentifier(String databaseName, String tableName, String tableId) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.tableId = tableId;
        this.tableUniqueName = CarbonTable.buildUniqueName(databaseName, tableName);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getTableUniqueName() {
        return this.tableUniqueName;
    }

    public String getBadRecordLoggerKey() {
        return this.databaseName + File.separator + this.tableName + '_' + this.tableId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CarbonTableIdentifier other = (CarbonTableIdentifier)obj;
        if (this.databaseName == null ? other.databaseName != null : !this.databaseName.equals(other.databaseName)) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }

    public String toString() {
        return this.tableUniqueName;
    }
}

