/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata;

import java.io.Serializable;
import java.util.Map;
import org.apache.carbondata.core.metadata.datatype.DataType;

public class ColumnIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String columnId;
    private Map<String, String> columnProperties;
    private DataType dataType;

    public ColumnIdentifier(String columnId, Map<String, String> columnProperties, DataType dataType) {
        this.columnId = columnId;
        this.columnProperties = columnProperties;
        this.dataType = dataType;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public String getColumnProperty(String columnProperty) {
        String property = null;
        if (null != this.columnProperties) {
            property = this.columnProperties.get(columnProperty);
        }
        return property;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnId == null ? 0 : this.columnId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnIdentifier other = (ColumnIdentifier)obj;
        return !(this.columnId == null ? other.columnId != null : !this.columnId.equals(other.columnId));
    }

    public String toString() {
        return "ColumnIdentifier [columnId=" + this.columnId + "]";
    }
}

