/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata;

import org.apache.carbondata.core.util.CarbonProperties;

public abstract class DatabaseLocationProvider {
    private static final DatabaseLocationProvider PROVIDER;

    public static DatabaseLocationProvider get() {
        return PROVIDER == null ? Default.INSTANCE : PROVIDER;
    }

    public abstract String provide(String var1);

    static {
        DatabaseLocationProvider provider;
        String providerClassName = CarbonProperties.getInstance().getProperty("org.apache.carbondata.database.location.provider");
        if (providerClassName == null) {
            provider = null;
        } else {
            try {
                Class<?> providerClass = DatabaseLocationProvider.class.getClassLoader().loadClass(providerClassName);
                provider = (DatabaseLocationProvider)providerClass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
                throw new RuntimeException("Fail to construct database location provider[" + providerClassName + "].", exception);
            }
        }
        PROVIDER = provider;
    }

    private static final class Default
    extends DatabaseLocationProvider {
        static final Default INSTANCE = new Default();

        private Default() {
        }

        @Override
        public String provide(String originalDatabaseName) {
            return originalDatabaseName;
        }
    }
}

