/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperationFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperations;
import org.apache.carbondata.core.fileoperations.FileWriteOperation;
import org.apache.carbondata.core.index.IndexStoreManager;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.TableIndex;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.indexstore.blockletindex.SegmentIndexFileStore;
import org.apache.carbondata.core.locks.CarbonLockUtil;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.segmentmeta.SegmentColumnMetaDataInfo;
import org.apache.carbondata.core.segmentmeta.SegmentMetaDataInfo;
import org.apache.carbondata.core.segmentmeta.SegmentMetaDataInfoStats;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataFileFooterConverter;
import org.apache.carbondata.core.util.ObjectSerializationUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.writer.CarbonIndexFileMergeWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class SegmentFileStore {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)SegmentFileStore.class.getCanonicalName());
    private SegmentFile segmentFile;
    private Map<String, List<String>> indexFilesMap;
    private String tablePath;

    public SegmentFileStore(String tablePath, String segmentFileName) throws IOException {
        this.tablePath = tablePath;
        this.segmentFile = this.readSegment(tablePath, segmentFileName);
    }

    public static void writeSegmentFile(String tablePath, String taskNo, String location, String timeStamp, List<String> partionNames) throws IOException {
        SegmentFileStore.writeSegmentFile(tablePath, taskNo, location, timeStamp, partionNames, false);
    }

    public static void writeSegmentFile(String tablePath, final String taskNo, String location, String timeStamp, List<String> partionNames, boolean isMergeIndexFlow) throws IOException {
        CarbonFile[] carbonFiles;
        CarbonFile tempFolder;
        String tempFolderLoc = timeStamp + ".tmp";
        String writePath = CarbonTablePath.getSegmentFilesLocation(tablePath) + "/" + tempFolderLoc;
        CarbonFile carbonFile = FileFactory.getCarbonFile(writePath);
        if (!carbonFile.exists()) {
            carbonFile.mkdirs();
        }
        if (((tempFolder = isMergeIndexFlow ? FileFactory.getCarbonFile(location) : FileFactory.getCarbonFile(location + "/" + tempFolderLoc)).exists() && partionNames.size() > 0 || isMergeIndexFlow && partionNames.size() > 0) && (carbonFiles = tempFolder.listFiles(new CarbonFileFilter(){

            @Override
            public boolean accept(CarbonFile file) {
                return file.getName().startsWith(taskNo) && (file.getName().endsWith(".carbonindex") || file.getName().endsWith(".carbonindexmerge"));
            }
        })) != null && carbonFiles.length > 0) {
            boolean isRelative = false;
            if (location.startsWith(tablePath)) {
                location = location.substring(tablePath.length(), location.length());
                isRelative = true;
            }
            SegmentFile segmentFile = new SegmentFile();
            FolderDetails folderDetails = new FolderDetails();
            folderDetails.setRelative(isRelative);
            folderDetails.setPartitions(partionNames);
            folderDetails.setStatus(SegmentStatus.SUCCESS.getMessage());
            for (CarbonFile file : carbonFiles) {
                if (file.getName().endsWith(".carbonindexmerge")) {
                    folderDetails.setMergeFileName(file.getName());
                    continue;
                }
                folderDetails.getFiles().add(file.getName());
            }
            segmentFile.addPath(location, folderDetails);
            String path = null;
            path = isMergeIndexFlow ? writePath + "/" + CarbonUtil.generateUUID() + ".segment" : writePath + "/" + taskNo + ".segment";
            SegmentFileStore.writeSegmentFile(segmentFile, path);
        }
    }

    public static String genSegmentFileName(String segmentId, String UUID2) {
        return segmentId + "_" + UUID2;
    }

    public static String writeSegmentFile(CarbonTable carbonTable, String segmentId, String UUID2, SegmentMetaDataInfo segmentMetaDataInfo) throws IOException {
        return SegmentFileStore.writeSegmentFile(carbonTable, segmentId, UUID2, null, segmentMetaDataInfo);
    }

    public static String writeSegmentFile(CarbonTable carbonTable, String segmentId, String UUID2) throws IOException {
        return SegmentFileStore.writeSegmentFile(carbonTable, segmentId, UUID2, null, null);
    }

    public static String writeSegmentFile(CarbonTable carbonTable, String segmentId, String UUID2, String segPath, SegmentMetaDataInfo segmentMetaDataInfo) throws IOException {
        return SegmentFileStore.writeSegmentFile(carbonTable, segmentId, UUID2, null, segPath, segmentMetaDataInfo);
    }

    public static String writeSegmentFile(CarbonTable carbonTable, String segmentId, String UUID2, String segPath) throws IOException {
        return SegmentFileStore.writeSegmentFile(carbonTable, segmentId, UUID2, null, segPath, null);
    }

    public static CarbonFile[] getListOfCarbonIndexFiles(String segmentPath) {
        CarbonFile segmentFolder = FileFactory.getCarbonFile(segmentPath);
        CarbonFile[] indexFiles = segmentFolder.listFiles(new CarbonFileFilter(){

            @Override
            public boolean accept(CarbonFile file) {
                return file.getName().endsWith(".carbonindex") || file.getName().endsWith(".carbonindexmerge");
            }
        });
        return indexFiles;
    }

    public static boolean writeSegmentFile(CarbonTable carbonTable, Segment segment) throws IOException {
        String tablePath = carbonTable.getTablePath();
        CarbonFile[] indexFiles = SegmentFileStore.getListOfCarbonIndexFiles(segment.getSegmentPath());
        if (indexFiles != null && indexFiles.length > 0) {
            SegmentFile segmentFile = new SegmentFile();
            segmentFile.setOptions(segment.getOptions());
            FolderDetails folderDetails = new FolderDetails();
            folderDetails.setStatus(SegmentStatus.SUCCESS.getMessage());
            folderDetails.setRelative(false);
            segmentFile.addPath(segment.getSegmentPath(), folderDetails);
            for (CarbonFile file : indexFiles) {
                if (file.getName().endsWith(".carbonindexmerge")) {
                    folderDetails.setMergeFileName(file.getName());
                    continue;
                }
                folderDetails.getFiles().add(file.getName());
            }
            String segmentFileFolder = CarbonTablePath.getSegmentFilesLocation(tablePath);
            CarbonFile carbonFile = FileFactory.getCarbonFile(segmentFileFolder);
            if (!carbonFile.exists()) {
                carbonFile.mkdirs();
            }
            SegmentFileStore.writeSegmentFile(segmentFile, segmentFileFolder + File.separator + segment.getSegmentFileName());
            return true;
        }
        return false;
    }

    public static boolean writeSegmentFileForOthers(CarbonTable carbonTable, Segment segment, PartitionSpec partitionSpec, List<FileStatus> partitionDataFiles) throws IOException {
        String tablePath = carbonTable.getTablePath();
        CarbonFile[] dataFiles = null;
        if (partitionDataFiles.isEmpty()) {
            CarbonFile segmentFolder = FileFactory.getCarbonFile(segment.getSegmentPath());
            dataFiles = segmentFolder.listFiles(file -> !file.getName().equals("_SUCCESS") && !file.getName().endsWith(".crc"));
        } else {
            dataFiles = (CarbonFile[])partitionDataFiles.stream().map(fileStatus -> FileFactory.getCarbonFile(fileStatus.getPath().toString())).toArray(CarbonFile[]::new);
        }
        if (dataFiles != null && dataFiles.length > 0) {
            SegmentFile segmentFile = new SegmentFile();
            segmentFile.setOptions(segment.getOptions());
            FolderDetails folderDetails = new FolderDetails();
            folderDetails.setStatus(SegmentStatus.SUCCESS.getMessage());
            folderDetails.setRelative(false);
            if (!partitionDataFiles.isEmpty()) {
                folderDetails.setPartitions(partitionSpec.getPartitions());
                segmentFile.addPath(partitionSpec.getLocation().toString(), folderDetails);
            } else {
                segmentFile.addPath(segment.getSegmentPath(), folderDetails);
            }
            for (CarbonFile file2 : dataFiles) {
                folderDetails.getFiles().add(file2.getName());
            }
            String segmentFileFolder = CarbonTablePath.getSegmentFilesLocation(tablePath);
            CarbonFile carbonFile = FileFactory.getCarbonFile(segmentFileFolder);
            if (!carbonFile.exists()) {
                carbonFile.mkdirs();
            }
            SegmentFileStore.writeSegmentFile(segmentFile, segmentFileFolder + File.separator + segment.getSegmentFileName());
            return true;
        }
        return false;
    }

    public static void mergeIndexAndWriteSegmentFile(CarbonTable carbonTable, String segmentId, String UUID2) {
        String tablePath = carbonTable.getTablePath();
        String segmentFileName = SegmentFileStore.genSegmentFileName(segmentId, UUID2) + ".segment";
        try {
            SegmentFileStore sfs = new SegmentFileStore(tablePath, segmentFileName);
            List<CarbonFile> carbonIndexFiles = sfs.getIndexCarbonFiles();
            new CarbonIndexFileMergeWriter(carbonTable).writeMergeIndexFileBasedOnSegmentFile(segmentId, null, sfs, carbonIndexFiles.toArray(new CarbonFile[carbonIndexFiles.size()]), UUID2, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String writeSegmentFile(CarbonTable carbonTable, String segmentId, String UUID2, final String currentLoadTimeStamp, String absSegPath, SegmentMetaDataInfo segmentMetaDataInfo) throws IOException {
        CarbonFile segmentFolder;
        CarbonFile[] indexFiles;
        String tablePath = carbonTable.getTablePath();
        boolean supportFlatFolder = carbonTable.isSupportFlatFolder();
        String segmentPath = absSegPath;
        if (absSegPath == null) {
            segmentPath = CarbonTablePath.getSegmentPath(tablePath, segmentId);
        }
        if ((indexFiles = (segmentFolder = FileFactory.getCarbonFile(segmentPath)).listFiles(new CarbonFileFilter(){

            @Override
            public boolean accept(CarbonFile file) {
                if (null != currentLoadTimeStamp) {
                    return file.getName().contains(currentLoadTimeStamp) && (file.getName().endsWith(".carbonindex") || file.getName().endsWith(".carbonindexmerge"));
                }
                return file.getName().endsWith(".carbonindex") || file.getName().endsWith(".carbonindexmerge");
            }
        })) != null && indexFiles.length > 0) {
            String segmentFileFolder;
            CarbonFile carbonFile;
            SegmentFile segmentFile = new SegmentFile();
            FolderDetails folderDetails = new FolderDetails();
            folderDetails.setRelative(absSegPath == null);
            folderDetails.setStatus(SegmentStatus.SUCCESS.getMessage());
            for (CarbonFile file : indexFiles) {
                if (file.getName().endsWith(".carbonindexmerge")) {
                    folderDetails.setMergeFileName(file.getName());
                    continue;
                }
                folderDetails.getFiles().add(file.getName());
            }
            String segmentRelativePath = "/";
            if (!supportFlatFolder) {
                segmentRelativePath = absSegPath != null ? absSegPath : segmentPath.substring(tablePath.length());
            }
            segmentFile.addPath(segmentRelativePath, folderDetails);
            if (null != segmentMetaDataInfo) {
                segmentFile.setSegmentMetaDataInfo(segmentMetaDataInfo);
            }
            if (!(carbonFile = FileFactory.getCarbonFile(segmentFileFolder = CarbonTablePath.getSegmentFilesLocation(tablePath))).exists()) {
                carbonFile.mkdirs();
            }
            String segmentFileName = SegmentFileStore.genSegmentFileName(segmentId, UUID2) + ".segment";
            SegmentFileStore.writeSegmentFile(segmentFile, segmentFileFolder + File.separator + segmentFileName);
            if (supportFlatFolder) {
                SegmentFileStore.moveFromTempFolder(segmentPath, tablePath);
            }
            return segmentFileName;
        }
        return null;
    }

    private static void moveFromTempFolder(String source, String dest) {
        CarbonFile[] oldFiles;
        CarbonFile oldFolder = FileFactory.getCarbonFile(source);
        for (CarbonFile file : oldFiles = oldFolder.listFiles()) {
            file.renameForce(dest + "/" + file.getName());
        }
        oldFolder.delete();
    }

    public static void writeSegmentFile(SegmentFile segmentFile, String path) throws IOException {
        AtomicFileOperations fileWrite = AtomicFileOperationFactory.getAtomicFileOperations(path);
        BufferedWriter brWriter = null;
        DataOutputStream dataOutputStream = null;
        Gson gsonObjectToWrite = new Gson();
        try {
            dataOutputStream = fileWrite.openForWrite(FileWriteOperation.OVERWRITE);
            brWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)dataOutputStream, Charset.forName("UTF-8")));
            String metadataInstance = gsonObjectToWrite.toJson((Object)segmentFile);
            brWriter.write(metadataInstance);
            brWriter.flush();
        }
        catch (IOException ie) {
            try {
                LOGGER.error((Object)("Error message: " + ie.getLocalizedMessage()));
                fileWrite.setFailed();
                throw ie;
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams(brWriter);
                fileWrite.close();
                throw throwable;
            }
        }
        CarbonUtil.closeStreams(brWriter);
        fileWrite.close();
    }

    public static SegmentFile mergeSegmentFiles(String readPath, String mergeFileName, String writePath) throws IOException {
        CarbonFile[] segmentFiles = SegmentFileStore.getSegmentFiles(readPath);
        if (segmentFiles != null && segmentFiles.length > 0) {
            SegmentFile segmentFile = SegmentFileStore.mergeSegmentFiles(mergeFileName, writePath, segmentFiles);
            FileFactory.deleteAllCarbonFilesOfDir(FileFactory.getCarbonFile(readPath));
            return segmentFile;
        }
        return null;
    }

    public static SegmentFile mergeSegmentFiles(String mergeFileName, String writePath, CarbonFile[] segmentFiles) throws IOException {
        SegmentFile segmentFile = null;
        for (CarbonFile file : segmentFiles) {
            SegmentFile localSegmentFile = SegmentFileStore.readSegmentFile(file.getAbsolutePath());
            if (segmentFile == null && localSegmentFile != null) {
                segmentFile = localSegmentFile;
            }
            if (localSegmentFile == null) continue;
            segmentFile = segmentFile.merge(localSegmentFile);
        }
        if (segmentFile != null) {
            String path = writePath + "/" + mergeFileName + ".segment";
            SegmentFileStore.writeSegmentFile(segmentFile, path);
        }
        return segmentFile;
    }

    public static String getSegmentFilePath(String tablePath, String segmentFileName) {
        return CarbonTablePath.getSegmentFilesLocation(tablePath) + "/" + segmentFileName;
    }

    public static boolean updateTableStatusFile(CarbonTable carbonTable, String segmentId, String segmentFile, String tableId, SegmentFileStore segmentFileStore) throws IOException {
        return SegmentFileStore.updateTableStatusFile(carbonTable, segmentId, segmentFile, tableId, segmentFileStore, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateTableStatusFile(CarbonTable carbonTable, String segmentId, String segmentFile, String tableId, SegmentFileStore segmentFileStore, SegmentStatus segmentStatus) throws IOException {
        boolean status = false;
        String tablePath = carbonTable.getTablePath();
        String tableStatusPath = CarbonTablePath.getTableStatusFilePath(tablePath);
        if (!FileFactory.isFileExist(tableStatusPath)) {
            return status;
        }
        String metadataPath = CarbonTablePath.getMetadataPath(tablePath);
        AbsoluteTableIdentifier absoluteTableIdentifier = AbsoluteTableIdentifier.from(tablePath, null, null, tableId);
        SegmentStatusManager segmentStatusManager = new SegmentStatusManager(absoluteTableIdentifier);
        ICarbonLock carbonLock = segmentStatusManager.getTableStatusLock();
        int retryCount = CarbonLockUtil.getLockProperty("carbon.concurrent.lock.retries", 100);
        int maxTimeout = CarbonLockUtil.getLockProperty("carbon.concurrent.lock.retry.timeout.sec", 1);
        try {
            if (carbonLock.lockWithRetries(retryCount, maxTimeout)) {
                LoadMetadataDetails[] listOfLoadFolderDetailsArray;
                LOGGER.info((Object)("Acquired lock for tablepath" + tablePath + " for table status updation"));
                for (LoadMetadataDetails detail : listOfLoadFolderDetailsArray = SegmentStatusManager.readLoadMetadata(metadataPath)) {
                    if (!segmentId.equals(detail.getLoadName())) continue;
                    detail.setLoadEndTime(System.currentTimeMillis());
                    detail.setSegmentFile(segmentFile);
                    if (segmentStatus != null) {
                        HashMap<String, Long> dataSizeAndIndexSize = CarbonUtil.getDataSizeAndIndexSize(segmentFileStore, detail.isCarbonFormat());
                        detail.setDataSize(dataSizeAndIndexSize.get("datasize").toString());
                        detail.setIndexSize(dataSizeAndIndexSize.get("indexsize").toString());
                        detail.setSegmentStatus(segmentStatus);
                        break;
                    }
                    detail.setIndexSize(String.valueOf(CarbonUtil.getCarbonIndexSize(segmentFileStore, segmentFileStore.getLocationMap())));
                    break;
                }
                SegmentStatusManager.writeLoadDetailsIntoFile(tableStatusPath, listOfLoadFolderDetailsArray);
                SegmentFileStore.clearBlockIndexCache(carbonTable, segmentId);
                status = true;
            } else {
                LOGGER.error((Object)("Not able to acquire the lock for Table status updation for table path " + tablePath));
            }
        }
        finally {
            if (carbonLock.unlock()) {
                LOGGER.info((Object)("Table unlocked successfully after table status updation" + tablePath));
            } else {
                LOGGER.error((Object)("Unable to unlock Table lock for table" + tablePath + " during table status updation"));
            }
        }
        return status;
    }

    public static void clearBlockIndexCache(CarbonTable carbonTable, String segmentId) {
        TableIndex defaultIndex = IndexStoreManager.getInstance().getDefaultIndex(carbonTable);
        LOGGER.info((Object)("clearing cache while updating segment file entry in table status file for segmentId: " + segmentId));
        defaultIndex.getIndexFactory().clear(segmentId);
    }

    private static CarbonFile[] getSegmentFiles(String segmentPath) {
        CarbonFile carbonFile = FileFactory.getCarbonFile(segmentPath);
        if (carbonFile.exists()) {
            return carbonFile.listFiles(new CarbonFileFilter(){

                @Override
                public boolean accept(CarbonFile file) {
                    return file.getName().endsWith(".segment");
                }
            });
        }
        return null;
    }

    public static SegmentFile getSegmentFileForPhysicalDataPartitions(String tablePath, List<PartitionSpec> partitionSpecs) throws IOException {
        SegmentFile segmentFile = null;
        for (PartitionSpec spec : partitionSpecs) {
            String location = spec.getLocation().toString();
            CarbonFile carbonFile = FileFactory.getCarbonFile(location);
            CarbonFile[] listFiles = carbonFile.listFiles(new CarbonFileFilter(){

                @Override
                public boolean accept(CarbonFile file) {
                    return CarbonTablePath.isCarbonIndexFile(file.getAbsolutePath());
                }
            });
            if (listFiles == null || listFiles.length <= 0) continue;
            boolean isRelative = false;
            if (location.startsWith(tablePath)) {
                location = location.substring(tablePath.length(), location.length());
                isRelative = true;
            }
            SegmentFile localSegmentFile = new SegmentFile();
            FolderDetails folderDetails = new FolderDetails();
            folderDetails.setRelative(isRelative);
            folderDetails.setPartitions(spec.getPartitions());
            folderDetails.setStatus(SegmentStatus.SUCCESS.getMessage());
            for (CarbonFile file : listFiles) {
                if (file.getName().endsWith(".carbonindexmerge")) {
                    folderDetails.setMergeFileName(file.getName());
                    continue;
                }
                folderDetails.getFiles().add(file.getName());
            }
            localSegmentFile.addPath(location, folderDetails);
            if (segmentFile == null) {
                segmentFile = localSegmentFile;
                continue;
            }
            segmentFile = segmentFile.merge(localSegmentFile);
        }
        return segmentFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SegmentFile readSegmentFile(String segmentFilePath) throws IOException {
        AtomicFileOperations fileOperation;
        InputStreamReader inStream;
        BufferedReader buffReader;
        DataInputStream dataInputStream;
        Gson gsonObjectToRead;
        block3: {
            SegmentFile segmentFile;
            gsonObjectToRead = new Gson();
            dataInputStream = null;
            buffReader = null;
            inStream = null;
            fileOperation = AtomicFileOperationFactory.getAtomicFileOperations(segmentFilePath);
            try {
                if (FileFactory.isFileExist(segmentFilePath)) break block3;
                segmentFile = null;
                if (inStream == null) return segmentFile;
            }
            catch (Throwable throwable) {
                if (inStream == null) throw throwable;
                CarbonUtil.closeStreams(buffReader, inStream, dataInputStream);
                throw throwable;
            }
            CarbonUtil.closeStreams(buffReader, inStream, dataInputStream);
            return segmentFile;
        }
        dataInputStream = fileOperation.openForRead();
        inStream = new InputStreamReader((InputStream)dataInputStream, Charset.forName("UTF-8"));
        buffReader = new BufferedReader(inStream);
        SegmentFile segmentFile = (SegmentFile)gsonObjectToRead.fromJson((Reader)buffReader, SegmentFile.class);
        if (inStream == null) return segmentFile;
        CarbonUtil.closeStreams(buffReader, inStream, dataInputStream);
        return segmentFile;
    }

    private SegmentFile readSegment(String tablePath, String segmentFileName) throws IOException {
        String segmentFilePath = CarbonTablePath.getSegmentFilesLocation(tablePath) + "/" + segmentFileName;
        return SegmentFileStore.readSegmentFile(segmentFilePath);
    }

    public String getTablePath() {
        return this.tablePath;
    }

    public Map<String, List<String>> getIndexFilesMap() {
        return this.indexFilesMap;
    }

    public void readIndexFiles(Configuration configuration) throws IOException {
        this.readIndexFiles(SegmentStatus.SUCCESS, false, configuration);
    }

    public SegmentFile getSegmentFile() {
        return this.segmentFile;
    }

    private List<String> readIndexFiles(SegmentStatus status, boolean ignoreStatus, Configuration configuration) throws IOException {
        if (this.indexFilesMap != null) {
            return new ArrayList<String>();
        }
        ArrayList<String> indexOrMergeFiles = new ArrayList<String>();
        SegmentIndexFileStore indexFileStore = new SegmentIndexFileStore();
        this.indexFilesMap = new HashMap<String, List<String>>();
        indexFileStore.readAllIIndexOfSegment(this.segmentFile, this.tablePath, status, ignoreStatus);
        Map<String, byte[]> carbonIndexMap = indexFileStore.getCarbonIndexMapWithFullPath();
        DataFileFooterConverter fileFooterConverter = new DataFileFooterConverter(configuration);
        for (Map.Entry<String, byte[]> entry : carbonIndexMap.entrySet()) {
            List<DataFileFooter> indexInfo = fileFooterConverter.getIndexInfo(entry.getKey(), entry.getValue());
            LinkedHashSet<String> blocks = new LinkedHashSet<String>();
            for (DataFileFooter footer : indexInfo) {
                blocks.add(footer.getBlockInfo().getFilePath());
            }
            this.indexFilesMap.put(entry.getKey(), new ArrayList(blocks));
            boolean added = false;
            for (Map.Entry<String, List<String>> mergeFile : indexFileStore.getCarbonMergeFileToIndexFilesMap().entrySet()) {
                if (!mergeFile.getValue().contains(entry.getKey().substring(entry.getKey().lastIndexOf("/") + 1, entry.getKey().length()))) continue;
                indexOrMergeFiles.add(mergeFile.getKey());
                added = true;
                break;
            }
            if (added) continue;
            indexOrMergeFiles.add(entry.getKey());
        }
        return indexOrMergeFiles;
    }

    public static Map<String, List<ColumnSchema>> getSchemaFiles(SegmentFile segmentFile, String tablePath) throws IOException {
        HashMap<String, List<ColumnSchema>> schemaMap = new HashMap<String, List<ColumnSchema>>();
        if (segmentFile == null) {
            return schemaMap;
        }
        SegmentIndexFileStore indexFileStore = new SegmentIndexFileStore();
        indexFileStore.readAllIIndexOfSegment(segmentFile, tablePath, SegmentStatus.SUCCESS, true);
        Map<String, byte[]> carbonIndexMap = indexFileStore.getCarbonIndexMapWithFullPath();
        DataFileFooterConverter fileFooterConverter = new DataFileFooterConverter();
        for (Map.Entry<String, byte[]> entry : carbonIndexMap.entrySet()) {
            List<DataFileFooter> indexInfo = fileFooterConverter.getIndexInfo(entry.getKey(), entry.getValue());
            if (indexInfo.size() <= 0) continue;
            schemaMap.put(entry.getKey(), indexInfo.get(0).getColumnInTable());
        }
        return schemaMap;
    }

    public Map<String, String> getIndexFiles() {
        HashMap<String, String> indexFiles = new HashMap<String, String>();
        if (this.segmentFile != null) {
            for (Map.Entry<String, FolderDetails> entry : this.getLocationMap().entrySet()) {
                String location = entry.getKey();
                if (entry.getValue().isRelative) {
                    location = this.tablePath + location;
                }
                if (!entry.getValue().status.equals(SegmentStatus.SUCCESS.getMessage())) continue;
                for (String indexFile : entry.getValue().getFiles()) {
                    indexFiles.put(location + "/" + indexFile, entry.getValue().mergeFileName);
                }
            }
        }
        return indexFiles;
    }

    public Map<String, String> getIndexOrMergeFiles() throws IOException {
        HashMap<String, String> indexFiles = new HashMap<String, String>();
        if (this.segmentFile != null) {
            for (Map.Entry<String, FolderDetails> entry : this.getLocationMap().entrySet()) {
                Set<String> files;
                String location = entry.getKey();
                if (entry.getValue().isRelative) {
                    location = location.equals("/") ? this.tablePath : this.tablePath + location;
                }
                if (!entry.getValue().status.equals(SegmentStatus.SUCCESS.getMessage())) continue;
                String mergeFileName = entry.getValue().getMergeFileName();
                if (null != mergeFileName) {
                    indexFiles.put(location + "/" + mergeFileName, entry.getValue().mergeFileName);
                }
                if (null == (files = entry.getValue().getFiles()) || files.isEmpty()) continue;
                for (String indexFile : files) {
                    String indexFilePath = location + "/" + indexFile;
                    if (!FileFactory.isFileExist(indexFilePath)) continue;
                    indexFiles.put(indexFilePath, null);
                }
            }
        }
        return indexFiles;
    }

    public List<CarbonFile> getIndexCarbonFiles() {
        Map<String, String> indexFiles = this.getIndexFiles();
        HashSet<String> files = new HashSet<String>();
        for (Map.Entry<String, String> entry : indexFiles.entrySet()) {
            Path path = new Path(entry.getKey());
            files.add(entry.getKey());
            if (entry.getValue() == null) continue;
            files.add(new Path(path.getParent(), entry.getValue()).toString());
        }
        ArrayList<CarbonFile> carbonFiles = new ArrayList<CarbonFile>();
        for (String indexFile : files) {
            CarbonFile carbonFile = FileFactory.getCarbonFile(indexFile);
            if (!carbonFile.exists()) continue;
            carbonFiles.add(carbonFile);
        }
        return carbonFiles;
    }

    public void dropPartitions(Segment segment, List<PartitionSpec> partitionSpecs, String uniqueId, List<String> toBeDeletedSegments, List<String> toBeUpdatedSegments) throws IOException {
        this.readSegment(this.tablePath, segment.getSegmentFileName());
        boolean updateSegment = false;
        block0: for (Map.Entry<String, FolderDetails> entry : this.segmentFile.getLocationMap().entrySet()) {
            String location = entry.getKey();
            if (entry.getValue().isRelative) {
                location = this.tablePath + "/" + location;
            }
            Path path = new Path(location);
            if (null == partitionSpecs) continue;
            for (PartitionSpec spec : partitionSpecs) {
                if (!path.equals((Object)spec.getLocation())) continue;
                entry.getValue().setStatus(SegmentStatus.MARKED_FOR_DELETE.getMessage());
                updateSegment = true;
                continue block0;
            }
        }
        if (updateSegment) {
            String writePath = CarbonTablePath.getSegmentFilesLocation(this.tablePath);
            writePath = writePath + "/" + SegmentFileStore.genSegmentFileName(segment.getSegmentNo(), String.valueOf(uniqueId)) + ".segment";
            SegmentFileStore.writeSegmentFile(this.segmentFile, writePath);
        }
        boolean deleteSegment = true;
        for (Map.Entry<String, FolderDetails> entry : this.segmentFile.getLocationMap().entrySet()) {
            if (!entry.getValue().getStatus().equals(SegmentStatus.SUCCESS.getMessage())) continue;
            deleteSegment = false;
            break;
        }
        if (deleteSegment) {
            toBeDeletedSegments.add(segment.getSegmentNo());
        }
        if (updateSegment) {
            toBeUpdatedSegments.add(segment.getSegmentNo());
        }
    }

    public static void commitDropPartitions(CarbonTable carbonTable, String uniqueId, List<String> toBeUpdatedSegments, List<String> toBeDeleteSegments, String uuid) throws IOException {
        if (toBeDeleteSegments.size() > 0 || toBeUpdatedSegments.size() > 0) {
            HashSet<Segment> segmentSet = new HashSet<Segment>(new SegmentStatusManager(carbonTable.getAbsoluteTableIdentifier()).getValidAndInvalidSegments(carbonTable.isMV()).getValidSegments());
            CarbonUpdateUtil.updateTableMetadataStatus(segmentSet, carbonTable, uniqueId, true, Segment.toSegmentList(toBeDeleteSegments, null), Segment.toSegmentList(toBeUpdatedSegments, null), uuid);
        }
    }

    public static void cleanSegments(CarbonTable table, List<PartitionSpec> partitionSpecs, boolean forceDelete) throws IOException {
        LoadMetadataDetails[] details;
        for (LoadMetadataDetails segment : details = SegmentStatusManager.readLoadMetadata(table.getMetadataPath())) {
            if (segment.getSegmentStatus() != SegmentStatus.SUCCESS && segment.getSegmentStatus() != SegmentStatus.LOAD_PARTIAL_SUCCESS || segment.getSegmentFile() == null) continue;
            ArrayList<String> toBeDeletedIndexFiles = new ArrayList<String>();
            ArrayList toBeDeletedDataFiles = new ArrayList();
            SegmentFileStore fileStore = new SegmentFileStore(table.getTablePath(), segment.getSegmentFile());
            List<String> indexOrMergeFiles = fileStore.readIndexFiles(SegmentStatus.MARKED_FOR_DELETE, false, FileFactory.getConfiguration());
            if (forceDelete) {
                SegmentFileStore.deletePhysicalPartition(partitionSpecs, fileStore.getIndexFilesMap(), indexOrMergeFiles, table.getTablePath());
            }
            for (Map.Entry<String, List<String>> entry : fileStore.indexFilesMap.entrySet()) {
                String indexFile = entry.getKey();
                Long fileTimestamp = CarbonUpdateUtil.getTimeStampAsLong(indexFile.substring(indexFile.lastIndexOf("-") + 1, indexFile.length() - ".carbonindex".length()));
                if (!CarbonUpdateUtil.isMaxQueryTimeoutExceeded(fileTimestamp) && !forceDelete) continue;
                toBeDeletedDataFiles.addAll(entry.getValue());
            }
            for (String indexFile : indexOrMergeFiles) {
                Long fileTimestamp = 0L;
                if (indexFile.endsWith(".carbonindex")) {
                    fileTimestamp = CarbonUpdateUtil.getTimeStampAsLong(indexFile.substring(indexFile.lastIndexOf("-") + 1, indexFile.length() - ".carbonindex".length()));
                } else if (indexFile.endsWith(".carbonindexmerge")) {
                    fileTimestamp = CarbonUpdateUtil.getTimeStampAsLong(indexFile.substring(indexFile.lastIndexOf("_") + 1, indexFile.length() - ".carbonindexmerge".length()));
                }
                if (!CarbonUpdateUtil.isMaxQueryTimeoutExceeded(fileTimestamp) && !forceDelete) continue;
                toBeDeletedIndexFiles.add(indexFile);
            }
            if (toBeDeletedIndexFiles.size() <= 0) continue;
            for (String dataFile : toBeDeletedIndexFiles) {
                FileFactory.deleteFile(dataFile);
            }
            for (String dataFile : toBeDeletedDataFiles) {
                FileFactory.deleteFile(dataFile);
            }
        }
    }

    public static void deleteSegment(String tablePath, Segment segment, List<PartitionSpec> partitionSpecs, SegmentUpdateStatusManager updateStatusManager) throws Exception {
        SegmentFileStore fileStore = new SegmentFileStore(tablePath, segment.getSegmentFileName());
        List<String> indexOrMergeFiles = fileStore.readIndexFiles(SegmentStatus.SUCCESS, true, FileFactory.getConfiguration());
        Map<String, List<String>> indexFilesMap = fileStore.getIndexFilesMap();
        for (Map.Entry<String, List<String>> entry : indexFilesMap.entrySet()) {
            FileFactory.deleteFile(entry.getKey());
            for (String file : entry.getValue()) {
                String[] deltaFilePaths;
                for (String deltaFilePath : deltaFilePaths = updateStatusManager.getDeleteDeltaFilePath(file, segment.getSegmentNo())) {
                    FileFactory.deleteFile(deltaFilePath);
                }
                FileFactory.deleteFile(file);
            }
        }
        SegmentFileStore.deletePhysicalPartition(partitionSpecs, indexFilesMap, indexOrMergeFiles, tablePath);
        String segmentFilePath = CarbonTablePath.getSegmentFilePath(tablePath, segment.getSegmentFileName());
        FileFactory.deleteFile(segmentFilePath);
    }

    private static void deletePhysicalPartition(List<PartitionSpec> partitionSpecs, Map<String, List<String>> locationMap, List<String> indexOrMergeFiles, String tablePath) {
        Path location;
        for (String string : indexOrMergeFiles) {
            if (null != partitionSpecs) {
                location = new Path(string);
                boolean exists = SegmentFileStore.pathExistsInPartitionSpec(partitionSpecs, location);
                if (exists) continue;
                FileFactory.deleteAllCarbonFilesOfDir(FileFactory.getCarbonFile(location.toString()));
                continue;
            }
            location = new Path(string);
            FileFactory.deleteAllCarbonFilesOfDir(FileFactory.getCarbonFile(location.toString()));
        }
        for (Map.Entry entry : locationMap.entrySet()) {
            if (partitionSpecs != null) {
                location = new Path((String)entry.getKey());
                boolean exists = SegmentFileStore.pathExistsInPartitionSpec(partitionSpecs, location);
                if (!exists) {
                    FileFactory.deleteAllCarbonFilesOfDir(FileFactory.getCarbonFile(location.toString()));
                    for (String carbonDataFile : (List)entry.getValue()) {
                        FileFactory.deleteAllCarbonFilesOfDir(FileFactory.getCarbonFile(carbonDataFile));
                    }
                }
                CarbonFile path = FileFactory.getCarbonFile(location.getParent().toString());
                SegmentFileStore.deleteEmptyPartitionFolders(path);
                continue;
            }
            location = new Path((String)entry.getKey()).getParent();
            CarbonFile segmentPath = FileFactory.getCarbonFile(location.toString());
            if (null == segmentPath || !segmentPath.exists() || new Path(tablePath).equals((Object)new Path(segmentPath.getAbsolutePath()))) continue;
            FileFactory.deleteAllCarbonFilesOfDir(segmentPath);
        }
    }

    private static void deleteEmptyPartitionFolders(CarbonFile path) {
        if (path != null && path.listFiles().length == 0) {
            FileFactory.deleteAllCarbonFilesOfDir(path);
            Path parentsLocation = new Path(path.getAbsolutePath()).getParent();
            SegmentFileStore.deleteEmptyPartitionFolders(FileFactory.getCarbonFile(parentsLocation.toString()));
        }
    }

    private static boolean pathExistsInPartitionSpec(List<PartitionSpec> partitionSpecs, Path partitionPath) {
        for (PartitionSpec spec : partitionSpecs) {
            if (!spec.getLocation().equals((Object)partitionPath)) continue;
            return true;
        }
        return false;
    }

    public static List<PartitionSpec> getPartitionSpecs(String segmentId, String tablePath, LoadMetadataDetails[] details) throws IOException {
        LoadMetadataDetails segEntry = null;
        for (LoadMetadataDetails entry : details) {
            if (!entry.getLoadName().equals(segmentId)) continue;
            segEntry = entry;
            break;
        }
        if (segEntry != null && segEntry.getSegmentFile() != null) {
            SegmentFileStore fileStore = new SegmentFileStore(tablePath, segEntry.getSegmentFile());
            List<PartitionSpec> partitionSpecs = fileStore.getPartitionSpecs();
            for (PartitionSpec spec : partitionSpecs) {
                spec.setUuid(segmentId + "_" + segEntry.getLoadStartTime());
            }
            return partitionSpecs;
        }
        return new ArrayList<PartitionSpec>();
    }

    public static void moveFromTempFolder(SegmentFile segmentFile, String tmpFolder, String tablePath) {
        for (Map.Entry<String, FolderDetails> entry : segmentFile.getLocationMap().entrySet()) {
            CarbonFile[] oldFiles;
            String location = entry.getKey();
            if (entry.getValue().isRelative()) {
                location = tablePath + "/" + location;
            }
            CarbonFile oldFolder = FileFactory.getCarbonFile(location + "/" + tmpFolder);
            for (CarbonFile file : oldFiles = oldFolder.listFiles()) {
                file.renameForce(location + "/" + file.getName());
            }
            oldFolder.delete();
        }
    }

    public static void removeTempFolder(Map<String, FolderDetails> locationMap, String tmpFolder, String tablePath) {
        if (locationMap == null) {
            return;
        }
        for (Map.Entry<String, FolderDetails> entry : locationMap.entrySet()) {
            CarbonFile oldFolder;
            String location = entry.getKey();
            if (entry.getValue().isRelative()) {
                location = tablePath + "/" + location;
            }
            if (!(oldFolder = FileFactory.getCarbonFile(location + "/" + tmpFolder)).exists()) continue;
            FileFactory.deleteAllCarbonFilesOfDir(oldFolder);
        }
    }

    public Map<String, FolderDetails> getLocationMap() {
        if (this.segmentFile == null) {
            return new HashMap<String, FolderDetails>();
        }
        return this.segmentFile.getLocationMap();
    }

    public List<PartitionSpec> getPartitionSpecs() {
        ArrayList<PartitionSpec> partitionSpecs = new ArrayList<PartitionSpec>();
        if (this.segmentFile != null) {
            for (Map.Entry<String, FolderDetails> entry : this.segmentFile.getLocationMap().entrySet()) {
                String location = entry.getKey();
                if (entry.getValue().isRelative) {
                    location = this.tablePath + "/" + location;
                }
                if (!entry.getValue().getStatus().equals(SegmentStatus.SUCCESS.getMessage())) continue;
                partitionSpecs.add(new PartitionSpec((List<String>)entry.getValue().partitions, location));
            }
        }
        return partitionSpecs;
    }

    public static Set<String> getIndexFilesListForSegment(Segment segment, String tablePath) throws IOException {
        Set<String> indexFiles;
        if (segment.getSegmentFileName() == null) {
            String segmentPath = CarbonTablePath.getSegmentPath(tablePath, segment.getSegmentNo());
            indexFiles = new SegmentIndexFileStore().getMergeOrIndexFilesFromSegment(segmentPath).keySet();
        } else {
            SegmentFileStore segmentFileStore = new SegmentFileStore(tablePath, segment.getSegmentFileName());
            indexFiles = segmentFileStore.getIndexOrMergeFiles().keySet();
        }
        return indexFiles;
    }

    public static SegmentFile createSegmentFile(String partitionPath, FolderDetails folderDetails) {
        SegmentFile segmentFile = new SegmentFile();
        segmentFile.addPath(partitionPath, folderDetails);
        return segmentFile;
    }

    public static class FolderDetails
    implements Serializable {
        private static final long serialVersionUID = 501021868886928553L;
        private Set<String> files = new HashSet<String>();
        private List<String> partitions = new ArrayList<String>();
        private String status;
        private String mergeFileName;
        private boolean isRelative;

        public FolderDetails merge(FolderDetails folderDetails) {
            if (this == folderDetails || folderDetails == null) {
                return this;
            }
            if (folderDetails.files != null) {
                this.files.addAll(folderDetails.files);
            }
            if (this.files == null) {
                this.files = folderDetails.files;
            }
            this.partitions = folderDetails.partitions;
            return this;
        }

        public Set<String> getFiles() {
            return this.files;
        }

        public void setFiles(Set<String> files) {
            this.files = files;
        }

        public List<String> getPartitions() {
            return this.partitions;
        }

        public void setPartitions(List<String> partitions) {
            this.partitions = partitions;
        }

        public boolean isRelative() {
            return this.isRelative;
        }

        public void setRelative(boolean relative) {
            this.isRelative = relative;
        }

        public String getMergeFileName() {
            return this.mergeFileName;
        }

        public void setMergeFileName(String mergeFileName) {
            this.mergeFileName = mergeFileName;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }

    public static class SegmentFile
    implements Serializable {
        private static final long serialVersionUID = 3582245668420401089L;
        private Map<String, FolderDetails> locationMap = new HashMap<String, FolderDetails>();
        private Map<String, String> options;
        private String segmentMetaDataInfo;

        public SegmentFile merge(SegmentFile segmentFile) throws IOException {
            if (this == segmentFile) {
                return this;
            }
            if (this.locationMap != null && segmentFile.locationMap != null) {
                for (Map.Entry<String, FolderDetails> entry : segmentFile.locationMap.entrySet()) {
                    FolderDetails folderDetails = this.locationMap.get(entry.getKey());
                    if (folderDetails != null) {
                        folderDetails.merge(entry.getValue());
                        continue;
                    }
                    this.locationMap.put(entry.getKey(), entry.getValue());
                }
                if (this.segmentMetaDataInfo != null) {
                    SegmentMetaDataInfo currentSegmentMetaDataInfo = (SegmentMetaDataInfo)ObjectSerializationUtil.convertStringToObject(this.segmentMetaDataInfo);
                    if (null != segmentFile.getSegmentMetaDataInfo()) {
                        Map<String, SegmentColumnMetaDataInfo> previousBlockColumnMetaDataInfo = segmentFile.getSegmentMetaDataInfo().getSegmentColumnMetaDataInfoMap();
                        for (Map.Entry<String, SegmentColumnMetaDataInfo> entry : previousBlockColumnMetaDataInfo.entrySet()) {
                            if (!currentSegmentMetaDataInfo.getSegmentColumnMetaDataInfoMap().containsKey(entry.getKey())) continue;
                            SegmentColumnMetaDataInfo currentBlockMinMaxInfo = currentSegmentMetaDataInfo.getSegmentColumnMetaDataInfoMap().get(entry.getKey());
                            byte[] blockMaxValue = SegmentMetaDataInfoStats.getInstance().compareAndUpdateMinMax(currentBlockMinMaxInfo.getColumnMaxValue(), entry.getValue().getColumnMaxValue(), false);
                            byte[] blockMinValue = SegmentMetaDataInfoStats.getInstance().compareAndUpdateMinMax(currentBlockMinMaxInfo.getColumnMinValue(), entry.getValue().getColumnMinValue(), true);
                            currentSegmentMetaDataInfo.getSegmentColumnMetaDataInfoMap().get(entry.getKey()).setColumnMaxValue(blockMaxValue);
                            currentSegmentMetaDataInfo.getSegmentColumnMetaDataInfoMap().get(entry.getKey()).setColumnMinValue(blockMinValue);
                        }
                    }
                    this.segmentMetaDataInfo = ObjectSerializationUtil.convertObjectToString(currentSegmentMetaDataInfo);
                }
            }
            if (this.locationMap == null) {
                this.locationMap = segmentFile.locationMap;
            }
            return this;
        }

        public Map<String, FolderDetails> getLocationMap() {
            return this.locationMap;
        }

        void addPath(String path, FolderDetails details) {
            this.locationMap.put(path, details);
        }

        public Map<String, String> getOptions() {
            return this.options;
        }

        public void setOptions(Map<String, String> options) {
            this.options = options;
        }

        public SegmentMetaDataInfo getSegmentMetaDataInfo() {
            SegmentMetaDataInfo newSegmentMetaDataInfo = null;
            try {
                newSegmentMetaDataInfo = (SegmentMetaDataInfo)ObjectSerializationUtil.convertStringToObject(this.segmentMetaDataInfo);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error while getting segment metadata info");
            }
            return newSegmentMetaDataInfo;
        }

        public void setSegmentMetaDataInfo(SegmentMetaDataInfo segmentMetaDataInfo) throws IOException {
            this.segmentMetaDataInfo = ObjectSerializationUtil.convertObjectToString(segmentMetaDataInfo);
        }
    }
}

