/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.blocklet;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex;
import org.apache.hadoop.io.Writable;

public class BlockletInfo
implements Serializable,
Writable {
    private static final long serialVersionUID = 1873135459695635381L;
    private int numberOfRows;
    private List<Long> dimensionChunkOffsets;
    private List<Integer> dimensionChunksLength;
    private List<Long> measureChunkOffsets;
    private List<Integer> measureChunksLength;
    private BlockletIndex blockletIndex;
    private long dimensionOffset;
    private long measureOffsets;
    private int numberOfPages = 1;
    private int[] numberOfRowsPerPage;
    private Boolean isSorted = true;

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public void setNumberOfRows(int numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    public BlockletIndex getBlockletIndex() {
        return this.blockletIndex;
    }

    public void setBlockletIndex(BlockletIndex blockletIndex) {
        this.blockletIndex = blockletIndex;
    }

    public List<Long> getDimensionChunkOffsets() {
        return this.dimensionChunkOffsets;
    }

    public void setDimensionChunkOffsets(List<Long> dimensionChunkOffsets) {
        this.dimensionChunkOffsets = dimensionChunkOffsets;
    }

    public List<Integer> getDimensionChunksLength() {
        return this.dimensionChunksLength;
    }

    public void setDimensionChunksLength(List<Integer> dimensionChunksLength) {
        this.dimensionChunksLength = dimensionChunksLength;
    }

    public List<Long> getMeasureChunkOffsets() {
        return this.measureChunkOffsets;
    }

    public void setMeasureChunkOffsets(List<Long> measureChunkOffsets) {
        this.measureChunkOffsets = measureChunkOffsets;
    }

    public List<Integer> getMeasureChunksLength() {
        return this.measureChunksLength;
    }

    public void setMeasureChunksLength(List<Integer> measureChunksLength) {
        this.measureChunksLength = measureChunksLength;
    }

    public long getDimensionOffset() {
        return this.dimensionOffset;
    }

    public void setDimensionOffset(long dimensionOffset) {
        this.dimensionOffset = dimensionOffset;
    }

    public long getMeasureOffsets() {
        return this.measureOffsets;
    }

    public void setMeasureOffsets(long measureOffsets) {
        this.measureOffsets = measureOffsets;
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(int numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    public void write(DataOutput output) throws IOException {
        int i;
        int i2;
        output.writeLong(this.dimensionOffset);
        output.writeLong(this.measureOffsets);
        int dsize = this.dimensionChunkOffsets != null ? this.dimensionChunkOffsets.size() : 0;
        output.writeShort(dsize);
        for (i2 = 0; i2 < dsize; ++i2) {
            output.writeLong(this.dimensionChunkOffsets.get(i2));
        }
        for (i2 = 0; i2 < dsize; ++i2) {
            output.writeInt(this.dimensionChunksLength.get(i2));
        }
        int mSize = this.measureChunkOffsets != null ? this.measureChunkOffsets.size() : 0;
        output.writeShort(mSize);
        for (i = 0; i < mSize; ++i) {
            output.writeLong(this.measureChunkOffsets.get(i));
        }
        for (i = 0; i < mSize; ++i) {
            output.writeInt(this.measureChunksLength.get(i));
        }
        boolean isSortedPresent = this.isSorted != null;
        output.writeBoolean(isSortedPresent);
        if (isSortedPresent) {
            output.writeBoolean(this.isSorted);
        }
        if (null != this.getNumberOfRowsPerPage()) {
            output.writeShort(this.getNumberOfRowsPerPage().length);
            for (int i3 = 0; i3 < this.getNumberOfRowsPerPage().length; ++i3) {
                output.writeInt(this.getNumberOfRowsPerPage()[i3]);
            }
        } else {
            output.writeShort(0);
        }
    }

    public void readFields(DataInput input) throws IOException {
        short pageCount;
        int i;
        int i2;
        this.dimensionOffset = input.readLong();
        this.measureOffsets = input.readLong();
        int dimensionChunkOffsetsSize = input.readShort();
        this.dimensionChunkOffsets = new ArrayList<Long>(dimensionChunkOffsetsSize);
        for (i2 = 0; i2 < dimensionChunkOffsetsSize; ++i2) {
            this.dimensionChunkOffsets.add(input.readLong());
        }
        this.dimensionChunksLength = new ArrayList<Integer>(dimensionChunkOffsetsSize);
        for (i2 = 0; i2 < dimensionChunkOffsetsSize; ++i2) {
            this.dimensionChunksLength.add(input.readInt());
        }
        int measureChunkOffsetsSize = input.readShort();
        this.measureChunkOffsets = new ArrayList<Long>(measureChunkOffsetsSize);
        for (i = 0; i < measureChunkOffsetsSize; ++i) {
            this.measureChunkOffsets.add(input.readLong());
        }
        this.measureChunksLength = new ArrayList<Integer>(measureChunkOffsetsSize);
        for (i = 0; i < measureChunkOffsetsSize; ++i) {
            this.measureChunksLength.add(input.readInt());
        }
        boolean isSortedPresent = input.readBoolean();
        if (isSortedPresent) {
            this.isSorted = input.readBoolean();
        }
        if ((pageCount = input.readShort()) != 0) {
            this.numberOfRowsPerPage = new int[pageCount];
            for (int i3 = 0; i3 < this.numberOfRowsPerPage.length; ++i3) {
                this.numberOfRowsPerPage[i3] = input.readInt();
            }
        }
    }

    public int[] getNumberOfRowsPerPage() {
        return this.numberOfRowsPerPage;
    }

    public void setNumberOfRowsPerPage(int[] numberOfRowsPerPage) {
        this.numberOfRowsPerPage = numberOfRowsPerPage;
    }

    public Boolean isSorted() {
        return this.isSorted;
    }

    public void setSorted(Boolean sorted) {
        this.isSorted = sorted;
    }
}

