/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.blocklet.index;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class BlockletMinMaxIndex
implements Serializable {
    private static final long serialVersionUID = -4311405145501302895L;
    private byte[][] minValues;
    private byte[][] maxValues;
    private boolean[] isMinMaxSet;

    public BlockletMinMaxIndex() {
    }

    public BlockletMinMaxIndex(List<ByteBuffer> minValues, List<ByteBuffer> maxValues, List<Boolean> isMinMaxSet) {
        this.minValues = new byte[minValues.size()][];
        this.maxValues = new byte[maxValues.size()][];
        for (int i = 0; i < minValues.size(); ++i) {
            this.minValues[i] = minValues.get(i).array();
            this.maxValues[i] = maxValues.get(i).array();
        }
        this.isMinMaxSet = ArrayUtils.toPrimitive((Boolean[])isMinMaxSet.toArray(new Boolean[isMinMaxSet.size()]));
    }

    public byte[][] getMinValues() {
        return this.minValues;
    }

    public void setMinValues(byte[][] minValues) {
        this.minValues = minValues;
    }

    public byte[][] getMaxValues() {
        return this.maxValues;
    }

    public void setMaxValues(byte[][] maxValues) {
        this.maxValues = maxValues;
    }

    public boolean[] getIsMinMaxSet() {
        return this.isMinMaxSet;
    }

    public void setIsMinMaxSet(boolean[] isMinMaxSet) {
        this.isMinMaxSet = isMinMaxSet;
    }
}

